package org.opensha.sra.vulnerability.models.curee.caltech;

/**
 * <strong>Title:</strong> CCSmallHouseRetro<br />
 * <strong>Description</strong> A digital representation of the CUREE-Caltech Woodframe
 * Project small house retrofit Sagm(0.2s,5%) vulnerability function. (CWF-104-0205)
 * 
 * @see CureeCaltechWoodFrame
 * @author <a href="mailto:emartinez@usgs.gov">Eric Martinez</a>
 * @author Keith Porter
 *
 */
public class CCSmallHouseRetro extends CureeCaltechWoodFrame {
	
	private static double [] DF = {
		0.000, 0.000, 0.002, 0.020, 0.037, 0.053, 0.068, 0.082, 0.094, 0.106,
		0.117, 0.127, 0.136, 0.143, 0.150, 0.156, 0.160, 0.164, 0.167, 0.169
	};
	
	private static double[] COVDF = {
		2.50, 2.50, 2.50, 2.50, 2.50, 1.94, 1.63, 1.43, 1.29, 1.18,
		1.11, 1.04, 1.00, 0.96, 0.93, 0.90, 0.88, 0.87, 0.86, 0.85
	};
	
	private static double[][] DEM = {
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.94E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.91E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.87E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.82E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.76E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.68E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.57E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.44E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.28E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 9.08E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 8.85E-001, 9.98E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 8.58E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 8.26E-001, 9.95E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 7.91E-001, 9.93E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 7.52E-001, 9.90E-001, 9.97E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 7.09E-001, 9.86E-001, 9.96E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 6.63E-001, 9.80E-001, 9.94E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 6.15E-001, 9.73E-001, 9.91E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 5.65E-001, 9.64E-001, 9.87E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 5.13E-001, 9.52E-001, 9.82E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 4.62E-001, 9.38E-001, 9.76E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 4.11E-001, 9.21E-001, 9.68E-001, 9.94E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 3.61E-001, 9.00E-001, 9.57E-001, 9.92E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 3.14E-001, 8.75E-001, 9.44E-001, 9.88E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 2.69E-001, 8.47E-001, 9.28E-001, 9.82E-001, 9.96E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 2.28E-001, 8.14E-001, 9.08E-001, 9.75E-001, 9.93E-001, 9.98E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.91E-001, 7.77E-001, 8.85E-001, 9.65E-001, 9.90E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.58E-001, 7.37E-001, 8.58E-001, 9.52E-001, 9.85E-001, 9.95E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.29E-001, 6.93E-001, 8.27E-001, 9.35E-001, 9.77E-001, 9.92E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 1.03E-001, 6.46E-001, 7.91E-001, 9.15E-001, 9.67E-001, 9.88E-001, 9.95E-001, 9.98E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 8.20E-002, 5.97E-001, 7.52E-001, 8.89E-001, 9.53E-001, 9.81E-001, 9.92E-001, 9.97E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 6.41E-002, 5.46E-001, 7.09E-001, 8.59E-001, 9.35E-001, 9.71E-001, 9.87E-001, 9.95E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 4.94E-002, 4.94E-001, 6.64E-001, 8.24E-001, 9.13E-001, 9.58E-001, 9.80E-001, 9.91E-001, 9.95E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 3.75E-002, 4.43E-001, 6.15E-001, 7.84E-001, 8.84E-001, 9.40E-001, 9.69E-001, 9.85E-001, 9.92E-001, 9.96E-001, 9.98E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 2.81E-002, 3.92E-001, 5.65E-001, 7.39E-001, 8.50E-001, 9.17E-001, 9.53E-001, 9.75E-001, 9.86E-001, 9.93E-001, 9.96E-001, 9.97E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001, 1.00E+000, 1.00E+000},
		{0.00E+000, 0.00E+000, 2.07E-002, 3.43E-001, 5.13E-001, 6.89E-001, 8.10E-001, 8.87E-001, 9.33E-001, 9.62E-001, 9.77E-001, 9.87E-001, 9.92E-001, 9.95E-001, 9.96E-001, 9.98E-001, 9.98E-001, 9.99E-001, 9.99E-001, 9.99E-001},
		{0.00E+000, 0.00E+000, 1.50E-002, 2.97E-001, 4.62E-001, 6.36E-001, 7.63E-001, 8.50E-001, 9.05E-001, 9.43E-001, 9.63E-001, 9.78E-001, 9.85E-001, 9.90E-001, 9.93E-001, 9.95E-001, 9.96E-001, 9.97E-001, 9.97E-001, 9.98E-001},
		{0.00E+000, 0.00E+000, 1.08E-002, 2.54E-001, 4.11E-001, 5.80E-001, 7.11E-001, 8.06E-001, 8.70E-001, 9.16E-001, 9.44E-001, 9.64E-001, 9.75E-001, 9.82E-001, 9.87E-001, 9.91E-001, 9.93E-001, 9.94E-001, 9.95E-001, 9.95E-001},
		{0.00E+000, 0.00E+000, 7.59E-003, 2.14E-001, 3.61E-001, 5.22E-001, 6.54E-001, 7.55E-001, 8.27E-001, 8.82E-001, 9.17E-001, 9.44E-001, 9.59E-001, 9.70E-001, 9.77E-001, 9.83E-001, 9.86E-001, 9.88E-001, 9.90E-001, 9.91E-001},
		{0.00E+000, 0.00E+000, 5.27E-003, 1.78E-001, 3.14E-001, 4.64E-001, 5.93E-001, 6.98E-001, 7.76E-001, 8.39E-001, 8.81E-001, 9.15E-001, 9.35E-001, 9.51E-001, 9.62E-001, 9.70E-001, 9.75E-001, 9.78E-001, 9.81E-001, 9.83E-001},
		{0.00E+000, 0.00E+000, 3.60E-003, 1.47E-001, 2.70E-001, 4.07E-001, 5.30E-001, 6.35E-001, 7.17E-001, 7.87E-001, 8.36E-001, 8.77E-001, 9.03E-001, 9.23E-001, 9.38E-001, 9.50E-001, 9.57E-001, 9.62E-001, 9.66E-001, 9.69E-001},
		{0.00E+000, 0.00E+000, 2.43E-003, 1.19E-001, 2.29E-001, 3.51E-001, 4.67E-001, 5.69E-001, 6.52E-001, 7.26E-001, 7.81E-001, 8.28E-001, 8.60E-001, 8.85E-001, 9.04E-001, 9.21E-001, 9.31E-001, 9.37E-001, 9.43E-001, 9.47E-001},
		{0.00E+000, 0.00E+000, 1.61E-003, 9.51E-002, 1.91E-001, 2.99E-001, 4.04E-001, 5.00E-001, 5.82E-001, 6.57E-001, 7.16E-001, 7.69E-001, 8.05E-001, 8.35E-001, 8.59E-001, 8.80E-001, 8.93E-001, 9.02E-001, 9.09E-001, 9.14E-001},
		{0.00E+000, 0.00E+000, 1.05E-003, 7.50E-002, 1.58E-001, 2.50E-001, 3.43E-001, 4.32E-001, 5.09E-001, 5.83E-001, 6.43E-001, 6.99E-001, 7.40E-001, 7.73E-001, 8.01E-001, 8.26E-001, 8.41E-001, 8.53E-001, 8.62E-001, 8.69E-001},
		{0.00E+000, 0.00E+000, 6.75E-004, 5.83E-002, 1.29E-001, 2.06E-001, 2.86E-001, 3.65E-001, 4.36E-001, 5.06E-001, 5.65E-001, 6.21E-001, 6.64E-001, 6.99E-001, 7.31E-001, 7.58E-001, 7.76E-001, 7.90E-001, 8.00E-001, 8.09E-001},
		{0.00E+000, 0.00E+000, 4.27E-004, 4.47E-002, 1.04E-001, 1.67E-001, 2.34E-001, 3.02E-001, 3.65E-001, 4.28E-001, 4.84E-001, 5.38E-001, 5.81E-001, 6.17E-001, 6.49E-001, 6.78E-001, 6.98E-001, 7.13E-001, 7.25E-001, 7.34E-001},
		{0.00E+000, 0.00E+000, 2.66E-004, 3.38E-002, 8.21E-002, 1.33E-001, 1.88E-001, 2.45E-001, 2.98E-001, 3.53E-001, 4.04E-001, 4.53E-001, 4.94E-001, 5.28E-001, 5.61E-001, 5.90E-001, 6.09E-001, 6.25E-001, 6.38E-001, 6.48E-001},
		{0.00E+000, 0.00E+000, 1.63E-004, 2.51E-002, 6.42E-002, 1.04E-001, 1.48E-001, 1.94E-001, 2.37E-001, 2.84E-001, 3.28E-001, 3.70E-001, 4.08E-001, 4.39E-001, 4.69E-001, 4.96E-001, 5.15E-001, 5.30E-001, 5.43E-001, 5.52E-001},
		{0.00E+000, 0.00E+000, 9.83E-005, 1.84E-002, 4.94E-002, 8.03E-002, 1.14E-001, 1.50E-001, 1.84E-001, 2.22E-001, 2.58E-001, 2.93E-001, 3.25E-001, 3.52E-001, 3.79E-001, 4.03E-001, 4.19E-001, 4.34E-001, 4.45E-001, 4.54E-001},
		{0.00E+000, 0.00E+000, 5.84E-005, 1.33E-002, 3.76E-002, 6.07E-002, 8.61E-002, 1.13E-001, 1.39E-001, 1.68E-001, 1.97E-001, 2.25E-001, 2.51E-001, 2.72E-001, 2.95E-001, 3.14E-001, 3.28E-001, 3.41E-001, 3.51E-001, 3.58E-001},
		{0.00E+000, 0.00E+000, 3.41E-005, 9.48E-003, 2.81E-002, 4.50E-002, 6.36E-002, 8.36E-002, 1.03E-001, 1.24E-001, 1.45E-001, 1.66E-001, 1.87E-001, 2.03E-001, 2.20E-001, 2.36E-001, 2.46E-001, 2.57E-001, 2.65E-001, 2.71E-001},
		{0.00E+000, 0.00E+000, 1.96E-005, 6.64E-003, 2.07E-002, 3.28E-002, 4.60E-002, 6.01E-002, 7.33E-002, 8.82E-002, 1.04E-001, 1.19E-001, 1.34E-001, 1.45E-001, 1.58E-001, 1.69E-001, 1.77E-001, 1.85E-001, 1.92E-001, 1.96E-001},
		{0.00E+000, 0.00E+000, 1.11E-005, 4.59E-003, 1.51E-002, 2.35E-002, 3.25E-002, 4.21E-002, 5.10E-002, 6.09E-002, 7.16E-002, 8.14E-002, 9.19E-002, 9.99E-002, 1.09E-001, 1.16E-001, 1.22E-001, 1.28E-001, 1.32E-001, 1.35E-001},
		{0.00E+000, 0.00E+000, 6.18E-006, 3.12E-003, 1.08E-002, 1.65E-002, 2.25E-002, 2.87E-002, 3.44E-002, 4.07E-002, 4.77E-002, 5.39E-002, 6.08E-002, 6.58E-002, 7.16E-002, 7.63E-002, 7.96E-002, 8.37E-002, 8.66E-002, 8.82E-002},
		{0.00E+000, 0.00E+000, 3.39E-006, 2.09E-003, 7.60E-003, 1.13E-002, 1.52E-002, 1.91E-002, 2.25E-002, 2.63E-002, 3.07E-002, 3.43E-002, 3.86E-002, 4.15E-002, 4.50E-002, 4.78E-002, 4.96E-002, 5.22E-002, 5.40E-002, 5.49E-002},
		{0.00E+000, 0.00E+000, 1.83E-006, 1.38E-003, 5.28E-003, 7.66E-003, 1.00E-002, 1.24E-002, 1.43E-002, 1.65E-002, 1.90E-002, 2.10E-002, 2.35E-002, 2.51E-002, 2.71E-002, 2.85E-002, 2.94E-002, 3.10E-002, 3.20E-002, 3.24E-002},
		{0.00E+000, 0.00E+000, 9.70E-007, 8.93E-004, 3.61E-003, 5.07E-003, 6.46E-003, 7.80E-003, 8.84E-003, 9.95E-003, 1.14E-002, 1.23E-002, 1.37E-002, 1.45E-002, 1.55E-002, 1.62E-002, 1.66E-002, 1.74E-002, 1.80E-002, 1.82E-002},
		{0.00E+000, 0.00E+000, 5.06E-007, 5.71E-004, 2.43E-003, 3.30E-003, 4.07E-003, 4.78E-003, 5.29E-003, 5.81E-003, 6.55E-003, 6.94E-003, 7.68E-003, 7.97E-003, 8.47E-003, 8.73E-003, 8.87E-003, 9.33E-003, 9.58E-003, 9.62E-003},
		{0.00E+000, 0.00E+000, 2.60E-007, 3.59E-004, 1.61E-003, 2.10E-003, 2.51E-003, 2.86E-003, 3.07E-003, 3.28E-003, 3.63E-003, 3.76E-003, 4.11E-003, 4.20E-003, 4.41E-003, 4.48E-003, 4.50E-003, 4.73E-003, 4.84E-003, 4.83E-003}
};

	public CCSmallHouseRetro() {
		super("CUREE-Caltech: Small House Retrofit", "CCSmallHouseRetro");
		setInitVars();
		ADF = 0.003;
		BDF = 0.218;
		//NIML = IML.length;
		//register(supportedTypes);
	}

	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getDFArray() {
		return DF;
	}
	@Override
	/**
	 * See the general contract in CureeCaltechWoodFrame.
	 */
	protected double[] getCOVDFArray() {
		return COVDF;
	}
	
	public double[][] getDEMMatrix() {
		return DEM;
	}
}
