package org.opensha.sra.vulnerability.models;

import java.io.Serializable;
import java.util.ArrayList;

import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.util.StatUtil;
import org.opensha.sra.vulnerability.AbstractVulnerability;

/**
 * This is a simple, perhaps temporary class for instantiating AbstractVulerability objects
 * from files.
 * 
 * @author kevin
 *
 */
public class SimpleVulnerability extends AbstractVulnerability implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private ArrayList<Double> mdfVals;
	private ArrayList<Double> covVals;
	private ArrayList<Double> im_levels;
	
	private AbstractDiscretizedFunc vulnFunc;
	private AbstractDiscretizedFunc covFunc;
	
	private static double[] toPrimDoubleArray(ArrayList<Double> vals) {
		double dvals[] = new double[vals.size()];
		
		for (int i=0; i<vals.size(); i++) {
			dvals[i] = vals.get(i);
		}
		return dvals;
	}
	
	public SimpleVulnerability(String name, String shortName, String im_type, ArrayList<Double> im_levels,
			ArrayList<Double> mdfVals, ArrayList<Double> covVals) {
		super(name, shortName, im_type, toPrimDoubleArray(im_levels));
		
		if (im_levels.size() != mdfVals.size())
			throw new IllegalArgumentException("im_levels must be the same size as mdfVals");
		
		if (im_levels.size() != covVals.size())
			throw new IllegalArgumentException("im_levels must be the same size as covVals");
		
		this.im_levels = im_levels;
		this.mdfVals = mdfVals;
		this.covVals = covVals;
		vulnFunc = new ArbitrarilyDiscretizedFunc();
		covFunc = new ArbitrarilyDiscretizedFunc();
		for (int i=0; i<im_levels.size(); i++) {
			vulnFunc.set(im_levels.get(i), mdfVals.get(i));
			covFunc.set(im_levels.get(i), covVals.get(i));
		}
		String funcName = name;
		if (shortName != null && !shortName.equals(name))
			funcName += " ("+shortName+")";
		vulnFunc.setName(funcName);
	}

	@Override
	public double[] getDEMDFVals() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double[][] getDEMMatrix() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double getDF(double IML) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public ArrayList<double[]> getDFTable() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public AbstractDiscretizedFunc getVulnerabilityFunc() {
		return vulnFunc;
	}
	
	@Override
	public String toString() {
		String str = "Simple Vulnurabilty Function: " + this.getName() + " (" + this.getShortName() + ")" + "\n";
		str += "IM Type: " + this.getIMT() + "\n";
		str += "IML\tMDF\tCOV\n";
		for (int i=0; i<im_levels.size(); i++) {
			str += im_levels.get(i) + "\t" + mdfVals.get(i) + "\t" + covVals.get(i) + "\n";
		}
		str += "total vals: " + im_levels.size();
		
		return str;
	}

	@Override
	public double getMeanDamageAtExceedProb(double iml, double prob) {
		// inverse of the cumulative standard normal distribution evaluated at p (like normsinv in Microsoft Excel)
		double invCumStdNormDist = StatUtil.getInvCDF(1-prob, true);
		// coefficient of variation of damage factor at iml
		double d = covFunc.getInterpolatedY(iml);
		// mean damage factor at iml
		double y = this.getMeanDamageFactor(iml);
		// logarithmic standard deviation of damage factor at iml
		double beta = Math.sqrt(Math.log(1 + d*d));
		// median damage factor at iml
		double yhat = y / Math.sqrt(1 + d*d);
		// damage factor at exceedance probability p, given iml
		double yp = yhat * Math.exp(beta*invCumStdNormDist);
		
//		System.out.println("yp: " + yp);
		return yp;
	}
	
	public AbstractDiscretizedFunc getCOVFunction() {
		return covFunc;
	}

	@Override
	public double getMeanDamageFactor(double iml) {
		return vulnFunc.getInterpolatedY(iml);
	}

}
