package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;

import javax.sql.rowset.CachedRowSet;

import oracle.spatial.geometry.JGeometry;

/**
 * This class represents a list of DB_AccessAPI's. The first one that works will be used
 * for all connections. This is ideal for the case where you would prefer a direct DB
 * connection, but it might be blocked by a firewall, in which case you fall back to a
 * servlet brokered connection.
 * 
 * @author kevin
 *
 */
public class PrioritizedDB_Access implements DB_AccessAPI {

	private static final boolean D = false;

	private DB_AccessAPI dbAccess = null;

	public static ArrayList<DB_AccessAPI> createDB2ReadOnlyAccessors() {
		ArrayList<DB_AccessAPI> accessors = new ArrayList<DB_AccessAPI>();
		// first priority is a direct connection
		try {
			accessors.add(new DB_ConnectionPool(DB_ConnectionPool.db_prop_2_file));
		} catch (Throwable t) {
			t.printStackTrace();
		}
		// if that doesn't work we'll try the servlet to get around firewall issues
		try {
			accessors.add(new ServerDB_Access(ServerDB_Access.SERVLET_URL_DB2));
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return accessors;
	}

	public static ArrayList<DB_AccessAPI> createDB3ReadOnlyAccessors() {
		ArrayList<DB_AccessAPI> accessors = new ArrayList<DB_AccessAPI>();
		// first priority is a direct connection
		try {
			accessors.add(new DB_ConnectionPool(DB_ConnectionPool.db_prop_3_ro_file));
		} catch (Throwable t) {
			t.printStackTrace();
		}
		// if that doesn't work we'll try the servlet to get around firewall issues
		try {
			accessors.add(new ServerDB_Access(ServerDB_Access.SERVLET_URL_DB3));
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return accessors;
	}

	public PrioritizedDB_Access(ArrayList<DB_AccessAPI> accessors) {
		for (int i=0; i<accessors.size(); i++) {
			DB_AccessAPI accessor = accessors.get(i);
			boolean success = isAccessorValid(accessor);
			if (success) {
				if (D) System.out.println("DB Accessor " + (i+1) + " successful!");
				dbAccess = accessor;
				break;
			} else {
				System.err.println("DB Accessor " + (i+1) + "/" + accessors.size() + " failed (see above stack trace).");
			}
		}
		if (dbAccess == null) {
			throw new RuntimeException("No valid DB Accessors! (0/" + accessors.size() + " successful)");
		}
	}

	public static boolean isAccessorValid(DB_AccessAPI dbAccess) {
		String sql = "SELECT * FROM Fault_Model where rownum<=1";
		try {
			CachedRowSet rs = dbAccess.queryData(sql);
			rs.first();
		} catch (Throwable t) {
			t.printStackTrace();
			return false;
		}
		return true;
	}

	public int getNextSequenceNumber(String sequenceName) throws SQLException {
		return dbAccess.getNextSequenceNumber(sequenceName);
	}

	public String getSystemDate() throws SQLException {
		return dbAccess.getSystemDate();
	}

	public int insertUpdateOrDeleteData(String sql) throws SQLException {
		return dbAccess.insertUpdateOrDeleteData(sql);
	}
	
	@Override
	public int[] insertUpdateOrDeleteBatch(ArrayList<String> sqls,
			boolean rollbackOnFail) throws SQLException {
		return dbAccess.insertUpdateOrDeleteBatch(sqls, rollbackOnFail);
	}

	public int insertUpdateOrDeleteData(String sql, ArrayList<JGeometry> geometryList)
	throws SQLException {
		return dbAccess.insertUpdateOrDeleteData(sql, geometryList);
	}

	public CachedRowSet queryData(String sql) throws SQLException {
		return dbAccess.queryData(sql);
	}

	public SpatialQueryResult queryData(String sqlWithSpatialColumnNames,
			String sqlWithNoSpatialColumnNames, ArrayList<String> spatialColumnNames)
	throws SQLException {
		return dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
	}

	public int resetPasswordByEmail(String email) throws SQLException {
		return dbAccess.resetPasswordByEmail(email);
	}

	public static void main(String args[]) {
		new PrioritizedDB_Access(PrioritizedDB_Access.createDB2ReadOnlyAccessors());
		System.exit(0);
	}

	@Override
	public void destroy() throws SQLException {
		dbAccess.destroy();
	}

	@Override
	public void destroy(int millis) throws SQLException {
		dbAccess.destroy(millis);
	}

}
