/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc;

import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;

public class FractileCurveCalculator {
    private XY_DataSetList funcList;
    private List<Double> relativeWeights;
    private int num;
    private List<ArbDiscrEmpiricalDistFunc> empiricalDists;
    private static final String ERROR_WEIGHTS = "Error! Number of weights should be equal to number of curves";
    private static final String ERROR_LIST = "No curves exist in the list";
    private static final String ERROR_POINTS = "Number of points in each curve should be same";

    public FractileCurveCalculator(XY_DataSetList functionList, List<Double> relativeWts) {
        this.set(functionList, relativeWts);
    }

    public void set(XY_DataSetList functionList, List<Double> relativeWts) {
        int i;
        if (functionList.size() != relativeWts.size()) {
            throw new RuntimeException(ERROR_WEIGHTS);
        }
        int numFunctions = functionList.size();
        if (numFunctions == 0) {
            throw new RuntimeException(ERROR_LIST);
        }
        int numPoints = ((XY_DataSet)functionList.get(0)).size();
        for (i = 1; i < numFunctions; ++i) {
            if (((XY_DataSet)functionList.get(i)).size() == numPoints) continue;
            throw new RuntimeException(ERROR_POINTS);
        }
        this.funcList = functionList;
        this.relativeWeights = relativeWts;
        this.num = numPoints;
        this.empiricalDists = new ArrayList<ArbDiscrEmpiricalDistFunc>();
        for (i = 0; i < this.num; ++i) {
            ArbDiscrEmpiricalDistFunc empirical = new ArbDiscrEmpiricalDistFunc();
            for (int j = 0; j < numFunctions; ++j) {
                empirical.set(((XY_DataSet)this.funcList.get(j)).getY(i), (double)this.relativeWeights.get(j));
            }
            this.empiricalDists.add(empirical);
        }
    }

    public AbstractXY_DataSet getMeanCurve() {
        int i;
        AbstractXY_DataSet result = (AbstractXY_DataSet)((XY_DataSet)this.funcList.get(0)).deepClone();
        double totWt = 0.0;
        int numPoints = ((XY_DataSet)this.funcList.get(0)).size();
        int numFuncs = this.funcList.size();
        for (i = 0; i < numPoints; ++i) {
            result.set(i, 0.0);
        }
        for (int f = 0; f < numFuncs; ++f) {
            double wt = this.relativeWeights.get(f);
            totWt += wt;
            for (i = 0; i < numPoints; ++i) {
                result.set(i, result.getY(i) + wt * ((XY_DataSet)this.funcList.get(f)).getY(i));
            }
        }
        for (i = 0; i < numPoints; ++i) {
            result.set(i, result.getY(i) / totWt);
        }
        result.setName("Mean");
        return result;
    }

    public AbstractXY_DataSet getMinimumCurve() {
        AbstractXY_DataSet result = (AbstractXY_DataSet)((XY_DataSet)this.funcList.get(0)).deepClone();
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, (double)Double.MAX_VALUE);
        }
        for (int f = 0; f < this.funcList.size(); ++f) {
            for (int i = 0; i < result.size(); ++i) {
                if (!(((XY_DataSet)this.funcList.get(f)).getY(i) < result.getY(i))) continue;
                result.set(i, ((XY_DataSet)this.funcList.get(f)).getY(i));
            }
        }
        result.setName("Minimum");
        return result;
    }

    public AbstractXY_DataSet getMaximumCurve() {
        AbstractXY_DataSet result = (AbstractXY_DataSet)((XY_DataSet)this.funcList.get(0)).deepClone();
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, -1.7976931348623157E308);
        }
        for (int f = 0; f < this.funcList.size(); ++f) {
            for (int i = 0; i < result.size(); ++i) {
                if (!(((XY_DataSet)this.funcList.get(f)).getY(i) > result.getY(i))) continue;
                result.set(i, ((XY_DataSet)this.funcList.get(f)).getY(i));
            }
        }
        result.setName("Maximum");
        return result;
    }

    public ArbitrarilyDiscretizedFunc getStdDev() {
        ArbitrarilyDiscretizedFunc result = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < this.num; ++i) {
            result.set(((XY_DataSet)this.funcList.get(0)).getX(i), this.empiricalDists.get(i).getStdDev());
        }
        result.setName("stdDev");
        return result;
    }

    public AbstractXY_DataSet getFractile(double fraction) {
        AbstractXY_DataSet result = (AbstractXY_DataSet)((XY_DataSet)this.funcList.get(0)).deepClone();
        for (int i = 0; i < this.num; ++i) {
            result.set(((XY_DataSet)this.funcList.get(0)).getX(i), this.empiricalDists.get(i).getDiscreteFractile(fraction));
        }
        result.setName(fraction + " fractile");
        return result;
    }

    public ArbDiscrEmpiricalDistFunc getEmpiricalDist(int xIndex) {
        return this.empiricalDists.get(xIndex);
    }
}

