/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations;

import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;

public abstract class MagAreaRelationship
extends MagScalingRelationship {
    static final String C = "MagAreaRelationship";

    public ArbitrarilyDiscretizedFunc getMagAreaFunction(double areaMin, double areaMax, int numArea) {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        double deltaLogArea = (Math.log10(areaMax) - Math.log10(areaMin)) / (double)(numArea - 1);
        for (int i = 0; i < numArea; ++i) {
            double area = Math.pow(10.0, Math.log10(areaMin) + deltaLogArea * (double)i);
            double mag = this.getMedianMag(area);
            func.set(area, mag);
        }
        func.setName(this.getName());
        func.setInfo("Mag-Area relationship");
        return func;
    }

    @Override
    public abstract double getMedianMag(double var1);

    @Override
    public double getMedianMag(double area, double rake) {
        this.setRake(rake);
        return this.getMedianMag(area);
    }

    @Override
    public abstract double getMagStdDev();

    @Override
    public double getMagStdDev(double rake) {
        this.setRake(rake);
        return this.getMagStdDev();
    }

    public abstract double getMedianArea(double var1);

    public double getMedianArea(double mag, double rake) {
        this.setRake(rake);
        return this.getMedianArea(mag);
    }

    public abstract double getAreaStdDev();

    public double getAreaStdDev(double rake) {
        this.setRake(rake);
        return this.getAreaStdDev();
    }

    @Override
    public double getMedianScale(double mag) {
        return this.getMedianArea(mag);
    }

    @Override
    public double getScaleStdDev() {
        return this.getAreaStdDev();
    }
}

