/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;

public class AH2017InterfaceBilinearMagAreaRel
extends MagAreaRelationship {
    static final String C = "AH2017InterfaceBilinearMagAreaRel";
    public static final String NAME = "Allen and Hayes (2017)";

    @Override
    public double getMedianMag(double area) {
        if (area <= 74000.0) {
            return (Math.log(area) * 0.434294 + 5.62) / 1.22;
        }
        return (Math.log(area) * 0.434294 - 2.23) / 0.31;
    }

    @Override
    public double getMagStdDev() {
        return 0.266;
    }

    @Override
    public double getMedianArea(double mag) {
        if (mag <= 8.63) {
            return Math.pow(10.0, -5.62 + 1.22 * mag);
        }
        return Math.pow(10.0, 2.23 + 0.31 * mag);
    }

    @Override
    public double getAreaStdDev() {
        return 0.256;
    }

    @Override
    public String getName() {
        return "Allen and Hayes (2017) for interface events";
    }
}

