/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;

public class MSF2013InterfaceMagAreaRel
extends MagAreaRelationship {
    static final String C = "MSF2013InterfaceMagAreaRel";
    public static final String NAME = "Murotani et al. (2016)";

    @Override
    public double getMedianMag(double area) {
        double log10Mo = 1.5 * (Math.log10(area) - Math.log10(1.34E-10));
        return (log10Mo - 9.05) / 1.5;
    }

    @Override
    public double getMagStdDev() {
        return Double.NaN;
    }

    @Override
    public double getMedianArea(double mag) {
        double log10Mo = 1.5 * mag + 9.05;
        return Math.pow(10.0, log10Mo / 1.5 + Math.log10(1.34E-10));
    }

    @Override
    public double getAreaStdDev() {
        return 1.54;
    }

    @Override
    public String getName() {
        return "Murotani et al. (2016) for interface events";
    }
}

