/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Stirling_2021_SimplifiedNZ_FaultRegime;

public class Stirling_2021_SimplifiedNZ_MagAreaRel
extends MagAreaRelationship {
    public static final String NAME = "SimplifiedScalingNZNSHM_2021";
    protected Stirling_2021_SimplifiedNZ_FaultRegime faultRegime = Stirling_2021_SimplifiedNZ_FaultRegime.CRUSTAL;
    protected Stirling_2021_SimplifiedNZ_FaultRegime faultType = Stirling_2021_SimplifiedNZ_FaultRegime.NONE;
    protected Stirling_2021_SimplifiedNZ_FaultRegime epistemticBound = Stirling_2021_SimplifiedNZ_FaultRegime.LOWER;

    public Stirling_2021_SimplifiedNZ_MagAreaRel() {
    }

    public Stirling_2021_SimplifiedNZ_MagAreaRel(double initalRake, String initialEpistemticBound) {
        this.setRake(initalRake);
        this.setEpistemicBound(initialEpistemticBound);
    }

    public Stirling_2021_SimplifiedNZ_MagAreaRel(String initialRegime, String initialEpistemticBound) {
        this.setRegime(initialRegime);
        this.setEpistemicBound(initialEpistemticBound);
    }

    @Override
    public void setRake(double rake) {
        super.setRake(rake);
        this.faultType = Stirling_2021_SimplifiedNZ_FaultRegime.fromRake(rake);
    }

    public void setRegime(String regime) {
        this.faultRegime = Stirling_2021_SimplifiedNZ_FaultRegime.fromRegime(regime);
    }

    public void setEpistemicBound(String epistemicBound) {
        this.epistemticBound = Stirling_2021_SimplifiedNZ_FaultRegime.fromEpistemicBound(epistemicBound);
    }

    @Override
    public double getMedianMag(double area) {
        return this.getC4log10A2Mw() + Math.log(area) * 0.434294;
    }

    @Override
    public double getMagStdDev() {
        return Double.NaN;
    }

    @Override
    public double getMedianArea(double mag) {
        return Math.pow(10.0, -this.getC4log10A2Mw() + mag);
    }

    @Override
    public double getAreaStdDev() {
        return Double.NaN;
    }

    private double getC4log10A2Mw() {
        Double rhat = Double.NaN;
        if (this.faultRegime == Stirling_2021_SimplifiedNZ_FaultRegime.CRUSTAL || this.faultRegime == Stirling_2021_SimplifiedNZ_FaultRegime.NONE) {
            if (this.faultType == Stirling_2021_SimplifiedNZ_FaultRegime.NONE || this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.NONE) {
                return Double.NaN;
            }
            if (this.faultType == Stirling_2021_SimplifiedNZ_FaultRegime.STRIKE_SLIP && this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.LOWER) {
                rhat = 3.65;
            } else if (this.faultType == Stirling_2021_SimplifiedNZ_FaultRegime.STRIKE_SLIP && this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.UPPER) {
                rhat = 4.3;
            } else if (this.faultType == Stirling_2021_SimplifiedNZ_FaultRegime.REVERSE_FAULTING && this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.LOWER) {
                rhat = 3.95;
            } else if (this.faultType == Stirling_2021_SimplifiedNZ_FaultRegime.REVERSE_FAULTING && this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.UPPER) {
                rhat = 4.3;
            } else if (this.faultType == Stirling_2021_SimplifiedNZ_FaultRegime.NORMAL_FAULTING && this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.LOWER) {
                rhat = 3.95;
            } else if (this.faultType == Stirling_2021_SimplifiedNZ_FaultRegime.NORMAL_FAULTING && this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.UPPER) {
                rhat = 4.3;
            }
        } else if (this.faultRegime == Stirling_2021_SimplifiedNZ_FaultRegime.SUBDUCTION_INTERFACE) {
            if (this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.LOWER) {
                rhat = 3.6;
            } else if (this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.UPPER) {
                rhat = 4.1;
            } else if (this.epistemticBound == Stirling_2021_SimplifiedNZ_FaultRegime.NONE) {
                return Double.NaN;
            }
        }
        return rhat;
    }

    @Override
    public String getName() {
        return "SimplifiedScalingNZNSHM_2021 " + this.faultType.toString() + " " + this.faultRegime.toString() + " " + this.epistemticBound.toString();
    }
}

