/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.magScalingRelations.magScalingRelImpl;

import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.TMG2017FaultingType;
import org.opensha.commons.exceptions.InvalidRangeException;

public class TMG2017SubMagAreaRel
extends MagAreaRelationship {
    static final String C = "TMG2017SubMagAreaRel";
    public static final String NAME = "Thingbaijam et al.(2017)";
    TMG2017FaultingType faultingType = TMG2017FaultingType.NONE;

    public TMG2017SubMagAreaRel() {
    }

    public TMG2017SubMagAreaRel(double initialRake) {
        this.setRake(initialRake);
    }

    @Override
    public double getMedianMag(double area) {
        if (TMG2017FaultingType.NONE == this.faultingType || TMG2017FaultingType.STRIKE_SLIP == this.faultingType) {
            return Double.NaN;
        }
        if (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType) {
            return 3.469 + 1.054 * Math.log(area) * 0.434294;
        }
        return 3.157 + 1.238 * Math.log(area) * 0.434294;
    }

    @Override
    public double getMagStdDev() {
        if (TMG2017FaultingType.NONE == this.faultingType || TMG2017FaultingType.STRIKE_SLIP == this.faultingType) {
            return Double.NaN;
        }
        if (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType) {
            return 0.15;
        }
        return 0.181;
    }

    @Override
    public double getMedianArea(double mag) {
        if (TMG2017FaultingType.NONE == this.faultingType || TMG2017FaultingType.STRIKE_SLIP == this.faultingType) {
            return Double.NaN;
        }
        if (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType) {
            return Math.pow(10.0, -3.292 + 0.949 * mag);
        }
        return Math.pow(10.0, -2.551 + 0.808 * mag);
    }

    @Override
    public double getAreaStdDev() {
        return this.getMagStdDev();
    }

    @Override
    public void setRake(double rake) {
        super.setRake(rake);
        TMG2017FaultingType type = TMG2017FaultingType.fromRake(rake);
        if (TMG2017FaultingType.NONE == type || TMG2017FaultingType.STRIKE_SLIP == type) {
            throw new InvalidRangeException("Rake angle should be either within (45, 135) for interface or (-45, -135) for inslab-normal events");
        }
        this.faultingType = type;
    }

    @Override
    public String getName() {
        String type = TMG2017FaultingType.NONE == this.faultingType || TMG2017FaultingType.STRIKE_SLIP == this.faultingType ? "InvalidRake" : (TMG2017FaultingType.REVERSE_FAULTING == this.faultingType ? "Interface" : "Inslab-Normal");
        return "Thingbaijam et al.(2017) for " + type + " events";
    }
}

