/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc.nnls;

import org.netlib.util.doubleW;
import org.netlib.util.intW;
import org.opensha.commons.calc.nnls.Nnls;

public class NNLSWrapper {
    private double[] A;
    private double[] A_passed;
    private double[] b_temp;
    private Nnls nnls;
    private int nrows;
    private int ncols;
    private int ndata;
    private double[] w;
    private double[] zz;
    doubleW rnorm;
    int[] index;
    intW mode;
    double[] b;
    double[] x;

    public NNLSWrapper() {
    }

    public NNLSWrapper(double[] A_in, int nrows_in, int ncols_in) {
        if (A_in != null && A_in.length != 0) {
            this.A = new double[A_in.length];
            this.A_passed = new double[A_in.length];
            for (int ii = 0; ii < A_in.length; ++ii) {
                this.A[ii] = A_in[ii];
            }
            this.nrows = nrows_in;
            this.ncols = ncols_in;
            this.initialize();
        }
    }

    public void update(double[] A) {
        if (A.length != this.A.length) {
            System.out.println("Must be same number of elements or specify the rows and columns");
            System.exit(-1);
        }
        System.arraycopy(A, 0, this.A, 0, A.length);
    }

    public void update(double[] A_in, int nrows_in, int ncols_in) {
        if (A_in != null && A_in.length != 0) {
            this.A = new double[A_in.length];
            this.A_passed = new double[A_in.length];
            System.arraycopy(A_in, 0, this.A, 0, A_in.length);
            this.nrows = nrows_in;
            this.ncols = ncols_in;
            this.initialize();
        }
    }

    private void initialize() {
        this.ndata = this.nrows;
        try {
            this.w = new double[this.ncols];
            this.zz = new double[this.nrows];
            this.index = new int[this.ncols];
            this.b = new double[this.nrows];
            this.b_temp = new double[this.nrows];
            this.x = new double[this.ncols];
        }
        catch (Exception e) {
            System.err.println("Caught IOException: " + e.getMessage());
            System.exit(0);
        }
        this.mode = new intW(0);
        this.rnorm = new doubleW(0.0);
    }

    public boolean solve(double[] b, double[] x) {
        if (b.length != this.nrows) {
            System.out.println("NNLS: compute: b is the wrong length");
        }
        if (x.length != this.ncols) {
            System.out.println("NNLS: compute: x is the wrong length");
        }
        System.arraycopy(this.A, 0, this.A_passed, 0, this.A.length);
        System.arraycopy(b, 0, this.b_temp, 0, b.length);
        Nnls.nnls(this.A_passed, 0, this.nrows, this.nrows, this.ncols, this.b_temp, 0, x, 0, this.rnorm, this.w, 0, this.zz, 0, this.index, 0, this.mode);
        return this.mode.val == 1;
    }
}

