/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.util.ExceptionUtils;

@JsonAdapter(value=Adapter.class)
public interface IntegerSampler {
    default public int getRandomInt() {
        return this.getRandomInt(Math.random());
    }

    default public int getRandomInt(Random r) {
        return this.getRandomInt(r.nextDouble());
    }

    public int getRandomInt(double var1);

    public int size();

    public static class Adapter
    extends TypeAdapter<IntegerSampler> {
        private static Gson gson = new GsonBuilder().create();

        public void write(JsonWriter out, IntegerSampler value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("data");
            gson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public IntegerSampler read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            in.beginObject();
            Class<?> type = null;
            IntegerSampler ret = null;
            block12: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "type": {
                        String typeStr = in.nextString();
                        try {
                            type = Class.forName(typeStr);
                            continue block12;
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                    }
                    case "data": {
                        Preconditions.checkNotNull(type, (Object)"type must be specified before adapter data");
                        ret = (IntegerSampler)gson.fromJson(in, type);
                        continue block12;
                    }
                    case "values": {
                        System.err.println("WARNING: deserializing legacy IntegerPDF_Function sampler JSON");
                        Preconditions.checkState((type == null || IntegerPDF_FunctionSampler.class.isAssignableFrom(type) ? 1 : 0) != 0, (String)"Have top level 'values' JSON but type isn't an IntegerPDF_FunctionSampler: %s", type);
                        in.beginArray();
                        ArrayList<Double> vals = new ArrayList<Double>();
                        while (in.hasNext()) {
                            in.beginArray();
                            double x = in.nextDouble();
                            double y = in.nextDouble();
                            Preconditions.checkState(((int)x == vals.size() ? 1 : 0) != 0);
                            vals.add(y);
                            in.endArray();
                        }
                        in.endArray();
                        ret = new IntegerPDF_FunctionSampler(Doubles.toArray(vals));
                        continue block12;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            Preconditions.checkNotNull(ret, (Object)"Missing 'data' and/or 'type' field, can't deserialize");
            return ret;
        }
    }

    public static class ExclusionIntegerSampler
    implements IntegerSampler {
        private int start;
        private int num;
        private HashSet<Integer> except;
        private transient ArbitraryIntegerSampler sampler;

        public ExclusionIntegerSampler(int start, int num, Collection<Integer> except) {
            Preconditions.checkState((num > 0 ? 1 : 0) != 0);
            Preconditions.checkState((except.size() > 0 ? 1 : 0) != 0);
            Preconditions.checkState((num > except.size() ? 1 : 0) != 0);
            this.start = start;
            this.num = num;
            this.except = except instanceof HashSet ? (HashSet<Object>)except : new HashSet<Integer>(except);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkInitSampler() {
            if (this.sampler == null) {
                ExclusionIntegerSampler exclusionIntegerSampler = this;
                synchronized (exclusionIntegerSampler) {
                    if (this.sampler == null) {
                        int index = 0;
                        int[] ints = new int[this.num - this.except.size()];
                        for (int i = 0; i < this.num; ++i) {
                            int val = this.start + i;
                            if (this.except.contains(val)) continue;
                            Preconditions.checkState((index < ints.length ? 1 : 0) != 0, (Object)"At least one excluded value falls outside of the specified range");
                            ints[index++] = val;
                        }
                        Preconditions.checkState((index == ints.length ? 1 : 0) != 0, (Object)"At least one excluded value falls outside of the specified range");
                        this.sampler = new ArbitraryIntegerSampler(ints);
                    }
                }
            }
        }

        @Override
        public int getRandomInt(Random r) {
            this.checkInitSampler();
            return this.sampler.getRandomInt(r);
        }

        @Override
        public int getRandomInt(double randDouble) {
            this.checkInitSampler();
            return this.sampler.getRandomInt(randDouble);
        }

        public ExclusionIntegerSampler getCombinedWith(ExclusionIntegerSampler other) {
            Preconditions.checkState((other.start == this.start ? 1 : 0) != 0);
            Preconditions.checkState((other.num == this.num ? 1 : 0) != 0);
            HashSet<Integer> combExcepts = new HashSet<Integer>(this.except);
            combExcepts.addAll(other.except);
            return new ExclusionIntegerSampler(this.start, this.num, combExcepts);
        }

        @Override
        public int size() {
            this.checkInitSampler();
            return this.sampler.size();
        }
    }

    public static class ArbitraryIntegerSampler
    implements IntegerSampler {
        private int[] ints;

        public ArbitraryIntegerSampler(Collection<Integer> ints) {
            this(Ints.toArray(ints));
        }

        public ArbitraryIntegerSampler(int[] ints) {
            this.ints = ints;
        }

        @Override
        public int getRandomInt(Random r) {
            return this.ints[r.nextInt(this.ints.length)];
        }

        @Override
        public int getRandomInt(double randDouble) {
            return this.ints[(int)(randDouble * (double)this.ints.length)];
        }

        @Override
        public int size() {
            return this.ints.length;
        }
    }

    public static class ContiguousIntegerSampler
    implements IntegerSampler {
        private int start;
        private int num;

        public ContiguousIntegerSampler(int num) {
            this(0, num);
        }

        public ContiguousIntegerSampler(int start, int num) {
            this.start = start;
            this.num = num;
        }

        @Override
        public int getRandomInt(Random r) {
            return this.start + r.nextInt(this.num);
        }

        @Override
        public int getRandomInt(double randDouble) {
            return this.start + (int)(randDouble * (double)this.num);
        }

        @Override
        public int size() {
            return this.num;
        }
    }
}

