/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.TimeSpanChangeListener;
import org.opensha.commons.param.impl.DoubleDiscreteParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;

public class TimeSpan
implements ParameterChangeListener,
Serializable {
    private static final long serialVersionUID = -1567318877618681307L;
    protected static final String C = "TimeSpan";
    public static final String XML_METADATA_NAME = "TimeSpan";
    protected static final boolean D = false;
    protected GregorianCalendar startTimeCal;
    public static final String START_YEAR = "Start Year";
    private IntegerParameter startYearParam;
    private IntegerConstraint startYearConstraint = new IntegerConstraint(0, Integer.MAX_VALUE);
    private static final Integer START_YEAR_DEFAULT = 2003;
    public static final String START_MONTH = "Start Month";
    private IntegerParameter startMonthParam;
    private IntegerConstraint startMonthConstraint = new IntegerConstraint(1, 12);
    private static final Integer START_MONTH_DEFAULT = 1;
    public static final String START_DAY = "Start Day";
    private IntegerParameter startDayParam;
    private static final Integer START_DAY_DEFAULT = 1;
    private IntegerConstraint startDayConstraint = new IntegerConstraint(1, 31);
    public static final String START_HOUR = "Start Hour";
    private IntegerParameter startHourParam;
    private static final Integer START_HOUR_DEFAULT = 0;
    private IntegerConstraint startHourConstraint = new IntegerConstraint(0, 59);
    public static final String START_MINUTE = "Start Minute";
    private IntegerParameter startMinuteParam;
    private static final Integer START_MINUTE_DEFAULT = 0;
    private IntegerConstraint startMinuteConstraint = new IntegerConstraint(0, 59);
    public static final String START_SECOND = "Start Second";
    private IntegerParameter startSecondParam;
    private static final Integer START_SECOND_DEFAULT = 0;
    private IntegerConstraint startSecondConstraint = new IntegerConstraint(0, Integer.MAX_VALUE);
    public static final String START_MILLISECOND = "Start Second";
    private IntegerParameter startMillisecondParam;
    private IntegerConstraint startMillisecondConstraint = new IntegerConstraint(0, 999);
    private static final Integer START_MILLISECOND_DEFAULT = 0;
    public static final String YEARS = "Years";
    public static final String MONTHS = "Months";
    public static final String DAYS = "Days";
    public static final String HOURS = "Hours";
    public static final String MINUTES = "Minutes";
    public static final String SECONDS = "Seconds";
    public static final String MILLISECONDS = "Milliseconds";
    public static final String NONE = "None";
    private static final String START_TIME_ERR = "Start-Time Precision Violation: ";
    private static final String DURATION_UNITS = "Duration Units";
    private static final String DURATION_UNITS_DEFAULT = "Years";
    private StringParameter durationUnitsParam;
    public static final String DURATION = "Duration";
    private static final Double DURATION_DEFAULT = 50.0;
    private DoubleConstraint durationConstraint = new DoubleConstraint(0.0, Double.MAX_VALUE);
    private DoubleParameter durationParam;
    private DoubleDiscreteParameter discreteDurationParam;
    private boolean isDurationDiscrete;
    public static final String START_TIME_PRECISION = "Start-Time Precision";
    private String START_TIME_PRECISION_DEFAULT = "Years";
    private StringParameter startTimePrecisionParam;
    private transient ArrayList changeListeners;

    public TimeSpan(String startTimePrecision, String durationUnits) {
        this.initParams();
        this.setStartTimePrecision(startTimePrecision);
        this.setDurationUnits(durationUnits);
    }

    private void initParams() {
        this.startYearParam = new IntegerParameter(START_YEAR, (ParameterConstraint<Integer>)this.startYearConstraint, START_YEAR_DEFAULT);
        this.startMonthParam = new IntegerParameter(START_MONTH, (ParameterConstraint<Integer>)this.startMonthConstraint, START_MONTH_DEFAULT);
        this.startDayParam = new IntegerParameter(START_DAY, (ParameterConstraint<Integer>)this.startDayConstraint, START_DAY_DEFAULT);
        this.startHourParam = new IntegerParameter(START_HOUR, (ParameterConstraint<Integer>)this.startHourConstraint, START_HOUR_DEFAULT);
        this.startMinuteParam = new IntegerParameter(START_MINUTE, (ParameterConstraint<Integer>)this.startMinuteConstraint, START_MINUTE_DEFAULT);
        this.startSecondParam = new IntegerParameter("Start Second", (ParameterConstraint<Integer>)this.startSecondConstraint, START_SECOND_DEFAULT);
        this.startMillisecondParam = new IntegerParameter("Start Second", (ParameterConstraint<Integer>)this.startMillisecondConstraint, START_MILLISECOND_DEFAULT);
        StringConstraint durationUnitsConstraint = new StringConstraint();
        durationUnitsConstraint.addString("Years");
        durationUnitsConstraint.addString(DAYS);
        durationUnitsConstraint.addString(HOURS);
        durationUnitsConstraint.addString(MINUTES);
        durationUnitsConstraint.addString(SECONDS);
        durationUnitsConstraint.addString(MILLISECONDS);
        durationUnitsConstraint.setNonEditable();
        this.durationUnitsParam = new StringParameter(DURATION_UNITS, durationUnitsConstraint, "Years");
        this.durationParam = new DoubleParameter(DURATION, this.durationConstraint, "Years", DURATION_DEFAULT);
        this.discreteDurationParam = new DoubleDiscreteParameter(DURATION, "Years", DURATION_DEFAULT);
        this.isDurationDiscrete = false;
        StringConstraint precisionConstraint = new StringConstraint();
        precisionConstraint.addString("Years");
        precisionConstraint.addString(MONTHS);
        precisionConstraint.addString(DAYS);
        precisionConstraint.addString(HOURS);
        precisionConstraint.addString(MINUTES);
        precisionConstraint.addString(SECONDS);
        precisionConstraint.addString(MILLISECONDS);
        precisionConstraint.addString(NONE);
        precisionConstraint.setNonEditable();
        this.startTimePrecisionParam = new StringParameter(START_TIME_PRECISION, precisionConstraint, this.START_TIME_PRECISION_DEFAULT);
        this.startYearParam.addParameterChangeListener(this);
        this.startMonthParam.addParameterChangeListener(this);
        this.startDayParam.addParameterChangeListener(this);
        this.startHourParam.addParameterChangeListener(this);
        this.startMinuteParam.addParameterChangeListener(this);
        this.startSecondParam.addParameterChangeListener(this);
        this.startMillisecondParam.addParameterChangeListener(this);
        this.durationParam.addParameterChangeListener(this);
        this.discreteDurationParam.addParameterChangeListener(this);
        this.startTimePrecisionParam.addParameterChangeListener(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStartTimeConstraint(String name, int min, int max) {
        IntegerConstraint constraint = new IntegerConstraint(min, max);
        if (name.equals(START_YEAR)) {
            if (!this.startYearConstraint.isAllowed(min) || !this.startYearConstraint.isAllowed(max)) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): max or min is outside absolute bounds for \"" + name + "\"");
            this.startYearParam.setConstraint(constraint);
            return;
        } else if (name.equals(START_MONTH)) {
            if (!this.startMonthConstraint.isAllowed(min) || !this.startYearConstraint.isAllowed(max)) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): max or min is outside absolute bounds for \"" + name + "\"");
            this.startMonthParam.setConstraint(constraint);
            return;
        } else if (name.equals(START_DAY)) {
            if (!this.startDayConstraint.isAllowed(min) || !this.startYearConstraint.isAllowed(max)) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): max or min is outside absolute bounds for \"" + name + "\"");
            this.startDayParam.setConstraint(constraint);
            return;
        } else if (name.equals(START_HOUR)) {
            if (!this.startHourConstraint.isAllowed(min) || !this.startYearConstraint.isAllowed(max)) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): max or min is outside absolute bounds for \"" + name + "\"");
            this.startHourParam.setConstraint(constraint);
            return;
        } else if (name.equals(START_MINUTE)) {
            if (!this.startMinuteConstraint.isAllowed(min) || !this.startYearConstraint.isAllowed(max)) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): max or min is outside absolute bounds for \"" + name + "\"");
            this.startMinuteParam.setConstraint(constraint);
            return;
        } else if (name.equals("Start Second")) {
            if (!this.startSecondConstraint.isAllowed(min) || !this.startYearConstraint.isAllowed(max)) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): max or min is outside absolute bounds for \"" + name + "\"");
            this.startSecondParam.setConstraint(constraint);
            return;
        } else {
            if (!name.equals("Start Second")) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): invalid name");
            if (!this.startMillisecondConstraint.isAllowed(min) || !this.startYearConstraint.isAllowed(max)) throw new RuntimeException("TimeSpan.setStartTimeConstraint(): max or min is outside absolute bounds for \"" + name + "\"");
            this.startMillisecondParam.setConstraint(constraint);
        }
    }

    private void setStartTimePrecision(String startTimePrecision) {
        this.startTimePrecisionParam.setValue(startTimePrecision);
    }

    private int getStartTimePrecInt() {
        String precisionUnitString = (String)this.startTimePrecisionParam.getValue();
        if (precisionUnitString.equalsIgnoreCase(NONE)) {
            return 0;
        }
        if (precisionUnitString.equalsIgnoreCase("Years")) {
            return 1;
        }
        if (precisionUnitString.equalsIgnoreCase(MONTHS)) {
            return 2;
        }
        if (precisionUnitString.equalsIgnoreCase(DAYS)) {
            return 3;
        }
        if (precisionUnitString.equalsIgnoreCase(HOURS)) {
            return 4;
        }
        if (precisionUnitString.equalsIgnoreCase(MINUTES)) {
            return 5;
        }
        if (precisionUnitString.equalsIgnoreCase(SECONDS)) {
            return 6;
        }
        return 7;
    }

    public String getStartTimePrecision() {
        return (String)this.startTimePrecisionParam.getValue();
    }

    public int getStartTimeFromType(String type) {
        if (type.equals(START_DAY)) {
            return this.getStartTimeDay();
        }
        if (type.equals(START_HOUR)) {
            return this.getStartTimeHour();
        }
        if (type.equals("Start Second")) {
            return this.getStartTimeMillisecond();
        }
        if (type.equals(START_MINUTE)) {
            return this.getStartTimeMinute();
        }
        if (type.equals(START_MONTH)) {
            return this.getStartTimeMonth();
        }
        if (type.equals("Start Second")) {
            return this.getStartTimeSecond();
        }
        if (type.equals(START_YEAR)) {
            return this.getStartTimeYear();
        }
        throw new RuntimeException("Type '" + type + "' is not a valid start time precision!");
    }

    public int getStartTimeYear() throws RuntimeException {
        if (this.getStartTimePrecInt() >= 1) {
            this.checkStartTimeValues();
            return (Integer)this.startYearParam.getValue();
        }
        String str = "cannot use the getStartTimeYear() method because start-time precision is \"";
        String prec = this.getStartTimePrecision();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    public int getStartTimeMonth() throws RuntimeException {
        if (this.getStartTimePrecInt() >= 2) {
            this.checkStartTimeValues();
            return (Integer)this.startMonthParam.getValue();
        }
        String str = "cannot use the getStartTimeMonth() method because start-time precision is \"";
        String prec = this.getStartTimePrecision();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    public int getStartTimeDay() throws RuntimeException {
        if (this.getStartTimePrecInt() >= 3) {
            this.checkStartTimeValues();
            return (Integer)this.startDayParam.getValue();
        }
        String str = "cannot use the getStartTimeDay() method because start-time precision is \"";
        String prec = this.getStartTimePrecision();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    public int getStartTimeHour() throws RuntimeException {
        if (this.getStartTimePrecInt() >= 4) {
            this.checkStartTimeValues();
            return (Integer)this.startHourParam.getValue();
        }
        String str = "cannot use the getStartTimeHour() method because start-time precision is \"";
        String prec = this.getStartTimePrecision();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    public int getStartTimeMinute() throws RuntimeException {
        if (this.getStartTimePrecInt() >= 5) {
            this.checkStartTimeValues();
            return (Integer)this.startMinuteParam.getValue();
        }
        String str = "cannot use the getStartTimeMinute() method because start-time precision is \"";
        String prec = this.getStartTimePrecision();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    public int getStartTimeSecond() throws RuntimeException {
        if (this.getStartTimePrecInt() >= 6) {
            this.checkStartTimeValues();
            return (Integer)this.startSecondParam.getValue();
        }
        String str = "cannot use the getStartTimeSecond() method because start-time precision is \"";
        String prec = this.getStartTimePrecision();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    public int getStartTimeMillisecond() throws RuntimeException {
        if (this.getStartTimePrecInt() >= 7) {
            this.checkStartTimeValues();
            return (Integer)this.startMillisecondParam.getValue();
        }
        String str = "cannot use the getStartTimeMillisecond() method because start-time precision is \"";
        String prec = this.getStartTimePrecision();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    private void setDurationUnits(String durationUnits) {
        this.durationUnitsParam.setValue(durationUnits);
        this.durationParam.setUnits(durationUnits);
        this.discreteDurationParam.setUnits(durationUnits);
    }

    public String getDurationUnits() {
        return (String)this.durationUnitsParam.getValue();
    }

    public void setDuration(double duration) {
        if (this.isDurationDiscrete) {
            this.discreteDurationParam.setValue(duration);
        } else {
            this.durationParam.setValue(duration);
        }
    }

    public void setDuration(double duration, String units) {
        String desiredUnits = (String)this.durationUnitsParam.getValue();
        double newValue = this.convertDurationUnits(duration, units, desiredUnits);
        if (this.isDurationDiscrete) {
            this.discreteDurationParam.setValue(newValue);
        } else {
            this.durationParam.setValue(newValue);
        }
    }

    public void setDuractionConstraint(double min, double max) {
        if (!this.durationConstraint.isAllowed(min) || !this.durationConstraint.isAllowed(min)) {
            throw new RuntimeException("TimeSpansetDuractionConstraint - negative values not allowed");
        }
        DoubleConstraint constraint = new DoubleConstraint(min, max);
        this.durationParam.setConstraint(constraint);
        this.isDurationDiscrete = false;
    }

    public void setDurationConstraint(ArrayList<Double> doubles) {
        for (double d : doubles) {
            if (!(d < 0.0)) continue;
            throw new RuntimeException("TimeSpansetDuractionConstraint - negative values not allowed");
        }
        DoubleDiscreteConstraint constraint = new DoubleDiscreteConstraint(doubles);
        this.discreteDurationParam.setConstraint(constraint);
        this.isDurationDiscrete = true;
    }

    private double convertDurationUnits(double duration, String presentUnits, String desiredUnits) {
        double msecs = presentUnits.equals("Years") ? duration * 365.25 * 24.0 * 60.0 * 60.0 * 1000.0 : (presentUnits.equals(DAYS) ? duration * 24.0 * 60.0 * 60.0 * 1000.0 : (presentUnits.equals(HOURS) ? duration * 60.0 * 60.0 * 1000.0 : (presentUnits.equals(MINUTES) ? duration * 60.0 * 1000.0 : (presentUnits.equals(SECONDS) ? duration * 1000.0 : duration))));
        double outDur = desiredUnits.equals("Years") ? msecs / 3.15576E10 : (desiredUnits.equals(DAYS) ? msecs / 8.64E7 : (desiredUnits.equals(HOURS) ? msecs / 3600000.0 : (desiredUnits.equals(MINUTES) ? msecs / 60000.0 : (desiredUnits.equals(SECONDS) ? msecs / 1000.0 : msecs))));
        return outDur;
    }

    public double getDuration() {
        if (this.isDurationDiscrete) {
            return (Double)this.discreteDurationParam.getValue();
        }
        return (Double)this.durationParam.getValue();
    }

    public double getDuration(String units) {
        String presentUnits = (String)this.durationUnitsParam.getValue();
        double duration = this.isDurationDiscrete ? ((Double)this.discreteDurationParam.getValue()).doubleValue() : ((Double)this.durationParam.getValue()).doubleValue();
        return this.convertDurationUnits(duration, presentUnits, units);
    }

    public void setStartTime(int year) throws RuntimeException {
        if (this.getStartTimePrecInt() != 1) {
            String prec = (String)this.startTimePrecisionParam.getValue();
            String method = "setStartTime(int year)";
            throw new RuntimeException("Start-Time Precision Violation: can't use the " + method + " method because start-time precision is \"" + prec + "\"");
        }
        this.startYearParam.setValue(year);
    }

    public void setStartTime(int year, int month) throws RuntimeException {
        if (this.getStartTimePrecInt() != 2) {
            String prec = (String)this.startTimePrecisionParam.getValue();
            String method = "setStartTime(int year, int month)";
            throw new RuntimeException("Start-Time Precision Violation: can't use the " + method + " method because start-time precision is \"" + prec + "\"");
        }
        this.startYearParam.setValue(year);
        this.startMonthParam.setValue(month);
    }

    public void setStartTime(int year, int month, int day) throws RuntimeException {
        if (this.getStartTimePrecInt() != 3) {
            String prec = (String)this.startTimePrecisionParam.getValue();
            String method = "setStartTime(int year, int month, int day)";
            throw new RuntimeException("Start-Time Precision Violation: can't use the " + method + " method because start-time precision is \"" + prec + "\"");
        }
        this.startYearParam.setValue(year);
        this.startMonthParam.setValue(month);
        this.startDayParam.setValue(day);
    }

    public void setStartTime(int year, int month, int day, int hour) throws RuntimeException {
        if (this.getStartTimePrecInt() != 4) {
            String prec = (String)this.startTimePrecisionParam.getValue();
            String method = "setStartTime(int year, int month, int day, int hour)";
            throw new RuntimeException("Start-Time Precision Violation: can't use the " + method + " method because start-time precision is \"" + prec + "\"");
        }
        this.startYearParam.setValue(year);
        this.startMonthParam.setValue(month);
        this.startDayParam.setValue(day);
        this.startHourParam.setValue(hour);
    }

    public void setStartTime(int year, int month, int day, int hour, int minute) throws RuntimeException {
        if (this.getStartTimePrecInt() != 5) {
            String prec = (String)this.startTimePrecisionParam.getValue();
            String method = "setStartTime(int year, int month, int day, int hour, int minute)";
            throw new RuntimeException("Start-Time Precision Violation: can't use the " + method + " method because start-time precision is \"" + prec + "\"");
        }
        this.startYearParam.setValue(year);
        this.startMonthParam.setValue(month);
        this.startDayParam.setValue(day);
        this.startHourParam.setValue(hour);
        this.startMinuteParam.setValue(minute);
    }

    public void setStartTime(int year, int month, int day, int hour, int minute, int second) throws RuntimeException {
        if (this.getStartTimePrecInt() != 6) {
            String prec = (String)this.startTimePrecisionParam.getValue();
            String method = "setStartTime(int year, int month, int day, int hour, int minute, int second)";
            throw new RuntimeException("Start-Time Precision Violation: can't use the " + method + " method because start-time precision is \"" + prec + "\"");
        }
        this.startYearParam.setValue(year);
        this.startMonthParam.setValue(month);
        this.startDayParam.setValue(day);
        this.startHourParam.setValue(hour);
        this.startMinuteParam.setValue(minute);
        this.startSecondParam.setValue(second);
    }

    public void setStartTime(int year, int month, int day, int hour, int minute, int second, int millisecond) throws RuntimeException {
        if (this.getStartTimePrecInt() != 7) {
            String prec = (String)this.startTimePrecisionParam.getValue();
            String method = "setStartTime(int year, int month, int day, int hour, int minute, int second, int millisecond)";
            throw new RuntimeException("Start-Time Precision Violation: can't use the " + method + " method because start-time precision is \"" + prec + "\"");
        }
        this.startYearParam.setValue(year);
        this.startMonthParam.setValue(month);
        this.startDayParam.setValue(day);
        this.startHourParam.setValue(hour);
        this.startMinuteParam.setValue(minute);
        this.startSecondParam.setValue(second);
        this.startMillisecondParam.setValue(millisecond);
    }

    private void checkStartTimeValues() {
        this.buildStartTimeCalendar();
    }

    private void buildStartTimeCalendar() throws RuntimeException {
        int precisionInt = this.getStartTimePrecInt();
        int year = precisionInt > 0 ? ((Integer)this.startYearParam.getValue()).intValue() : START_YEAR_DEFAULT.intValue();
        int month = precisionInt > 1 ? (Integer)this.startMonthParam.getValue() - 1 : START_MONTH_DEFAULT - 1;
        int day = precisionInt > 2 ? ((Integer)this.startDayParam.getValue()).intValue() : START_DAY_DEFAULT.intValue();
        int hour = precisionInt > 3 ? ((Integer)this.startHourParam.getValue()).intValue() : START_HOUR_DEFAULT.intValue();
        int minute = precisionInt > 4 ? ((Integer)this.startMinuteParam.getValue()).intValue() : START_MINUTE_DEFAULT.intValue();
        int second = precisionInt > 5 ? ((Integer)this.startSecondParam.getValue()).intValue() : START_SECOND_DEFAULT.intValue();
        int millisecond = precisionInt > 6 ? ((Integer)this.startMillisecondParam.getValue()).intValue() : START_MILLISECOND_DEFAULT.intValue();
        this.startTimeCal = new GregorianCalendar();
        this.startTimeCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.startTimeCal.setLenient(false);
        this.startTimeCal.set(0, 1);
        this.startTimeCal.set(1, year);
        this.startTimeCal.set(2, month);
        try {
            this.startTimeCal.set(5, day);
        }
        catch (Exception e) {
            throw new RuntimeException("Calendar Error: Invalid Day for the chosen Month");
        }
        this.startTimeCal.set(11, hour);
        this.startTimeCal.set(12, minute);
        this.startTimeCal.set(13, second);
        this.startTimeCal.set(14, millisecond);
    }

    public void setStartTime(GregorianCalendar cal) {
        if (!cal.getTimeZone().equals(TimeZone.getTimeZone("UTC"))) {
            throw new RuntimeException("calendar must be given in UTC time zone");
        }
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millisecond = cal.get(14);
        if (this.getStartTimePrecInt() == 7) {
            this.setStartTime(year, month, day, hour, minute, second, millisecond);
        } else if (this.getStartTimePrecInt() == 6) {
            this.setStartTime(year, month, day, hour, minute, second);
        } else if (this.getStartTimePrecInt() == 5) {
            this.setStartTime(year, month, day, hour, minute);
        } else if (this.getStartTimePrecInt() == 4) {
            this.setStartTime(year, month, day, hour);
        } else if (this.getStartTimePrecInt() == 3) {
            this.setStartTime(year, month, day);
        } else if (this.getStartTimePrecInt() == 2) {
            this.setStartTime(year, month);
        } else if (this.getStartTimePrecInt() == 1) {
            this.setStartTime(year);
        }
    }

    public GregorianCalendar getEndTimeCalendar() {
        if (this.getStartTimePrecInt() > 0) {
            this.buildStartTimeCalendar();
            Double durMsec = this.getDuration(MILLISECONDS);
            long endTime_mSec = this.startTimeCal.getTime().getTime() + durMsec.longValue();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            cal.setTime(new Date(endTime_mSec));
            return cal;
        }
        String str = "Can't use getEndTime() method because start-time precision = \"";
        String prec = (String)this.startTimePrecisionParam.getValue();
        throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
    }

    public ParameterList getAdjustableParams() {
        ParameterList list = new ParameterList();
        if (this.isDurationDiscrete) {
            list.addParameter(this.discreteDurationParam);
        } else {
            list.addParameter(this.durationParam);
        }
        if (this.getStartTimePrecInt() > 0) {
            list.addParameter(this.startYearParam);
        }
        if (this.getStartTimePrecInt() > 1) {
            list.addParameter(this.startMonthParam);
        }
        if (this.getStartTimePrecInt() > 2) {
            list.addParameter(this.startDayParam);
        }
        if (this.getStartTimePrecInt() > 3) {
            list.addParameter(this.startHourParam);
        }
        if (this.getStartTimePrecInt() > 4) {
            list.addParameter(this.startMinuteParam);
        }
        if (this.getStartTimePrecInt() > 5) {
            list.addParameter(this.startSecondParam);
        }
        if (this.getStartTimePrecInt() > 6) {
            list.addParameter(this.startMillisecondParam);
        }
        return list;
    }

    public GregorianCalendar getStartTimeCalendar() throws RuntimeException {
        if (this.getStartTimePrecInt() == 0) {
            String str = "cannot use the getStartTimeCalendar() method when start-time precision equals \"";
            String prec = (String)this.startTimePrecisionParam.getValue();
            throw new RuntimeException(START_TIME_ERR + str + prec + "\"");
        }
        this.buildStartTimeCalendar();
        return this.startTimeCal;
    }

    public long getStartTimeInMillis() {
        return this.getStartTimeCalendar().getTimeInMillis();
    }

    public void setStartTimeInMillis(long millis) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(millis);
        this.setStartTime(cal);
    }

    public void addParameterChangeListener(TimeSpanChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        EventObject event = new EventObject(this);
        if (this.changeListeners == null) {
            return;
        }
        int numListeners = this.changeListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            TimeSpanChangeListener listener = (TimeSpanChangeListener)this.changeListeners.get(i);
            listener.timeSpanChange(event);
        }
    }

    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement("TimeSpan");
        String precision = this.getStartTimePrecision();
        xml.addAttribute("startTimePrecision", precision);
        ArrayList<String> timeTypes = new ArrayList<String>();
        timeTypes.add(START_DAY);
        timeTypes.add(START_HOUR);
        timeTypes.add("Start Second");
        timeTypes.add(START_MINUTE);
        timeTypes.add(START_MONTH);
        timeTypes.add("Start Second");
        timeTypes.add(START_YEAR);
        Element startTimes = xml.addElement("startTimes");
        int time = 0;
        for (String type : timeTypes) {
            try {
                time = this.getStartTimeFromType(type);
                startTimes.addAttribute(type.replaceAll(" ", ""), "" + time);
            }
            catch (RuntimeException runtimeException) {}
        }
        xml.addAttribute("duration", "" + this.getDuration());
        xml.addAttribute("durationUnits", this.getDurationUnits());
        return root;
    }

    public static TimeSpan fromXMLMetadata(Element el) {
        String precision = el.attribute("startTimePrecision").getValue();
        String units = el.attribute("durationUnits").getValue();
        double duration = Double.parseDouble(el.attribute("duration").getValue());
        TimeSpan span = new TimeSpan(precision, units);
        span.setDuration(duration, units);
        Element startTimes = el.element("startTimes");
        int count = startTimes.attributeCount();
        int num = 0;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int millisecond = -1;
        for (int i = 0; i < count; ++i) {
            Attribute att = startTimes.attribute(i);
            if (att.getName().equals(START_DAY.replaceAll(" ", ""))) {
                day = Integer.parseInt(att.getValue());
                ++num;
                continue;
            }
            if (att.getName().equals(START_HOUR.replaceAll(" ", ""))) {
                hour = Integer.parseInt(att.getValue());
                ++num;
                continue;
            }
            if (att.getName().equals("Start Second".replaceAll(" ", ""))) {
                millisecond = Integer.parseInt(att.getValue());
                ++num;
                continue;
            }
            if (att.getName().equals(START_MINUTE.replaceAll(" ", ""))) {
                minute = Integer.parseInt(att.getValue());
                ++num;
                continue;
            }
            if (att.getName().equals(START_MONTH.replaceAll(" ", ""))) {
                month = Integer.parseInt(att.getValue());
                ++num;
                continue;
            }
            if (att.getName().equals("Start Second".replaceAll(" ", ""))) {
                second = Integer.parseInt(att.getValue());
                ++num;
                continue;
            }
            if (!att.getName().equals(START_YEAR.replaceAll(" ", ""))) continue;
            year = Integer.parseInt(att.getValue());
            ++num;
        }
        if (num == 1) {
            span.setStartTime(year);
        } else if (num == 2) {
            span.setStartTime(year, month);
        } else if (num == 3) {
            span.setStartTime(year, month, day);
        } else if (num == 4) {
            span.setStartTime(year, month, day, hour);
        } else if (num == 5) {
            span.setStartTime(year, month, day, hour, minute);
        } else if (num == 6) {
            span.setStartTime(year, month, day, hour, minute, second);
        } else if (num == 7) {
            span.setStartTime(year, month, day, hour, minute, second, millisecond);
        }
        return span;
    }
}

