/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.commons.math3.util.Precision;
import org.dom4j.Element;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.WeightedValue;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.metadata.XMLSaveable;

public class WeightedList<E>
extends AbstractList<WeightedValue<E>>
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "WeightedList";
    protected List<WeightedValue<E>> list;
    private boolean forceNormalization = false;
    private double weightValueMin = 0.0;
    private double weightValueMax = 1.0;
    private IntegerPDF_FunctionSampler sampler = null;

    @SafeVarargs
    public static <E> Unmodifiable<E> evenlyWeighted(E ... values) {
        List<WeightedValue<WeightedValue<E>>> list;
        switch (values.length) {
            case 0: {
                list = List.of();
                break;
            }
            case 1: {
                list = List.of(new WeightedValue<E>(values[0], 1.0));
                break;
            }
            case 2: {
                list = List.of(new WeightedValue<E>(values[0], 0.5), new WeightedValue<E>(values[1], 0.5));
                break;
            }
            default: {
                list = new ArrayList(values.length);
                double weightEach = 1.0 / (double)values.length;
                for (E val : values) {
                    list.add(new WeightedValue<E>(val, weightEach));
                }
                list = Collections.unmodifiableList(list);
            }
        }
        return new Unmodifiable(list, false);
    }

    @SafeVarargs
    public static <E> Unmodifiable<E> of(WeightedValue<E> ... values) {
        return new Unmodifiable<E>(List.of(values), false);
    }

    public WeightedList(List<WeightedValue<E>> list) {
        this.setAll(list);
    }

    private WeightedList(List<WeightedValue<E>> list, boolean validate) {
        this.setAll(list, validate);
    }

    public WeightedList(int initialCapacity) {
        this.setAll(new ArrayList<WeightedValue<E>>(initialCapacity), false);
    }

    public WeightedList() {
        this.setAll(new ArrayList<WeightedValue<E>>(), false);
    }

    public WeightedList(List<E> objects, List<Double> weights) {
        List<WeightedValue<E>> list = WeightedList.buildList(objects, weights);
        this.setAll(list);
    }

    private static <E> List<WeightedValue<E>> buildList(List<E> values, List<Double> weights) {
        if (values == null) {
            throw new IllegalArgumentException("values cannot be null!");
        }
        if (weights == null) {
            throw new IllegalArgumentException("weights list cannot be null!");
        }
        if (values.size() != weights.size()) {
            throw new IllegalStateException("object and weight lists must be the same size!");
        }
        ArrayList<WeightedValue<WeightedValue<E>>> ret = new ArrayList<WeightedValue<WeightedValue<E>>>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            ret.add(new WeightedValue<E>(values.get(i), weights.get(i)));
        }
        return ret;
    }

    private void validate(List<? extends WeightedValue<?>> list) throws IllegalStateException, IllegalArgumentException {
        if (list == null) {
            throw new IllegalArgumentException("list cannot be null!");
        }
        if (this.forceNormalization && list.size() > 0 && !WeightedList.isNormalized(list)) {
            throw new IllegalStateException("weights must sum to 1 (current sum: " + this.getWeightSum() + ")");
        }
        for (WeightedValue<?> value : list) {
            double weight = value.weight;
            if (this.isWeightWithinRange(weight)) continue;
            throw new IllegalArgumentException("weight of '" + weight + "' is outside of range " + this.weightValueMin + " <= weight <= " + this.weightValueMax);
        }
    }

    public void add(E object, double weight) throws IllegalStateException {
        this.add(new WeightedValue<E>(object, weight));
    }

    public void setWeights(List<Double> newWeights) throws IllegalStateException {
        Preconditions.checkState((newWeights.size() == this.list.size() ? 1 : 0) != 0, (Object)"Passed in weights is of unexpected size");
        ArrayList modList = new ArrayList();
        for (int i = 0; i < this.list.size(); ++i) {
            modList.add(new WeightedValue(this.list.get((int)i).value, newWeights.get(i)));
        }
        this.setAll(modList);
    }

    public void setValues(List<E> values) throws IllegalStateException {
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        Preconditions.checkState((values.size() == this.list.size() ? 1 : 0) != 0, (Object)"Passed in values is of unexpected size");
        ArrayList<WeightedValue<WeightedValue<E>>> modList = new ArrayList<WeightedValue<WeightedValue<E>>>();
        for (int i = 0; i < this.list.size(); ++i) {
            modList.add(new WeightedValue<E>(values.get(i), this.list.get((int)i).weight));
        }
        this.setAll(modList);
    }

    public void setWeight(int i, double weight) {
        WeightedValue<E> orig = this.list.get(i);
        this.list.set(i, new WeightedValue(orig.value, weight));
        try {
            this.validate(this.list);
            this.sampler = null;
        }
        catch (RuntimeException e) {
            this.list.set(i, orig);
            throw e;
        }
    }

    public void setAll(List<WeightedValue<E>> list) {
        this.setAll(list, true);
    }

    private void setAll(List<WeightedValue<E>> list, boolean validate) {
        if (validate) {
            this.validate(list);
        }
        this.list = list;
        this.sampler = null;
    }

    public void setAll(List<E> objects, List<Double> weights) throws IllegalStateException {
        List<WeightedValue<E>> list = WeightedList.buildList(objects, weights);
        this.setAll(list);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public double getWeight(int i) {
        return this.list.get((int)i).weight;
    }

    public double getWeight(E object) {
        if (object == null) {
            throw new NoSuchElementException();
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (!object.equals(this.list.get((int)i).value)) continue;
            return this.getWeight(i);
        }
        throw new NoSuchElementException();
    }

    public E getValue(int i) {
        return this.list.get((int)i).value;
    }

    @Override
    public WeightedValue<E> get(int index) {
        return this.list.get(index);
    }

    @Override
    public WeightedValue<E> set(int index, WeightedValue<E> element) {
        WeightedValue<E> prev = this.list.set(index, element);
        try {
            this.validate(this.list);
            this.sampler = null;
        }
        catch (RuntimeException e) {
            this.list.set(index, prev);
            throw e;
        }
        return prev;
    }

    @Override
    public void add(int index, WeightedValue<E> element) {
        this.list.add(index, element);
        try {
            this.validate(this.list);
            this.sampler = null;
        }
        catch (RuntimeException e) {
            this.list.remove(index);
            throw e;
        }
    }

    public boolean areWeightsEqual() {
        if (this.list.size() == 0) {
            return true;
        }
        double wt0 = this.list.get((int)0).weight;
        for (WeightedValue<E> val : this.list) {
            if (val.weight == wt0) continue;
            return false;
        }
        return true;
    }

    public void setWeightsEqual() {
        if (this.areWeightsEqual()) {
            return;
        }
        double wt = 1.0 / (double)this.size();
        this.setWeightsToConstant(wt);
    }

    public void setWeightsToConstant(double weight) {
        ArrayList<Double> newWeights = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            newWeights.add(weight);
        }
        this.setWeights(newWeights);
    }

    public void normalize() {
        double sum = this.getWeightSum();
        if (Precision.equals((double)sum, (double)1.0, (double)1.0E-4)) {
            return;
        }
        Preconditions.checkState((sum > 0.0 && Double.isFinite(sum) ? 1 : 0) != 0, (String)"Cannot normalize, weight sum must be finite and positive: %s", (Object)sum);
        ArrayList normalized = new ArrayList(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            WeightedValue<E> orig = this.list.get(i);
            normalized.add(new WeightedValue(orig.value, orig.weight / sum));
        }
        this.setAll(normalized);
    }

    public double getWeightSum() {
        return WeightedList.getWeightSum(this.list);
    }

    private static double getWeightSum(List<? extends WeightedValue<?>> list) {
        double sum = 0.0;
        for (WeightedValue<?> val : list) {
            sum += val.weight;
        }
        return sum;
    }

    public boolean isNormalized() {
        return WeightedList.isNormalized(this.list);
    }

    private static boolean isNormalized(List<? extends WeightedValue<?>> list) {
        float sum = (float)WeightedList.getWeightSum(list);
        return sum == 1.0f;
    }

    public void setForceNormalization(boolean forceNormalization) {
        this.forceNormalization = forceNormalization;
        if (forceNormalization) {
            this.normalize();
        }
    }

    public boolean isForceNormalization() {
        return this.forceNormalization;
    }

    public static String getName(Object obj) {
        if (obj instanceof Named) {
            return ((Named)obj).getName();
        }
        return obj.toString();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("WeightedList[");
        for (int i = 0; i < this.size(); ++i) {
            Object val = this.get(i);
            if (i > 0) {
                str.append("; ");
            }
            str.append(WeightedList.getName(((WeightedValue)val).value)).append(", ").append((float)((WeightedValue)val).weight);
        }
        str.append("]");
        return str.toString();
    }

    public double getWeightValueMin() {
        return this.weightValueMin;
    }

    public void setWeightValueMin(double weightValueMin) {
        if (weightValueMin > this.weightValueMax) {
            throw new IllegalArgumentException("min cannot be greater than max!");
        }
        double oldVal = this.weightValueMin;
        this.weightValueMin = weightValueMin;
        try {
            this.validate(this.list);
        }
        catch (RuntimeException e) {
            this.weightValueMin = oldVal;
            throw e;
        }
    }

    public double getWeightValueMax() {
        return this.weightValueMax;
    }

    public void setWeightValueMax(double weightValueMax) {
        if (weightValueMax < this.weightValueMin) {
            throw new IllegalArgumentException("max cannot be less than min!");
        }
        double oldVal = this.weightValueMax;
        this.weightValueMax = weightValueMax;
        try {
            this.validate(this.list);
        }
        catch (RuntimeException e) {
            this.weightValueMax = oldVal;
            throw e;
        }
    }

    public boolean isWeightWithinRange(double weight) {
        return (float)weight <= (float)this.weightValueMax && (float)weight >= (float)this.weightValueMin;
    }

    public double getWeightedAverage(List<Double> values) {
        if (values.size() != this.list.size()) {
            throw new IllegalArgumentException("values.size() != weights.size()");
        }
        double weighted = 0.0;
        for (int i = 0; i < values.size(); ++i) {
            double val = values.get(i);
            double weight = this.list.get((int)i).weight;
            weighted += val * weight;
        }
        return weighted;
    }

    public double getWeightedAverage(double[] values) {
        if (values.length != this.list.size()) {
            throw new IllegalArgumentException("values.size() != weights.size()");
        }
        double weighted = 0.0;
        for (int i = 0; i < values.length; ++i) {
            double val = values[i];
            double weight = this.list.get((int)i).weight;
            weighted += val * weight;
        }
        return weighted;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        for (int i = 0; i < this.size(); ++i) {
            Element valEl = el.addElement("Element");
            valEl.addAttribute("index", "" + i);
            valEl.addAttribute("name", WeightedList.getName(this.getValue(i)));
            valEl.addAttribute("weight", "" + this.getWeight(i));
        }
        return root;
    }

    public void setWeightsFromXMLMetadata(Element el) {
        ArrayList<Double> weights = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            weights.add(null);
        }
        for (Element valEl : el.elements()) {
            int valI = Integer.parseInt(valEl.attributeValue("index"));
            double weight = Double.parseDouble(valEl.attributeValue("weight"));
            weights.set(valI, weight);
        }
        for (Double weight : weights) {
            if (weight != null) continue;
            throw new IllegalArgumentException("Given XML element doesn't have a mapping for each element!");
        }
        this.setWeights(weights);
    }

    public E sample() {
        return this.sample(Math.random());
    }

    public E sample(Random rand) {
        return this.sample(rand.nextDouble());
    }

    public E sample(double randDouble) {
        Preconditions.checkState((this.size() > 0 ? 1 : 0) != 0);
        if (this.size() == 1) {
            return this.list.get((int)0).value;
        }
        if (this.sampler == null) {
            double[] weights = new double[this.list.size()];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = this.list.get((int)i).weight;
            }
            this.sampler = new IntegerPDF_FunctionSampler(weights);
        }
        int index = this.sampler.getRandomInt(randDouble);
        return this.list.get((int)index).value;
    }

    public static class Unmodifiable<E>
    extends WeightedList<E> {
        public Unmodifiable(WeightedList<E> list) {
            super(list, false);
        }

        public Unmodifiable(List<WeightedValue<E>> list, boolean validate) {
            super(list, validate);
        }

        @Override
        public void add(E object, double weight) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeights(List<Double> newWeights) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValues(List<E> values) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeight(int i, double weight) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAll(List<WeightedValue<E>> list) {
            if (this.list != null) {
                throw new UnsupportedOperationException();
            }
            super.setAll(list);
        }

        @Override
        public void setAll(List<E> objects, List<Double> weights) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public WeightedValue<E> set(int index, WeightedValue<E> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, WeightedValue<E> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeightsEqual() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeightsToConstant(double weight) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setForceNormalization(boolean forceNormalization) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeightValueMin(double weightValueMin) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeightValueMax(double weightValueMax) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeightsFromXMLMetadata(Element el) {
            throw new UnsupportedOperationException();
        }
    }
}

