/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.comcat;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.EventWebService;
import gov.usgs.earthquake.event.UrlUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opensha.commons.data.comcat.ComcatEventWebService;
import org.opensha.commons.data.comcat.EdgeRuptureSurface;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

public class ShakeMapFiniteFaultAccessor {
    private static final boolean D = true;
    private static final double MAX_GRID_SPACING = 1.0;
    private EventWebService service;

    private static EventWebService buildService() {
        try {
            URL serviceURL = new URL("https://earthquake.usgs.gov/fdsnws/event/1/");
            URL feedURL = new URL("https://earthquake.usgs.gov/earthquakes/feed/v1.0/detail/");
            return new ComcatEventWebService(serviceURL, feedURL);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public ShakeMapFiniteFaultAccessor() {
        this(ShakeMapFiniteFaultAccessor.buildService());
    }

    public ShakeMapFiniteFaultAccessor(EventWebService service) {
        this.service = service;
    }

    public LocationList[] fetchShakemapSourceOutlines(String eventID) {
        return this.fetchShakemapSourceOutlines(eventID, -1);
    }

    public LocationList[] fetchShakemapSourceOutlines(String eventID, int version) {
        block22: {
            List events;
            EventQuery query = new EventQuery();
            query.setEventId(eventID);
            try {
                events = this.service.getEvents(query);
                Preconditions.checkState((!events.isEmpty() ? 1 : 0) != 0, (Object)"Event not found");
            }
            catch (Exception e) {
                System.err.println("Could not retrieve event '" + eventID + "' from Comcat");
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkState((events.size() == 1 ? 1 : 0) != 0, (Object)("More that 1 match? " + events.size()));
            JSONObject obj = (JSONObject)events.get(0);
            JSONObject prop = (JSONObject)obj.get((Object)"properties");
            JSONObject prods = (JSONObject)prop.get((Object)"products");
            JSONArray shakemaps = (JSONArray)prods.get((Object)"shakemap");
            if (shakemaps != null) {
                JSONObject shakemap;
                if (shakemaps.size() > 1 || version >= 0) {
                    if (version < 0) {
                        System.out.println("Found " + shakemaps.size() + " ShakeMaps, using most preferred");
                    }
                    shakemap = null;
                    double maxWeight = Double.NEGATIVE_INFINITY;
                    String bestVersion = null;
                    for (int i = 0; i < shakemaps.size(); ++i) {
                        JSONObject smObj = (JSONObject)shakemaps.get(i);
                        String smVersionStr = ((JSONObject)smObj.get((Object)"properties")).get((Object)"version").toString();
                        int smVersion = smVersionStr.contains(".") ? (int)Double.parseDouble(smVersionStr) : Integer.parseInt(smVersionStr);
                        if (version >= 0) {
                            if (smVersion != version) continue;
                            System.out.println("Found specified ShakeMap, version " + version);
                            shakemap = smObj;
                            break;
                        }
                        double weight = Double.parseDouble(smObj.get((Object)"preferredWeight").toString());
                        System.out.println("\tVersion " + smVersionStr + ", weight=" + (int)weight);
                        if (!(weight > maxWeight)) continue;
                        maxWeight = weight;
                        shakemap = smObj;
                        bestVersion = smVersionStr;
                    }
                    if (version < 0) {
                        System.out.println("Using best version (" + bestVersion + ") with weight=" + (int)maxWeight);
                    } else if (shakemap == null) {
                        System.out.println("Didn't find ShakeMap with version=" + version);
                    }
                } else {
                    shakemap = (JSONObject)shakemaps.get(0);
                }
                if (shakemap == null) {
                    return null;
                }
                JSONObject contents = (JSONObject)shakemap.get((Object)"contents");
                JSONObject fault = null;
                if (contents != null) {
                    Set keys = contents.keySet();
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        String str = i.next().toString();
                        if (str.toLowerCase().endsWith("fault.txt")) {
                            System.out.println(str);
                            fault = (JSONObject)contents.get((Object)str);
                            System.out.println(fault.get((Object)"url"));
                            break;
                        }
                        if (!str.toLowerCase().endsWith("rupture.json")) continue;
                        System.out.println(str);
                        fault = (JSONObject)contents.get((Object)str);
                        System.out.println(fault.get((Object)"url"));
                        break;
                    }
                    if (fault != null) {
                        URL url;
                        String urlStr = fault.get((Object)"url").toString().trim();
                        try {
                            url = new URL(urlStr);
                        }
                        catch (MalformedURLException e) {
                            System.err.println("Error resolving ShakeMap finite fault URL");
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                        try {
                            if (urlStr.toLowerCase().endsWith(".txt")) {
                                return ShakeMapFiniteFaultAccessor.parseFaultTextFile(url);
                            }
                            if (urlStr.toLowerCase().endsWith(".json")) {
                                return ShakeMapFiniteFaultAccessor.parseFaultJSON(url);
                            }
                            break block22;
                        }
                        catch (IOException e) {
                            System.out.println("No Shakemap");
                            System.err.println("Error loading ShakeMap finite fault file");
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                    }
                    System.out.println("Shakemap exists, but no finite fault");
                }
            }
        }
        System.out.println("No Shakemap");
        return null;
    }

    public RuptureSurface fetchShakemapSourceSurface(String eventID) {
        return this.fetchShakemapSourceSurface(eventID, -1);
    }

    public RuptureSurface fetchShakemapSourceSurface(String eventID, int version) {
        LocationList[] outlines = this.fetchShakemapSourceOutlines(eventID);
        if (outlines == null) {
            return null;
        }
        ArrayList<EdgeRuptureSurface> surfs = new ArrayList<EdgeRuptureSurface>();
        for (LocationList outline : outlines) {
            surfs.add(EdgeRuptureSurface.build(outline, 1.0));
        }
        if (surfs.size() == 1) {
            return (RuptureSurface)surfs.get(0);
        }
        return new CompoundSurface(surfs);
    }

    private static LocationList[] parseFaultTextFile(URL url) throws IOException {
        String text = IOUtils.toString((URL)url, (String)"UTF-8");
        String[] lines = text.split("\n");
        ArrayList<LocationList> outlines = new ArrayList<LocationList>();
        LocationList curLocs = new LocationList();
        for (String line : lines) {
            if ((line = line.trim()).startsWith(">") || line.startsWith("#") || line.isEmpty()) {
                if (curLocs.isEmpty()) continue;
                outlines.add(curLocs);
                curLocs = new LocationList();
                continue;
            }
            String[] split = line.split(" ");
            Preconditions.checkState((split.length == 3 ? 1 : 0) != 0, (String)"Unexpected line in ShakeMap finite fault file: %s", (Object)line);
            Location loc = new Location(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
            curLocs.add(loc);
        }
        if (!curLocs.isEmpty()) {
            outlines.add(curLocs);
        }
        System.out.println("Found surface from " + outlines.size() + " outline polygons");
        Preconditions.checkState((!outlines.isEmpty() ? 1 : 0) != 0, (Object)"No surfaces found");
        return outlines.toArray(new LocationList[0]);
    }

    private static LocationList[] parseFaultJSON(URL url) throws IOException {
        System.out.println("Parsing " + String.valueOf(url));
        InputStream input = UrlUtil.getInputStream((URL)url);
        if (input instanceof BufferedInputStream) {
            input = new BufferedInputStream(input);
        }
        Gson gson = FeatureCollection.buildGson(Geometry.DepthSerializationType.DEPTH_KM);
        FeatureCollection collection = (FeatureCollection)gson.fromJson((Reader)new InputStreamReader(input), FeatureCollection.class);
        ArrayList<LocationList> ret = new ArrayList<LocationList>();
        for (Feature feature : collection.features) {
            Geometry geom = feature.geometry;
            System.out.println("Parsing feature with geometry type " + String.valueOf((Object)geom.type));
            if (geom instanceof Geometry.Polygon) {
                Geometry.Polygon poly = (Geometry.Polygon)geom;
                if (poly.polygon != null) {
                    ret.add(poly.polygon);
                }
                if (poly.holes == null) continue;
                for (LocationList hole : poly.holes) {
                    ret.add(hole);
                }
                continue;
            }
            if (geom instanceof Geometry.MultiPolygon) {
                for (Geometry.Polygon poly : ((Geometry.MultiPolygon)geom).polygons) {
                    if (poly == null) continue;
                    ret.add(poly.polygon);
                    if (poly.holes == null) continue;
                    for (LocationList hole : poly.holes) {
                        ret.add(hole);
                    }
                }
                continue;
            }
            if (geom instanceof Geometry.Point) {
                System.out.println("Found Point geometry, skipping ShakeMap surface entirely");
                return null;
            }
            throw new IllegalStateException("Unexpected ShakeMap geometry type: " + String.valueOf((Object)geom.type));
        }
        System.out.println("Fetched " + ret.size() + " outlines");
        return ret.toArray(new LocationList[0]);
    }

    public static void main(String[] args) throws IOException {
        ShakeMapFiniteFaultAccessor source = new ShakeMapFiniteFaultAccessor();
        LocationList[] outlineArray = source.fetchShakemapSourceOutlines("ci38457511", 14);
        ArrayList<LocationList> outlines = new ArrayList<LocationList>();
        for (LocationList outline : outlineArray) {
            outlines.add(outline);
        }
        Geometry.MultiLineString geom = new Geometry.MultiLineString(outlines);
        Feature feature = new Feature(geom, null);
        System.out.println("\n\n" + feature.toJSON() + "\n");
    }
}

