/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.comcat.plot;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.magComplete.Helmstetter2006_TimeDepMc;
import org.opensha.sha.earthquake.observedEarthquake.magComplete.TimeDepMagComplete;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class ComcatDataPlotter {
    private ObsEqkRupture mainshock;
    private List<? extends ObsEqkRupture> foreshocks;
    private List<? extends ObsEqkRupture> aftershocks;
    private long originTime;
    private long endTime;
    static final double MILLISEC_PER_YEAR = 3.15576E10;
    static final long MILLISEC_PER_DAY = 86400000L;
    private static final DecimalFormat optionalDigitDF = new DecimalFormat("0.##");
    private EvenlyDiscretizedFunc timeDiscretization;
    private boolean timeDays;
    private double modelMc = Double.NEGATIVE_INFINITY;
    private Color dataColor = Color.RED;
    private boolean noTitles = false;
    private Double timeFuncMaxY = null;
    private Map<Double, String> timeFuncAnns = null;
    private CPT baseCPT;
    private Double minPlotProb;
    private Color foreshockColor = Color.MAGENTA.darker();
    private Color mainshockColor = new Color(86, 44, 0);
    private Color aftershockColor = Color.CYAN.darker();
    private static double[] fractiles = new double[]{0.025, 0.16, 0.84, 0.975};
    private boolean plotIncludeMean = true;
    private boolean plotIncludeMedian = true;
    private boolean plotIncludeMode = true;
    private boolean mapDrawCA = true;
    private static final int saturation_steps = 1;
    private static final boolean linear_mag_time_prob = false;

    public ComcatDataPlotter(ObsEqkRupture mainshock, List<? extends ObsEqkRupture> foreshocks, List<? extends ObsEqkRupture> aftershocks) {
        this(mainshock, mainshock.getOriginTime(), System.currentTimeMillis(), foreshocks, aftershocks);
    }

    public ComcatDataPlotter(long originTime, List<? extends ObsEqkRupture> foreshocks, List<? extends ObsEqkRupture> aftershocks) {
        this(null, originTime, System.currentTimeMillis(), foreshocks, aftershocks);
    }

    public ComcatDataPlotter(ObsEqkRupture mainshock, long originTime, long endTime, List<? extends ObsEqkRupture> foreshocks, List<? extends ObsEqkRupture> aftershocks) {
        this.mainshock = mainshock;
        this.foreshocks = foreshocks;
        this.aftershocks = aftershocks;
        Preconditions.checkArgument((aftershocks != null ? 1 : 0) != 0, (Object)"Must supply aftershocks (even if empty)");
        Preconditions.checkArgument((originTime >= Long.MIN_VALUE ? 1 : 0) != 0, (Object)"must supply origin time");
        this.originTime = originTime;
        Preconditions.checkArgument((endTime > originTime ? 1 : 0) != 0);
        this.endTime = endTime;
        this.setTimeDays(true);
        try {
            this.baseCPT = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().reverse();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public void setTimeDays(boolean timeDays) {
        this.timeDays = timeDays;
        double timeFuncDuration = this.endTime - this.originTime;
        timeFuncDuration = timeDays ? (timeFuncDuration /= 8.64E7) : (timeFuncDuration /= 3.15576E10);
        this.timeDiscretization = new EvenlyDiscretizedFunc(0.0, timeFuncDuration, 500);
    }

    public boolean isTimeDays() {
        return this.timeDays;
    }

    public void setTimeFuncDiscretization(EvenlyDiscretizedFunc timeDiscretization) {
        this.timeDiscretization = timeDiscretization;
        for (int i = 0; i < timeDiscretization.size(); ++i) {
            timeDiscretization.set(i, 0.0);
        }
    }

    public EvenlyDiscretizedFunc getTimeFuncDiscretization() {
        return this.timeDiscretization;
    }

    public void setDataColor(Color dataColor) {
        this.dataColor = dataColor;
    }

    public Color getDataColor() {
        return this.dataColor;
    }

    public void setNoTitles(boolean noTitles) {
        this.noTitles = noTitles;
    }

    public boolean isNoTitles() {
        return this.noTitles;
    }

    public void setModelMc(double modelMc) {
        this.modelMc = modelMc;
    }

    public void setTimeFuncMaxY(Double timeFuncMaxY) {
        this.timeFuncMaxY = timeFuncMaxY;
    }

    public void setTimeFuncAnns(Map<Double, String> timeFuncAnns) {
        this.timeFuncAnns = timeFuncAnns;
    }

    public long getOriginTime() {
        return this.originTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public List<? extends ObsEqkRupture> getAftershocks() {
        return this.aftershocks;
    }

    public List<? extends ObsEqkRupture> getForeshocks() {
        return this.foreshocks;
    }

    public ObsEqkRupture getMainshock() {
        return this.mainshock;
    }

    public double getMaxAftershockMag() {
        double max = Double.NEGATIVE_INFINITY;
        for (ObsEqkRupture obsEqkRupture : this.aftershocks) {
            max = Math.max(max, obsEqkRupture.getMag());
        }
        return max;
    }

    public void setPlotIncludeMedian(boolean plotIncludeMedian) {
        this.plotIncludeMedian = plotIncludeMedian;
    }

    public void setPlotIncludeMean(boolean plotIncludeMean) {
        this.plotIncludeMean = plotIncludeMean;
    }

    public void setPlotIncludeMode(boolean plotIncludeMode) {
        this.plotIncludeMode = plotIncludeMode;
    }

    public EvenlyDiscretizedFunc calcCumulativeTimeFunc(TimeDepMagComplete tdMc) {
        return this.calcCumulativeTimeFunc(tdMc, Double.NEGATIVE_INFINITY);
    }

    public EvenlyDiscretizedFunc calcCumulativeTimeFunc(double mc) {
        return this.calcCumulativeTimeFunc(null, mc);
    }

    private EvenlyDiscretizedFunc calcCumulativeTimeFunc(TimeDepMagComplete tdMc, double mc) {
        EvenlyDiscretizedFunc comcatCumulativeTimeFunc = new EvenlyDiscretizedFunc(this.timeDiscretization.getMinX(), this.timeDiscretization.getMaxX(), this.timeDiscretization.size());
        ArrayList<ObsEqkRupture> allRups = new ArrayList<ObsEqkRupture>();
        allRups.addAll(this.aftershocks);
        if (this.foreshocks != null) {
            allRups.addAll(this.foreshocks);
        }
        if (this.mainshock != null) {
            allRups.add(this.mainshock);
        }
        for (ObsEqkRupture rup : allRups) {
            int timeIndex;
            if (rup.getOriginTime() <= this.originTime || tdMc != null && !tdMc.isAboveTimeDepMc(rup) || rup.getMag() < mc) continue;
            for (int i = timeIndex = this.getTimeFuncIndex(rup); i < comcatCumulativeTimeFunc.size(); ++i) {
                comcatCumulativeTimeFunc.add(i, 1.0);
            }
        }
        long curTime = System.currentTimeMillis();
        if (this.endTime > curTime) {
            double curX = (double)(curTime - this.originTime) / 3.15576E10;
            if (this.timeDays) {
                curX *= 365.25;
            }
            for (int i = 0; i < comcatCumulativeTimeFunc.size(); ++i) {
                if (!(comcatCumulativeTimeFunc.getX(i) >= curX)) continue;
                comcatCumulativeTimeFunc.set(i, Double.NaN);
            }
        }
        return comcatCumulativeTimeFunc;
    }

    public int getTimeFuncIndex(ObsEqkRupture rup) {
        double relTime = rup.getOriginTime() - this.originTime;
        relTime = this.timeDays ? (relTime /= 8.64E7) : (relTime /= 3.15576E10);
        int timeIndex = this.timeDiscretization.getClosestXIndex(relTime);
        if (relTime > this.timeDiscretization.getX(timeIndex)) {
            ++timeIndex;
        }
        Preconditions.checkState((timeIndex == this.timeDiscretization.size() || relTime <= this.timeDiscretization.getX(timeIndex) ? 1 : 0) != 0);
        return timeIndex;
    }

    public void plotTimeFuncPlot(File outputDir, String prefix, double mc) throws IOException {
        this.plotTimeFuncPlot(outputDir, prefix, "M\u2265" + optionalDigitDF.format(mc), this.calcCumulativeTimeFunc(mc), null, null);
    }

    public void plotTimeFuncPlot(File outputDir, String prefix, TimeDepMagComplete tdMc) throws IOException {
        this.plotTimeFuncPlot(outputDir, prefix, "M\u2265Mc(t)", this.calcCumulativeTimeFunc(tdMc), null, null);
    }

    public void plotTimeFuncPlot(File outputDir, String prefix, String magLabel, EvenlyDiscretizedFunc comcatCumulativeTimeFunc, Double minTime, FractileCurveCalculator modelCalc) throws IOException {
        AbstractXY_DataSet meanCurve;
        double maxY;
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        String xAxisLabel = this.timeDays ? "Time (days)" : "Time (years)";
        CSVFile<String> csv = this.buildSimFractalFuncsCSV(modelCalc, funcs, chars, comcatCumulativeTimeFunc, xAxisLabel, false);
        csv.writeToFile(new File(outputDir, prefix + ".csv"));
        if (comcatCumulativeTimeFunc.size() > 0 && Double.isFinite(comcatCumulativeTimeFunc.getY(0))) {
            comcatCumulativeTimeFunc.setName("ComCat Data");
            funcs.add(comcatCumulativeTimeFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, this.dataColor));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, (String)(this.noTitles ? " " : "Cumulative Number Comparison, " + magLabel), xAxisLabel, "Cumulative Num Earthquakes " + magLabel);
        spec.setLegendVisible(true);
        double maxData = comcatCumulativeTimeFunc.getMaxY();
        if (this.timeFuncMaxY != null) {
            maxY = this.timeFuncMaxY;
        } else if (modelCalc != null) {
            double maxMean = modelCalc.getMeanCurve().getMaxY();
            double maxUpper = modelCalc.getFractile(0.975).getMaxY();
            maxY = Math.max(2.0 * maxData, Math.max(Math.min(2.0 * maxMean, 1.5 * maxUpper), 1.25 * maxMean));
        } else {
            maxY = 1.3 * maxData;
        }
        if (maxY <= 1.0 || !Double.isFinite(maxY)) {
            maxY = 1.0;
        }
        double maxX = Math.max(1.0, comcatCumulativeTimeFunc.getMaxX());
        ArrayList<XYTextAnnotation> anns = null;
        if (modelCalc != null && (float)(meanCurve = modelCalc.getMeanCurve()).getMinX() > 0.0f) {
            DefaultXY_DataSet dataStartFunc = new DefaultXY_DataSet();
            dataStartFunc.set(meanCurve.getMinX(), 0.0);
            dataStartFunc.set(meanCurve.getMinX(), maxY);
            funcs.add(dataStartFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.DARK_GRAY));
            anns = new ArrayList();
            Font font = new Font("SansSerif", 1, 18);
            double annY = 0.975 * maxY;
            double annX = meanCurve.getMinX() + 0.02 * maxX;
            XYTextAnnotation ann = new XYTextAnnotation("Model Start", annX, annY);
            ann.setTextAnchor(TextAnchor.BOTTOM_LEFT);
            ann.setRotationAnchor(TextAnchor.BOTTOM_LEFT);
            ann.setRotationAngle(1.5707963267948966);
            ann.setFont(font);
            anns.add(ann);
        }
        if (this.timeFuncAnns != null && !this.timeFuncAnns.isEmpty()) {
            if (anns == null) {
                anns = new ArrayList<XYTextAnnotation>();
            }
            Font font = new Font("SansSerif", 1, 18);
            for (double xVal : this.timeFuncAnns.keySet()) {
                String label = this.timeFuncAnns.get(xVal);
                if (!this.timeDays) {
                    xVal /= 365.25;
                }
                DefaultXY_DataSet xy = new DefaultXY_DataSet();
                xy.set(xVal, 0.0);
                xy.set(xVal, maxY);
                funcs.add(xy);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
                XYTextAnnotation ann = new XYTextAnnotation(" " + label, xVal, 0.025 * maxY);
                ann.setTextAnchor(TextAnchor.BASELINE_LEFT);
                ann.setFont(font);
                anns.add(ann);
            }
        }
        if (anns != null) {
            spec.setPlotAnnotations(anns);
        }
        HeadlessGraphPanel gp = ComcatDataPlotter.buildGraphPanel();
        gp.setLegendFontSize(18);
        if (minTime == null) {
            minTime = 0.0;
        }
        gp.setUserBounds(minTime, maxX, 0.0, maxY);
        gp.drawGraphPanel(spec, false, false);
        gp.getChartPanel().setSize(800, 600);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
    }

    public void plotTimeDepMcPlot(File outputDir, String prefix, TimeDepMagComplete timeDepMc) throws IOException {
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        ArbitrarilyDiscretizedFunc totalFunc = new ArbitrarilyDiscretizedFunc("Time-Dep Mc");
        funcs.add(totalFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
        ArbitrarilyDiscretizedFunc mainshockFunc = null;
        ArrayList<ArbitrarilyDiscretizedFunc> otherEventFuncs = null;
        List<? extends ObsEqkRupture> mainshocksForTimeDepMc = null;
        double tdMinMag = Double.NaN;
        if (timeDepMc instanceof Helmstetter2006_TimeDepMc) {
            mainshockFunc = new ArbitrarilyDiscretizedFunc("Mainshock Mc");
            funcs.add(mainshockFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            Helmstetter2006_TimeDepMc helmMc = (Helmstetter2006_TimeDepMc)timeDepMc;
            otherEventFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
            mainshocksForTimeDepMc = helmMc.getMainshocksList();
            for (int i = 1; i < mainshocksForTimeDepMc.size(); ++i) {
                ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc(i == 1 ? "Other Event Mcs" : null);
                otherEventFuncs.add(func);
                funcs.add(func);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY));
            }
            tdMinMag = helmMc.getMinMagThreshold();
            ArbitrarilyDiscretizedFunc threshFunc = new ArbitrarilyDiscretizedFunc("Minimum Mc Threshold");
            threshFunc.set(0.0, tdMinMag);
            threshFunc.set(this.timeDiscretization.getMaxX() + 0.5 * this.timeDiscretization.getDelta(), tdMinMag);
            funcs.add(threshFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 2.0f, Color.GRAY));
        }
        for (int i = 0; i < this.timeDiscretization.size(); ++i) {
            double x = this.timeDiscretization.getX(i);
            long time = this.timeDays ? this.originTime + (long)(x * 8.64E7) : this.originTime + (long)(x * 3.15576E10);
            if (mainshocksForTimeDepMc != null) {
                double d = tdMinMag;
                for (int j = 0; j < mainshocksForTimeDepMc.size(); ++j) {
                    double myMc = Helmstetter2006_TimeDepMc.calcTimeDepMc(mainshocksForTimeDepMc.get(j), time, 0.0);
                    if (Double.isNaN(myMc)) continue;
                    d = Math.max(d, myMc);
                    if (j == 0) {
                        mainshockFunc.set(x, myMc);
                        continue;
                    }
                    ((ArbitrarilyDiscretizedFunc)otherEventFuncs.get(j - 1)).set(x, myMc);
                }
                totalFunc.set(x, d);
                continue;
            }
            totalFunc.set(x, timeDepMc.calcTimeDepMc(time));
        }
        String xAxisLabel = this.timeDays ? "Time (days)" : "Time (years)";
        PlotSpec spec = new PlotSpec(funcs, chars, this.noTitles ? " " : "Time Dependent Mc", xAxisLabel, "Magnitude of Completeness");
        spec.setLegendVisible(true);
        double maxY = 5.0;
        for (ObsEqkRupture obsEqkRupture : mainshocksForTimeDepMc) {
            maxY = Math.max(maxY, obsEqkRupture.getMag());
        }
        double minY = 2.0;
        HeadlessGraphPanel gp = ComcatDataPlotter.buildGraphPanel();
        gp.setLegendFontSize(18);
        double maxX = Math.max(1.0, this.timeDiscretization.getMaxX());
        gp.setUserBounds(0.0, maxX, minY, maxY);
        gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
        gp.drawGraphPanel(spec, false, false);
        gp.getChartPanel().setSize(800, 500);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
    }

    public IncrementalMagFreqDist calcIncrementalMagNum(double minMag, boolean includeMainshock, boolean includeForeshocks) {
        int magIndex;
        double mag;
        double deltaMag = 0.1;
        double minX = Math.floor(minMag / deltaMag) * deltaMag;
        double maxX = 8.95;
        double minIncr = minX + 0.5 * deltaMag;
        int numMag = (int)((maxX - minIncr) / deltaMag) + 1;
        IncrementalMagFreqDist incrMND = new IncrementalMagFreqDist(minIncr, numMag, deltaMag);
        double thresholdMag = minMag - 0.5 * deltaMag;
        for (ObsEqkRupture obsEqkRupture : this.aftershocks) {
            mag = obsEqkRupture.getMag();
            if (mag < thresholdMag) continue;
            magIndex = incrMND.getClosestXIndex(mag);
            incrMND.add(magIndex, 1.0);
        }
        if (includeMainshock && this.mainshock != null) {
            int magIndex2 = incrMND.getClosestXIndex(this.mainshock.getMag());
            incrMND.add(magIndex2, 1.0);
        }
        if (includeForeshocks && this.foreshocks != null) {
            for (ObsEqkRupture obsEqkRupture : this.foreshocks) {
                mag = obsEqkRupture.getMag();
                if (mag < thresholdMag) continue;
                magIndex = incrMND.getClosestXIndex(mag);
                incrMND.add(magIndex, 1.0);
            }
        }
        return incrMND;
    }

    public double calcModalMag(double minMag, boolean includeMainshock, boolean includeForeshocks) {
        IncrementalMagFreqDist incrMND = this.calcIncrementalMagNum(minMag, includeMainshock, includeForeshocks);
        if (incrMND.calcSumOfY_Vals() == 0.0) {
            return incrMND.getMinX() - 0.5 * incrMND.getDelta();
        }
        return incrMND.getX(incrMND.getXindexForMaxY()) - 0.5 * incrMND.getDelta();
    }

    public void plotMagNumPlot(File outputDir, String prefix, boolean cumulative, double minMag, double mc, boolean includeMainshock, boolean includeForeshocks, FractileCurveCalculator modelCalc) throws IOException {
        double maxY;
        double minY;
        String yAxisLabel;
        EvenlyDiscretizedFunc dataMND;
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        IncrementalMagFreqDist incrMND = this.calcIncrementalMagNum(minMag, includeMainshock, includeForeshocks);
        double minX = incrMND.getMinX() - 0.5 * incrMND.getDelta();
        double maxX = incrMND.getMaxX() + 0.5 * incrMND.getDelta();
        if (cumulative) {
            dataMND = incrMND.getCumRateDistWithOffset();
            yAxisLabel = "Cumulative Number";
        } else {
            dataMND = incrMND;
            yAxisLabel = "Incremental Number";
        }
        CSVFile<String> csv = this.buildSimFractalFuncsCSV(modelCalc, funcs, chars, dataMND, "Magnitude", true);
        csv.writeToFile(new File(outputDir, prefix + ".csv"));
        dataMND.setName("ComCat Data");
        funcs.add(dataMND);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, this.dataColor));
        DataUtils.MinMaxAveTracker nonZeroRange = new DataUtils.MinMaxAveTracker();
        double maxNonZeroX = 0.0;
        for (XY_DataSet func : funcs) {
            for (Point2D pt : func) {
                if (!(pt.getY() > 0.0)) continue;
                nonZeroRange.addValue(pt.getY());
                maxNonZeroX = Math.max(maxNonZeroX, pt.getX());
            }
        }
        if (nonZeroRange.getNum() == 0) {
            minY = 0.1;
            maxY = 100.0;
        } else {
            maxY = Math.pow(10.0, Math.ceil(Math.log10(nonZeroRange.getMax())));
            minY = Math.pow(10.0, Math.floor(Math.log10(nonZeroRange.getMin())));
        }
        if (minY >= maxY) {
            minY = Math.pow(10.0, Math.log10(maxY) - 1.0);
        }
        if (minY == 1.0) {
            minY = 0.9;
        }
        maxX = Math.min(maxX, Math.max(Math.ceil(maxNonZeroX), 5.0));
        if ((float)mc > (float)minMag) {
            DefaultXY_DataSet mcFunc = new DefaultXY_DataSet();
            mcFunc.set(mc, minY);
            mcFunc.set(mc, maxY);
            mcFunc.setName("Mc");
            funcs.add(mcFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, this.dataColor));
        }
        String title = modelCalc == null ? "Magnitude-Number Distribution" : "Magnitude Distribution Comparison";
        PlotSpec spec = new PlotSpec(funcs, chars, this.noTitles ? " " : title, "Magnitude", yAxisLabel);
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = ComcatDataPlotter.buildGraphPanel();
        gp.setLegendFontSize(18);
        gp.setUserBounds(minX, maxX, minY, maxY);
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(0.5);
        tus.add((TickUnit)tu);
        gp.drawGraphPanel(spec, false, true);
        gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
        gp.getChartPanel().setSize(800, 600);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
    }

    public void plotMagDepthPlot(File outputDir, String prefix, TimeDepMagComplete tdMc) throws IOException {
        this.plotMagDepthPlot(outputDir, prefix, tdMc, Double.NEGATIVE_INFINITY, null);
    }

    public void plotMagDepthPlot(File outputDir, String prefix, double minMag) throws IOException {
        this.plotMagDepthPlot(outputDir, prefix, null, minMag, null);
    }

    /*
     * WARNING - void declaration
     */
    public void plotMagDepthPlot(File outputDir, String prefix, TimeDepMagComplete tdMc, double minMag, EvenlyDiscretizedFunc modelFunc) throws IOException {
        void var16_34;
        void var14_21;
        void var13_16;
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<ObsEqkRupture> filteredAftershocks = new ArrayList<ObsEqkRupture>();
        double maxDepth = 0.0;
        for (ObsEqkRupture obsEqkRupture : this.aftershocks) {
            if (tdMc != null && !tdMc.isAboveTimeDepMc(obsEqkRupture) || !(obsEqkRupture.getMag() >= minMag)) continue;
            filteredAftershocks.add(obsEqkRupture);
            maxDepth = Math.max(maxDepth, obsEqkRupture.getHypocenterLocation().getDepth());
        }
        ArrayList<ObsEqkRupture> filteredInputs = new ArrayList<ObsEqkRupture>();
        if (this.foreshocks != null) {
            for (ObsEqkRupture obsEqkRupture : this.foreshocks) {
                if (tdMc != null && !tdMc.isAboveTimeDepMc(obsEqkRupture) || !(obsEqkRupture.getMag() >= minMag)) continue;
                filteredInputs.add(obsEqkRupture);
                maxDepth = Math.max(maxDepth, obsEqkRupture.getHypocenterLocation().getDepth());
            }
        }
        if (this.mainshock != null && (tdMc != null && tdMc.isAboveTimeDepMc(this.mainshock) || this.mainshock.getMag() >= minMag)) {
            filteredInputs.add(this.mainshock);
            maxDepth = Math.max(maxDepth, this.mainshock.getHypocenterLocation().getDepth());
        }
        if (modelFunc == null) {
            EvenlyDiscretizedFunc evenlyDiscretizedFunc = new EvenlyDiscretizedFunc(1.0, (int)Math.ceil(maxDepth), 1.0);
        } else {
            EvenlyDiscretizedFunc evenlyDiscretizedFunc = new EvenlyDiscretizedFunc(modelFunc.getMinX(), modelFunc.getMaxX(), modelFunc.size());
        }
        for (ObsEqkRupture obsEqkRupture : this.aftershocks) {
            var13_16.add(var13_16.getClosestXIndex(obsEqkRupture.getHypocenterLocation().getDepth()), 1.0);
        }
        Object var14_19 = null;
        if (!filteredInputs.isEmpty()) {
            EvenlyDiscretizedFunc evenlyDiscretizedFunc = new EvenlyDiscretizedFunc(var13_16.getMinX(), var13_16.getMaxX(), var13_16.size());
            for (ObsEqkRupture obsEqkRupture : filteredInputs) {
                evenlyDiscretizedFunc.add(evenlyDiscretizedFunc.getClosestXIndex(obsEqkRupture.getHypocenterLocation().getDepth()), 1.0);
            }
        }
        if (modelFunc != null) {
            XY_DataSet xY_DataSet = this.getDepthXY(modelFunc);
            xY_DataSet.setName(modelFunc.getName() == null ? "Model" : modelFunc.getName());
            funcs.add(xY_DataSet);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        }
        XY_DataSet xY_DataSet = this.getDepthXY((EvenlyDiscretizedFunc)var13_16);
        xY_DataSet.setName("ComCat Aftershocks");
        funcs.add(xY_DataSet);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, this.dataColor));
        if (var14_21 != null) {
            XY_DataSet xY_DataSet2 = this.getDepthXY((EvenlyDiscretizedFunc)var14_21);
            xY_DataSet2.setName("ComCat Fore/Mainshock(s)");
            funcs.add(xY_DataSet2);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GRAY));
        }
        if (tdMc != null) {
            String string = "M\u2265Mc(t)";
        } else if (minMag > 0.0) {
            String string = "M\u2265" + optionalDigitDF.format(minMag);
        } else {
            String string = "All Magnitudes";
        }
        PlotSpec spec = new PlotSpec(funcs, chars, (String)(this.noTitles ? " " : "Depth Distribution Comparison, " + (String)var16_34), "Fraction", "Depth (km)");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = ComcatDataPlotter.buildGraphPanel();
        gp.setLegendFontSize(18);
        gp.setUserBounds(0.0, 1.0, 0.0, var13_16.getMaxX() + 0.5 * var13_16.getDelta());
        gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
        gp.drawGraphPanel(spec, false, false);
        gp.setyAxisInverted(true);
        gp.getChartPanel().setSize(600, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
    }

    private XY_DataSet getDepthXY(EvenlyDiscretizedFunc func) {
        double numRups = func.calcSumOfY_Vals();
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        if (numRups == 0.0) {
            xy.set(0.0, 0.0);
            xy.set(0.0, func.getMaxX() + 0.5 * func.getDelta());
        } else {
            for (int i = 0; i < func.size(); ++i) {
                double middle = func.getX(i);
                double top = middle - 0.5 * func.getDelta();
                double bottom = middle + 0.5 * func.getDelta();
                double num = func.getY(i) / numRups;
                xy.set(num, top);
                xy.set(num, bottom);
            }
        }
        return xy;
    }

    private static Color saturate(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        for (int i = 0; i < 1; ++i) {
            r = (int)(0.5 * ((double)r + 255.0) + 0.5);
            g = (int)(0.5 * ((double)g + 255.0) + 0.5);
            b = (int)(0.5 * ((double)b + 255.0) + 0.5);
        }
        return new Color(r, g, b, c.getAlpha());
    }

    public void plotMagTimeFunc(File outputDir, String prefix) throws IOException {
        this.plotMagTimeFunc(outputDir, prefix, null);
    }

    public void plotMagTimeFunc(File outputDir, String prefix, EvenlyDiscrXYZ_DataSet modelXYZ) throws IOException {
        this.plotMagTimeFunc(outputDir, prefix, "Magnitude vs Time", null, null, modelXYZ);
    }

    /*
     * WARNING - void declaration
     */
    public void plotMagTimeFunc(File outputDir, String prefix, String title, Double minTime, Double maxTime, EvenlyDiscrXYZ_DataSet modelXYZ) throws IOException {
        Object xAxisLabel;
        void var10_26;
        double d;
        CPT cpt = null;
        if (modelXYZ != null) {
            double minZ;
            Color belowColor = new Color(255, 255, 255, 0);
            if (this.minPlotProb == null) {
                minZ = 0.01;
                for (int i = 0; i < modelXYZ.size(); ++i) {
                    double z = modelXYZ.get(i);
                    if (!(z > 0.0)) continue;
                    minZ = Math.min(minZ, z);
                }
            } else {
                minZ = this.minPlotProb;
            }
            double logMinProb = Math.floor(Math.log10(minZ));
            d = 0.0;
            if (logMinProb < -3.0) {
                cpt = this.baseCPT.rescale(-3.0, d);
                cpt.add(0, new CPTVal((float)logMinProb, belowColor, -3.0, cpt.getMinColor()));
            } else {
                cpt = this.baseCPT.rescale(logMinProb, d);
            }
            modelXYZ = modelXYZ.copy();
            modelXYZ.log10();
            for (CPTVal cPTVal : cpt) {
                cPTVal.minColor = ComcatDataPlotter.saturate(cPTVal.minColor);
                cPTVal.maxColor = ComcatDataPlotter.saturate(cPTVal.maxColor);
            }
            cpt.setBelowMinColor(belowColor);
            cpt.setNanColor(belowColor);
        }
        DefaultXY_DataSet aftershocksFunc = null;
        if (!this.aftershocks.isEmpty()) {
            aftershocksFunc = new DefaultXY_DataSet();
            aftershocksFunc.setName("Observed Aftershocks");
            if (maxTime == null) {
                maxTime = this.timeDiscretization.getMaxX() + 0.5 * this.timeDiscretization.getDelta();
                if (modelXYZ != null) {
                    maxTime = Math.max(maxTime, modelXYZ.getMaxX() + 0.5 * modelXYZ.getGridSpacingX());
                }
            }
            for (ObsEqkRupture obsEqkRupture : this.aftershocks) {
                double time = (double)(obsEqkRupture.getOriginTime() - this.originTime) / 3.15576E10;
                if (this.timeDays) {
                    time *= 365.25;
                }
                if (!(time <= maxTime)) continue;
                aftershocksFunc.set(time, obsEqkRupture.getMag());
            }
        }
        DefaultXY_DataSet mainshockFunc = null;
        if (this.mainshock != null) {
            mainshockFunc = new DefaultXY_DataSet();
            mainshockFunc.setName("Mainshock");
            double d2 = (double)(this.mainshock.getOriginTime() - this.originTime) / 3.15576E10;
            if (this.timeDays) {
                d2 *= 365.25;
            }
            mainshockFunc.set(d2, this.mainshock.getMag());
        }
        Object var10_24 = null;
        if (this.foreshocks != null && !this.foreshocks.isEmpty()) {
            String plural;
            DefaultXY_DataSet defaultXY_DataSet = new DefaultXY_DataSet();
            String string = plural = this.foreshocks.size() > 1 ? "s" : "";
            if (this.mainshock == null) {
                defaultXY_DataSet.setName("Mainshock" + plural);
            } else if (defaultXY_DataSet.getMaxX() > mainshockFunc.getMaxX()) {
                defaultXY_DataSet.setName("Input Event" + plural);
            } else {
                defaultXY_DataSet.setName("Foreshock" + plural);
            }
            for (ObsEqkRupture obsEqkRupture : this.foreshocks) {
                double time = (double)(obsEqkRupture.getOriginTime() - this.originTime) / 3.15576E10;
                if (this.timeDays) {
                    time *= 365.25;
                }
                defaultXY_DataSet.set(time, obsEqkRupture.getMag());
            }
        }
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        d = Double.POSITIVE_INFINITY;
        double maxDataMag = Double.NEGATIVE_INFINITY;
        if (aftershocksFunc != null) {
            if (!Double.isNaN(aftershocksFunc.getMinY())) {
                d = Math.min(d, aftershocksFunc.getMinY());
            }
            if (!Double.isNaN(aftershocksFunc.getMaxY())) {
                maxDataMag = Math.max(maxDataMag, aftershocksFunc.getMaxY());
            }
        }
        if (var10_26 != null) {
            if (!Double.isNaN(var10_26.getMinY())) {
                d = Math.min(d, var10_26.getMinY());
            }
            if (!Double.isNaN(var10_26.getMaxY())) {
                maxDataMag = Math.max(maxDataMag, var10_26.getMaxY());
            }
        }
        if (this.mainshock != null && !Double.isNaN(this.mainshock.getMag())) {
            d = Math.min(d, this.mainshock.getMag());
            maxDataMag = Math.max(maxDataMag, this.mainshock.getMag());
        }
        if (minTime == null) {
            minTime = 0.0;
            if (var10_26 != null) {
                minTime = Math.min(minTime, var10_26.getMinX() - 0.1);
            }
            if (this.mainshock != null) {
                minTime = Math.min(minTime, mainshockFunc.getMinX() - 0.1);
            }
        }
        Preconditions.checkState((boolean)Double.isFinite(d), (String)"Min data mag is non-finite: %s", (Object)d);
        double minMag = Math.floor(d * 10.0) / 10.0;
        double maxMag = Math.ceil(Math.max(maxDataMag, minMag + 3.75));
        if (modelXYZ != null) {
            minMag = Math.min(minMag, modelXYZ.getMinY() - 0.5 * modelXYZ.getGridSpacingY());
        }
        EvenlyDiscretizedFunc magSizeFunc = this.getMagSizeFunc(minMag);
        if (var10_26 != null && var10_26.size() > 0) {
            this.addGroupedInputFuncs((XY_DataSet)var10_26, funcs, chars, this.foreshockColor, magSizeFunc);
        }
        if (mainshockFunc != null) {
            this.addGroupedInputFuncs(mainshockFunc, funcs, chars, this.mainshockColor, magSizeFunc);
        }
        if (aftershocksFunc != null) {
            this.addGroupedInputFuncs(aftershocksFunc, funcs, chars, this.aftershockColor, magSizeFunc);
        }
        Object object = xAxisLabel = this.timeDays ? "Days" : "Years";
        if (this.mainshock != null) {
            xAxisLabel = (String)xAxisLabel + " Since Mainshock";
        }
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(1.0);
        tus.add((TickUnit)tu);
        Range xRange = new Range(minTime.doubleValue(), maxTime.doubleValue());
        Range yRange = new Range(minMag, maxMag);
        ArrayList<XYTextAnnotation> anns = null;
        Font annFont = new Font("SansSerif", 1, 18);
        PlotCurveCharacterstics markerChar = new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, new Color(127, 127, 127, 127));
        double annBuffX = 0.015 * xRange.getLength();
        double annBuffY = 0.02 * yRange.getLength();
        double dataEndTime = (double)(this.endTime - this.originTime) / 3.15576E10;
        double dataDeltaDays = this.timeDays ? (dataEndTime *= 365.25) : dataEndTime * 365.25;
        if ((float)dataEndTime < maxTime.floatValue() && dataDeltaDays > 0.041666666666666664 && this.endTime <= System.currentTimeMillis()) {
            anns = new ArrayList<XYTextAnnotation>();
            double x = dataEndTime + annBuffX;
            double y = maxMag - annBuffY;
            XYTextAnnotation ann = new XYTextAnnotation("Time Updated", x, y);
            ann.setFont(annFont);
            ann.setTextAnchor(TextAnchor.BOTTOM_LEFT);
            ann.setRotationAnchor(TextAnchor.BOTTOM_LEFT);
            ann.setRotationAngle(1.5707963267948966);
            anns.add(ann);
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            xy.set(dataEndTime, minMag);
            xy.set(dataEndTime, maxMag);
            funcs.add(xy);
            chars.add(markerChar);
        }
        if (modelXYZ == null) {
            PlotSpec spec = new PlotSpec(funcs, chars, this.noTitles ? " " : title, (String)xAxisLabel, "Magnitude");
            spec.setLegendVisible(true);
            if (anns != null) {
                spec.setPlotAnnotations(anns);
            }
            HeadlessGraphPanel gp = ComcatDataPlotter.buildGraphPanel();
            gp.setLegendFontSize(18);
            gp.setUserBounds(xRange, yRange);
            gp.drawGraphPanel(spec, false, false);
            gp.getYAxis().setStandardTickUnits((TickUnitSource)tus);
            gp.getChartPanel().setSize(800, 650);
            gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        } else {
            DefaultXY_DataSet xy;
            XYTextAnnotation startAnn;
            double y;
            XYZPlotSpec spec = new XYZPlotSpec(modelXYZ, cpt, this.noTitles ? " " : title, (String)xAxisLabel, "Magnitude", "Log10(Probability)");
            double modelStart = modelXYZ.getMinX() - 0.5 * modelXYZ.getGridSpacingX();
            double modelMinMag = modelXYZ.getMinY() - 0.5 * modelXYZ.getGridSpacingY();
            if ((float)modelStart > 0.01f) {
                if (anns == null) {
                    anns = new ArrayList();
                }
                double x = modelStart + annBuffX;
                y = maxMag - annBuffY;
                startAnn = new XYTextAnnotation("Model Start", x, y);
                startAnn.setFont(annFont);
                startAnn.setTextAnchor(TextAnchor.BOTTOM_LEFT);
                startAnn.setRotationAnchor(TextAnchor.BOTTOM_LEFT);
                startAnn.setRotationAngle(1.5707963267948966);
                anns.add(startAnn);
                xy = new DefaultXY_DataSet();
                xy.set(modelStart, minMag);
                xy.set(modelStart, maxMag);
                funcs.add(xy);
                chars.add(markerChar);
            }
            if ((float)modelMinMag > (float)minMag) {
                if (anns == null) {
                    anns = new ArrayList();
                }
                double x = maxTime - annBuffX;
                y = modelMinMag + annBuffY;
                startAnn = new XYTextAnnotation("Simulation Min Mag", x, y);
                startAnn.setFont(annFont);
                startAnn.setTextAnchor(TextAnchor.BOTTOM_RIGHT);
                anns.add(startAnn);
                xy = new DefaultXY_DataSet();
                xy.set(minTime, modelMinMag);
                xy.set(maxTime, modelMinMag);
                funcs.add(xy);
                chars.add(markerChar);
            }
            if (anns != null) {
                spec.setPlotAnnotations(anns);
            }
            spec.setXYElems(funcs);
            spec.setXYChars(chars);
            spec.setCPTPosition(RectangleEdge.BOTTOM);
            HeadlessGraphPanel gp = ComcatDataPlotter.buildGraphPanel();
            gp.drawGraphPanel(spec, false, false, xRange, yRange);
            gp.getYAxis().setStandardTickUnits((TickUnitSource)tus);
            gp.getChartPanel().setSize(800, 650);
            gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        }
    }

    private EvenlyDiscretizedFunc getMagSizeFunc(double minMag) {
        HistogramFunction magSizeFunc = HistogramFunction.getEncompassingHistogram(minMag, 8.95, 0.1);
        for (int i = 0; i < magSizeFunc.size(); ++i) {
            magSizeFunc.set(i, 1.0 + 2.0 * (magSizeFunc.getX(i) - magSizeFunc.getMinX()));
        }
        return magSizeFunc;
    }

    private void addGroupedInputFuncs(XY_DataSet func, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, Color color, EvenlyDiscretizedFunc magSizeFunc) {
        XY_DataSet[] subFuncs = new XY_DataSet[magSizeFunc.size()];
        for (Point2D pt : func) {
            int magIndex = magSizeFunc.getClosestXIndex(pt.getY());
            if (subFuncs[magIndex] == null) {
                subFuncs[magIndex] = new DefaultXY_DataSet();
            }
            subFuncs[magIndex].set(pt);
        }
        boolean first = true;
        Color outlineColor = new Color(0, 0, 0, 127);
        int i = magSizeFunc.size();
        while (--i >= 0) {
            if (subFuncs[i] == null) continue;
            if (first) {
                subFuncs[i].setName(func.getName());
            }
            funcs.add(subFuncs[i]);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, (float)magSizeFunc.getY(i), color));
            if (outlineColor != null) {
                if (first) {
                    XY_DataSet copy = subFuncs[i].deepClone();
                    copy.setName(null);
                    funcs.add(copy);
                } else {
                    funcs.add(subFuncs[i]);
                }
                chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, (float)magSizeFunc.getY(i), outlineColor));
            }
            first = false;
        }
    }

    private EvenlyDiscretizedFunc getMapMagSizeFunc(double minMag) {
        return this.getMagSizeFunc(minMag);
    }

    private void addMapInputFuncs(List<? extends ObsEqkRupture> ruptures, double minMag, String label, Color color, EvenlyDiscretizedFunc magSizeFunc, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars) {
        AbstractXY_DataSet largest = null;
        double maxMag = minMag;
        Color outlineColor = new Color(0, 0, 0, 127);
        for (ObsEqkRupture obsEqkRupture : ruptures) {
            double mag = obsEqkRupture.getMag();
            if (!(mag >= minMag)) continue;
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            if (mag > maxMag) {
                maxMag = mag;
                largest = xy;
            }
            Location loc = obsEqkRupture.getHypocenterLocation();
            xy.set(loc.getLongitude(), loc.getLatitude());
            funcs.add(xy);
            float magSize = (float)magSizeFunc.getInterpolatedY(mag);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, magSize, color));
            if (outlineColor == null) continue;
            if (largest == xy) {
                XY_DataSet copy = xy.deepClone();
                copy.setName(null);
                funcs.add(copy);
            } else {
                funcs.add(xy);
            }
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, magSize, outlineColor));
        }
        if (largest != null) {
            largest.setName(label);
        }
    }

    public void plotMap(File outputDir, String prefix, String title, Region mapRegion, double minMag) throws IOException {
        List<? extends XY_DataSet> funcs = null;
        List<PlotCurveCharacterstics> chars = null;
        this.plotMap(outputDir, prefix, title, mapRegion, this.aftershocks, minMag, funcs, chars);
    }

    public void plotMap(File outputDir, String prefix, String title, Region mapRegion, List<? extends ObsEqkRupture> events, double minMag, List<? extends XY_DataSet> inputFuncs, List<PlotCurveCharacterstics> inputChars) throws IOException {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        if (this.mapDrawCA) {
            for (XY_DataSet caBoundary : PoliticalBoundariesData.loadCAOutlines()) {
                funcs.add(caBoundary);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
            }
        }
        if (inputFuncs != null) {
            Preconditions.checkNotNull(inputChars, (Object)"must also give input chars");
            funcs.addAll(inputFuncs);
            chars.addAll(inputChars);
        }
        EvenlyDiscretizedFunc magSizeFunc = this.getMapMagSizeFunc(minMag);
        if (this.foreshocks != null && !this.foreshocks.isEmpty() || this.mainshock != null) {
            if (this.foreshocks != null && !this.foreshocks.isEmpty()) {
                this.addMapInputFuncs(this.foreshocks, minMag, "Foreshocks", this.foreshockColor, magSizeFunc, funcs, chars);
            }
            if (this.mainshock != null) {
                ArrayList<ObsEqkRupture> rups = new ArrayList<ObsEqkRupture>();
                rups.add(this.mainshock);
                this.addMapInputFuncs(rups, minMag, "Mainshock", this.mainshockColor, magSizeFunc, funcs, chars);
            }
        }
        this.addMapInputFuncs(events, minMag, "Aftershocks", this.aftershockColor, magSizeFunc, funcs, chars);
        double latSpan = mapRegion.getMaxLat() - mapRegion.getMinLat();
        double lonSpan = mapRegion.getMaxLon() - mapRegion.getMinLon();
        double tickUnit = lonSpan > 5.0 ? 1.0 : (lonSpan > 2.0 ? 0.5 : (lonSpan > 1.0 ? 0.25 : 0.1));
        TickUnits tus = new TickUnits();
        NumberTickUnit tu = new NumberTickUnit(tickUnit);
        tus.add((TickUnit)tu);
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Longitude", "Latitude");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = ComcatDataPlotter.buildGraphPanel();
        gp.setUserBounds(mapRegion.getMinLon(), mapRegion.getMaxLon(), mapRegion.getMinLat(), mapRegion.getMaxLat());
        gp.drawGraphPanel(spec, false, false);
        gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
        gp.getYAxis().setStandardTickUnits((TickUnitSource)tus);
        int width = 800;
        int height = (int)((double)width * latSpan / lonSpan);
        gp.getChartPanel().setSize(width, height);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
    }

    private static HeadlessGraphPanel buildGraphPanel() {
        PlotPreferences plotPrefs = PlotPreferences.getDefault();
        plotPrefs.setTickLabelFontSize(20);
        plotPrefs.setAxisLabelFontSize(22);
        plotPrefs.setPlotLabelFontSize(24);
        plotPrefs.setLegendFontSize(20);
        plotPrefs.setBackgroundColor(Color.WHITE);
        return new HeadlessGraphPanel(plotPrefs);
    }

    private CSVFile<String> buildSimFractalFuncsCSV(FractileCurveCalculator calc, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, XY_DataSet dataFunc, String xAxisName, boolean magX) {
        XY_DataSet minCurve = null;
        XY_DataSet maxCurve = null;
        ArrayList<XY_DataSet> fractileFuncs = null;
        XY_DataSet modeFunc = null;
        XY_DataSet medianFunc = null;
        XY_DataSet meanFunc = null;
        CSVFile<String> csv = new CSVFile<String>(true);
        ArrayList<Object> header = new ArrayList<Object>();
        header.add(xAxisName);
        header.add("ComCat Data");
        int dataOffset = 0;
        int simOffset = 0;
        int maxIndex = dataFunc.size() - 1;
        if (calc != null) {
            int i;
            minCurve = this.notAsIncr(calc.getMinimumCurve());
            minCurve.setName("Extrema");
            maxCurve = this.notAsIncr(calc.getMaximumCurve());
            maxCurve.setName(null);
            if (magX) {
                minCurve = this.getAboveModelMc(minCurve);
                maxCurve = this.getAboveModelMc(maxCurve);
            }
            funcs.add(minCurve);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.BLACK));
            funcs.add(maxCurve);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.BLACK));
            Object fractileStr = null;
            fractileFuncs = new ArrayList<XY_DataSet>();
            double[] dArray = fractiles;
            int n = dArray.length;
            for (int j = 0; j < n; ++j) {
                double fractile = dArray[j];
                fractileStr = fractileStr == null ? "" : (String)fractileStr + ",";
                fractileStr = (String)fractileStr + "p" + optionalDigitDF.format(fractile * 100.0);
                fractileFuncs.add(this.notAsIncr(calc.getFractile(fractile)));
            }
            for (i = 0; i < fractileFuncs.size(); ++i) {
                XY_DataSet func = (XY_DataSet)fractileFuncs.get(i);
                if (i == 0) {
                    func.setName((String)fractileStr);
                } else {
                    func.setName(null);
                }
                if (magX) {
                    func = this.getAboveModelMc(func);
                }
                funcs.add(func);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            }
            modeFunc = new ArbitrarilyDiscretizedFunc();
            for (i = 0; i < minCurve.size(); ++i) {
                modeFunc.set(minCurve.getX(i), calc.getEmpiricalDist(i).getMostCentralMode());
            }
            if (this.plotIncludeMode && magX) {
                modeFunc.setName("Mode");
                if (magX) {
                    modeFunc = this.getAboveModelMc(modeFunc);
                }
                funcs.add(modeFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.CYAN.darker()));
            }
            medianFunc = calc.getFractile(0.5);
            if (this.plotIncludeMedian) {
                medianFunc.setName("Median");
                if (magX) {
                    medianFunc = this.getAboveModelMc(medianFunc);
                }
                funcs.add(medianFunc);
                if (this.plotIncludeMean) {
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
                } else {
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
                }
            }
            meanFunc = calc.getMeanCurve();
            if (this.plotIncludeMean) {
                meanFunc.setName("Mean");
                if (magX) {
                    meanFunc = this.getAboveModelMc(meanFunc);
                }
                funcs.add(meanFunc);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
            }
            header.add("Simulation Mean");
            header.add("Simulation Median");
            header.add("Simulation Mode");
            header.add("Simulation Minimum");
            header.add("Simulation Maximum");
            for (double fractile : fractiles) {
                header.add(optionalDigitDF.format(fractile * 100.0) + " %-ile");
            }
            if ((float)dataFunc.getX(0) != (float)minCurve.getX(0)) {
                if ((float)dataFunc.getX(0) < (float)minCurve.getX(0)) {
                    while ((float)dataFunc.getX(-simOffset) < (float)minCurve.getX(0) && -simOffset < dataFunc.size()) {
                        --simOffset;
                    }
                    Preconditions.checkState((-simOffset < dataFunc.size() ? 1 : 0) != 0, (Object)"No overlap between data and sim funcs");
                    maxIndex = Integer.max(dataFunc.size(), minCurve.size() - simOffset) - 1;
                } else {
                    while ((float)dataFunc.getX(0) > (float)minCurve.getX(-dataOffset) && -dataOffset < minCurve.size()) {
                        --dataOffset;
                    }
                    Preconditions.checkState((-dataOffset < minCurve.size() ? 1 : 0) != 0, (Object)"No overlap between data and sim funcs");
                    maxIndex = Integer.max(minCurve.size(), dataFunc.size() - dataOffset) - 1;
                }
            } else {
                maxIndex = Math.max(minCurve.size(), dataFunc.size()) - 1;
            }
        }
        csv.addLine((List<String>)header);
        for (int i = 0; i <= maxIndex; ++i) {
            ArrayList<Object> line = new ArrayList<Object>();
            int dataI = i + dataOffset;
            if (dataI >= 0 && dataI < dataFunc.size()) {
                line.add("" + (float)dataFunc.getX(dataI));
                line.add("" + (float)dataFunc.getY(dataI));
            } else {
                line.add("");
                line.add("");
            }
            if (calc != null) {
                int modelI = i + simOffset;
                if (modelI < 0 || modelI >= meanFunc.size() || magX && (float)meanFunc.getX(modelI) < (float)this.modelMc) {
                    while (line.size() < header.size()) {
                        line.add("");
                    }
                } else {
                    line.add("" + (float)meanFunc.getY(modelI));
                    line.add("" + (float)medianFunc.getY(modelI));
                    line.add("" + (float)modeFunc.getY(modelI));
                    line.add("" + (float)minCurve.getY(modelI));
                    line.add("" + (float)maxCurve.getY(modelI));
                    for (XY_DataSet fractileFunc : fractileFuncs) {
                        line.add("" + (float)fractileFunc.getY(modelI));
                    }
                }
            }
            csv.addLine((List<String>)line);
        }
        return csv;
    }

    private XY_DataSet notAsIncr(XY_DataSet xy) {
        if (xy instanceof IncrementalMagFreqDist) {
            EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(xy.getMinX(), xy.getMaxX(), xy.size());
            for (int i = 0; i < func.size(); ++i) {
                func.set(i, xy.getY(i));
            }
            return func;
        }
        return xy;
    }

    private XY_DataSet getAboveModelMc(XY_DataSet func) {
        if ((float)func.getMinX() < (float)this.modelMc) {
            DefaultXY_DataSet trimmed = new DefaultXY_DataSet();
            trimmed.setName(func.getName());
            for (Point2D pt : func) {
                if ((float)pt.getX() < (float)this.modelMc) continue;
                trimmed.set(pt);
            }
            return trimmed;
        }
        return func;
    }
}

