/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.estimate;

import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;

public abstract class Estimate {
    protected static final String EST_MSG_MAX_LT_MIN = "Error: Minimum must be less than Maximum";
    protected static final String EST_MSG_NOT_NORMALIZED = "Error: The probability values do not sum to 1";
    protected static final String EST_MSG_PROB_POSITIVE = "Error: All probability values must be positive";
    protected static final String EST_MSG_INVLID_RANGE = "Error: All probabilities must be \u2265 0 and \u2264 1";
    protected static final String EST_MSG_FIRST_LAST_PROB_ZERO = "Error: First and Last probability values must be 0";
    protected static final String MSG_INVALID_STDDEV = "Error: Standard deviation must be positive.";
    protected static final String MSG_ALL_PROB_ZERO = "Error: At least one probability value must be > 0.";
    protected static final String EST_MSG_PROBS_NOT_INCREASING = "Error: Probabilities must be in increasing order";
    protected static final String MEDIAN_UNDEFINED = "Error: Median is undefined";
    protected static final String FRACTILE_UNDEFINED = "Error: Fractile is undefined";
    protected String comments = "";
    protected double min;
    protected double max;
    protected String units;

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public double getMean() {
        throw new UnsupportedOperationException("Method getMean() not supported");
    }

    public double getMedian() {
        throw new UnsupportedOperationException("Method getMedian() not supported");
    }

    public double getStdDev() {
        throw new UnsupportedOperationException("Method getStdDev() not supported");
    }

    public double getFractile(double prob) {
        throw new UnsupportedOperationException("Method getFractile() not supported");
    }

    public double getMode() {
        throw new UnsupportedOperationException("Method getMode() not supported");
    }

    public boolean isNegativeValuePresent() {
        return this.getMin() < 0.0;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public abstract String getName();

    public AbstractDiscretizedFunc getPDF_Test() {
        throw new UnsupportedOperationException("Method getPDF_Test() not supported");
    }

    public AbstractDiscretizedFunc getCDF_Test() {
        throw new UnsupportedOperationException("Method getCDF_Test() not supported");
    }

    public double getProbLessThanEqual(double x) {
        throw new UnsupportedOperationException("Method getProbLessThanEqual() not supported");
    }

    public AbstractDiscretizedFunc getCDF_TestUsingFractile() {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        double minProb = 1.0E-5;
        double maxProb = 0.99999;
        int numPoints = 100;
        double deltaProb = (maxProb - minProb) / (double)(numPoints - 1);
        for (double prob = minProb; prob <= maxProb; prob += deltaProb) {
            func.set(this.getFractile(prob), prob);
        }
        func.setInfo("CDF using getFractile() method");
        return func;
    }

    public String toString() {
        Object text = "Values from Methods:\n";
        try {
            text = (String)text + "Mean = " + this.getMean() + "\n";
        }
        catch (UnsupportedOperationException e) {
            text = (String)text + "Mean = NA\n";
        }
        try {
            text = (String)text + "Mode = " + this.getMode() + "\n";
        }
        catch (UnsupportedOperationException e) {
            text = (String)text + "Mode = NA\n";
        }
        try {
            text = (String)text + "Median = " + this.getMedian() + "\n";
        }
        catch (UnsupportedOperationException e) {
            text = (String)text + "Median = NA\n";
        }
        try {
            text = (String)text + "Std Dev = " + this.getStdDev() + "\n";
        }
        catch (UnsupportedOperationException e) {
            text = (String)text + "Std Dev = NA\n";
        }
        try {
            text = (String)text + "Fractile(0.5) = " + this.getFractile(0.5) + "\n";
        }
        catch (UnsupportedOperationException e) {
            text = (String)text + "Fractile(0.5) = NA\n";
        }
        text = (String)text + "IsNegativeValPresent = " + this.isNegativeValuePresent() + "\n";
        text = (String)text + "Max = " + this.getMax() + "\n";
        text = (String)text + "Min = " + this.getMin() + "\n";
        return text;
    }
}

