/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.estimate;

import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.InvalidParamValException;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;

public class FractileListEstimate
extends Estimate {
    public static final String NAME = "Fractile List";
    private static final double tol = 1.0E-6;
    private AbstractDiscretizedFunc func = null;

    public FractileListEstimate(AbstractDiscretizedFunc func) {
        this.setValues(func);
    }

    @Override
    public String toString() {
        String text = "EstimateType=" + this.getName() + "\n";
        text = text + super.toString() + "\n";
        text = text + "Values from toString() method of specific estimate\nValue\tProbability\n";
        for (int i = 0; this.func != null && i < this.func.size(); ++i) {
            text = text + "\n" + this.func.getX(i) + "\t" + this.func.getY(i);
        }
        return text;
    }

    public void setValues(AbstractDiscretizedFunc func) {
        this.max = func.getMaxX();
        this.min = func.getMinX();
        int numValues = func.size();
        double y_last = -1.0;
        double sum = 0.0;
        for (int i = 0; i < numValues; ++i) {
            double y = func.getY(i);
            sum += y;
            if (y < 0.0 || y > 1.0) {
                throw new InvalidParamValException("Error: All probabilities must be \u2265 0 and \u2264 1");
            }
            if (y_last >= y) {
                throw new InvalidParamValException("Error: Probabilities must be in increasing order");
            }
            y_last = y;
        }
        if (Math.abs(sum - 1.0) > 1.0E-6) {
            throw new InvalidParamValException("Error: The probability values do not sum to 1");
        }
        this.func = (AbstractDiscretizedFunc)func.deepClone();
    }

    @Override
    public double getMedian() {
        int numValues = this.func.size();
        if (numValues == 1 && this.func.getY(0) != 0.5) {
            throw new InvalidParamValException("Error: Median is undefined");
        }
        if (numValues > 1 && (this.func.getY(0) > 0.5 || this.func.getY(numValues - 1) < 0.5)) {
            throw new InvalidParamValException("Error: Median is undefined");
        }
        return this.func.getFirstInterpolatedX(0.5);
    }

    @Override
    public double getFractile(double prob) {
        if (prob > this.func.getY(0) && prob > this.func.getY(this.func.size() - 1)) {
            return this.func.getFirstInterpolatedX(prob);
        }
        throw new InvalidParamValException("Error: Fractile is undefined");
    }

    public AbstractDiscretizedFunc getValues() {
        return this.func;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

