/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import java.io.Serializable;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.exceptions.InvalidRangeException;

public class ArbDiscrEmpiricalDistFunc_3D
implements Serializable {
    protected static final String C = "ArbDiscrEmpiricalDistFunc_3D";
    protected static final boolean D = true;
    HistogramFunction xAxisHist;
    ArbDiscrEmpiricalDistFunc[] arbDiscrEmpDistFuncArray;

    public ArbDiscrEmpiricalDistFunc_3D(double min, int num, double delta) {
        this(min, min + (double)(num - 1) * delta, num);
    }

    public ArbDiscrEmpiricalDistFunc_3D(double min, double max, int num) {
        this.xAxisHist = new HistogramFunction(min, max, num);
        this.arbDiscrEmpDistFuncArray = new ArbDiscrEmpiricalDistFunc[num];
        for (int i = 0; i < num; ++i) {
            this.arbDiscrEmpDistFuncArray[i] = new ArbDiscrEmpiricalDistFunc();
        }
    }

    public void set(double xVal, double yVal, double weight) {
        this.arbDiscrEmpDistFuncArray[this.xAxisHist.getXIndex(xVal)].set(yVal, weight);
    }

    public void set(int xIndex, double yVal, double weight) {
        this.arbDiscrEmpDistFuncArray[xIndex].set(yVal, weight);
    }

    public void set(EvenlyDiscretizedFunc func, double weight) {
        if (func.getMinX() != this.xAxisHist.getMinX() || func.getDelta() != this.xAxisHist.getDelta() || func.size() != this.xAxisHist.size()) {
            throw new RuntimeException("Functions are not consistent");
        }
        for (int i = 0; i < func.size(); ++i) {
            this.set(func.getX(i), func.getY(i), weight);
        }
    }

    public HistogramFunction getXaxisHist() {
        return this.xAxisHist;
    }

    public ArbDiscrEmpiricalDistFunc[] getArbDiscrEmpDistFuncArray() {
        return this.arbDiscrEmpDistFuncArray;
    }

    public double getMinX() {
        return this.xAxisHist.getMinX();
    }

    public double getMaxX() {
        return this.xAxisHist.getMaxX();
    }

    public int getNumX() {
        return this.xAxisHist.size();
    }

    private EvenlyDiscretizedFunc getBaseXaxisFunc() {
        return new EvenlyDiscretizedFunc(this.getMinX(), this.getMaxX(), this.getNumX());
    }

    public EvenlyDiscretizedFunc getInterpolatedFractileCurve(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new InvalidRangeException("fraction value must be between 0 and 1");
        }
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getInterpolatedFractile(fraction));
        }
        return func;
    }

    public EvenlyDiscretizedFunc getDiscreteFractileCurve(double fraction) {
        if (fraction < 0.0 || fraction > 1.0) {
            throw new InvalidRangeException("fraction value must be between 0 and 1");
        }
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getDiscreteFractile(fraction));
        }
        return func;
    }

    public EvenlyDiscretizedFunc getMeanPlusXstdDevCurve(double x) {
        EvenlyDiscretizedFunc mean = this.getMeanCurve();
        EvenlyDiscretizedFunc stdDev = this.getStdDevCurve();
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, mean.getY(i) + x * stdDev.getY(i));
        }
        return func;
    }

    public EvenlyDiscretizedFunc getMeanCurve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getMean());
        }
        return func;
    }

    public EvenlyDiscretizedFunc getMinCurve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getMinX());
        }
        return func;
    }

    public EvenlyDiscretizedFunc getMaxCurve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getMaxX());
        }
        return func;
    }

    public EvenlyDiscretizedFunc getStdDevCurve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getStdDev());
        }
        return func;
    }

    public EvenlyDiscretizedFunc getCOV_Curve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getStdDev() / this.arbDiscrEmpDistFuncArray[i].getMean());
        }
        return func;
    }

    public EvenlyDiscretizedFunc getApparentModeCurve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getApparentMode());
        }
        return func;
    }

    public EvenlyDiscretizedFunc getMostCentralModeCurve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getMostCentralMode());
        }
        return func;
    }

    public EvenlyDiscretizedFunc getMedianCurve() {
        EvenlyDiscretizedFunc func = this.getBaseXaxisFunc();
        for (int i = 0; i < func.size(); ++i) {
            func.set(i, this.arbDiscrEmpDistFuncArray[i].getMedian());
        }
        return func;
    }

    public static void main(String[] args) {
        ArbDiscrEmpiricalDistFunc_3D test = new ArbDiscrEmpiricalDistFunc_3D(0.0, 10.0, 11);
        System.out.println(test.getMeanCurve());
    }
}

