/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.JsonAdapter;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;

@JsonAdapter(value=Adapter.class)
public class EvenlyDiscretizedFunc
extends AbstractDiscretizedFunc {
    private static final long serialVersionUID = 206441789L;
    protected static final String C = "EvenlyDiscretizedFunc";
    protected static final boolean D = false;
    protected double[] points;
    protected double minX = Double.NaN;
    protected double maxX = Double.NaN;
    protected double delta = Double.NaN;
    protected int num;
    protected boolean first = true;
    private static final double PRECISION_SCALE = 1.00000000000001;

    public EvenlyDiscretizedFunc(double min, int num, double delta) {
        this.set(min, num, delta);
    }

    public void set(double min, int num, double delta) {
        this.set(min, min + (double)(num - 1) * delta, num);
    }

    public EvenlyDiscretizedFunc(double min, double max, int num) {
        this.set(min, max, num);
    }

    public void set(double min, double max, int num) {
        if (num <= 0) {
            throw new IllegalArgumentException("num points must be > 0");
        }
        if (num == 1 && min != max) {
            throw new IllegalArgumentException("min must equal max if num points = 1");
        }
        if (min > max) {
            throw new IllegalArgumentException("min must be less than max");
        }
        if (min < max) {
            this.delta = (max - min) / (double)(num - 1);
        } else if (num == 1) {
            this.delta = 0.0;
        } else {
            throw new IllegalArgumentException("num must = 1 if min = max");
        }
        this.minX = min;
        this.maxX = max;
        this.num = num;
        this.points = new double[num];
    }

    public void clear() {
        for (int i = 0; i < this.num; ++i) {
            this.points[i] = Double.NaN;
        }
    }

    protected boolean withinTolerance(double x, double xx) {
        return Math.abs(x - xx) <= this.tolerance;
    }

    public double getDelta() {
        return this.delta;
    }

    @Override
    public int size() {
        return this.num;
    }

    protected boolean isIndexWithinRange(int index) {
        return index >= 0 && index < this.num;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        double minY = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.num; ++i) {
            if (!(this.points[i] < minY)) continue;
            minY = this.points[i];
        }
        return minY;
    }

    @Override
    public double getMaxY() {
        double maxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.num; ++i) {
            if (!(this.points[i] > maxY)) continue;
            maxY = this.points[i];
        }
        return maxY;
    }

    public int getXindexForMaxY() {
        double maxY = Double.NEGATIVE_INFINITY;
        int xIndex = -1;
        for (int i = 0; i < this.num; ++i) {
            if (!(this.points[i] > maxY)) continue;
            maxY = this.points[i];
            xIndex = i;
        }
        return xIndex;
    }

    @Override
    public Point2D get(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return new Point2D.Double(this.getX(index), this.getY(index));
    }

    @Override
    public double getX(int index) {
        if (!this.isIndexWithinRange(index)) {
            throw new IndexOutOfBoundsException("no point at index " + index);
        }
        return this.minX + this.delta * (double)index;
    }

    @Override
    public double getY(int index) {
        if (!this.isIndexWithinRange(index)) {
            throw new IndexOutOfBoundsException("no point at index " + index);
        }
        return this.points[index];
    }

    @Override
    public double getY(double x) {
        return this.getY(this.getXIndex(x));
    }

    @Override
    public int getXIndex(double x) {
        int i = this.getClosestXIndex(x);
        double closestX = this.getX(i);
        return this.withinTolerance(x, closestX) ? i : -1;
    }

    public int getClosestXIndex(double x) {
        int i;
        double iVal = 1.00000000000001 * (x - this.minX) / this.delta;
        int n = i = this.delta == 0.0 ? 0 : (int)Math.round(iVal);
        return i < 0 ? 0 : (i >= this.num ? this.num - 1 : i);
    }

    @Override
    public void set(Point2D point) {
        this.set(point.getX(), point.getY());
    }

    @Override
    public void set(double x, double y) {
        int index = this.getXIndex(x);
        this.points[index] = y;
    }

    public void add(double x, double y) {
        int index = this.getXIndex(x);
        if (index < 0) {
            throw new IllegalArgumentException("No point at x=" + x);
        }
        this.points[index] = y + this.points[index];
    }

    @Override
    public void set(int index, double y) {
        if (!this.isIndexWithinRange(index)) {
            throw new IndexOutOfBoundsException("EvenlyDiscretizedFunc: set(): The specified index (" + index + ") doesn't match this function domain.");
        }
        this.points[index] = y;
    }

    public void add(int index, double y) {
        if (!this.isIndexWithinRange(index)) {
            throw new IndexOutOfBoundsException("EvenlyDiscretizedFunc: set(): The specified index=" + index + " doesn't match this function domain.");
        }
        this.points[index] = y + this.points[index];
    }

    public Iterator<Point2D> getPointsIterator() {
        ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
        for (int i = 0; i < this.num; ++i) {
            list.add(new Point2D.Double(this.getX(i), this.getY(i)));
        }
        return list.listIterator();
    }

    @Override
    protected int getXIndexBefore(double x) {
        return (int)Math.floor((x - this.minX) / this.delta);
    }

    @Override
    public double getClosestYtoX(double x) {
        double x2;
        double d2;
        if (x >= this.maxX) {
            return this.getY(this.size() - 1);
        }
        if (x <= this.minX) {
            return this.getY(0);
        }
        int ind = this.getXIndexBefore(x);
        double x1 = this.getX(ind);
        double d1 = x - x1;
        if (d1 < (d2 = (x2 = this.getX(ind + 1)) - x)) {
            return this.getY(ind);
        }
        return this.getY(ind + 1);
    }

    @Override
    public EvenlyDiscretizedFunc deepClone() {
        EvenlyDiscretizedFunc f = new EvenlyDiscretizedFunc(this.minX, this.num, this.delta);
        f.info = this.info;
        f.minX = this.minX;
        f.maxX = this.maxX;
        f.name = this.name;
        f.xAxisName = this.xAxisName;
        f.yAxisName = this.yAxisName;
        f.tolerance = this.tolerance;
        f.setInfo(this.getInfo());
        f.setName(this.getName());
        for (int i = 0; i < this.num; ++i) {
            f.set(i, this.points[i]);
        }
        return f;
    }

    public boolean equalXValues(DiscretizedFunc function) {
        if (!(function instanceof EvenlyDiscretizedFunc)) {
            return false;
        }
        if (this.num != function.size()) {
            return false;
        }
        double min = this.minX;
        double min1 = ((EvenlyDiscretizedFunc)function).getMinX();
        if (!this.withinTolerance(min, min1)) {
            return false;
        }
        double d = this.delta;
        double d1 = ((EvenlyDiscretizedFunc)function).getDelta();
        return d == d1;
    }

    @Override
    public boolean areAllXValuesInteger(double tolerance) {
        double diff = Math.abs(this.minX - Math.rint(this.minX));
        if (diff > tolerance) {
            return false;
        }
        diff = Math.abs(this.delta - Math.rint(this.delta));
        return !(diff > tolerance);
    }

    public boolean equalXAndYValues(DiscretizedFunc function) {
        if (!this.equalXValues(function)) {
            return false;
        }
        for (int i = 0; i < this.num; ++i) {
            double y1 = this.getY(i);
            double y2 = function.getY(i);
            if (Double.isNaN(y1) && !Double.isNaN(y2)) {
                return false;
            }
            if (Double.isNaN(y2) && !Double.isNaN(y1)) {
                return false;
            }
            if (y1 == y2) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer().append("     Name: ").append(this.getName()).append(IOUtils.LINE_SEPARATOR).append("   Points: ").append(this.size()).append(IOUtils.LINE_SEPARATOR).append("     Info: ").append(this.getInfo()).append(IOUtils.LINE_SEPARATOR).append(IOUtils.LINE_SEPARATOR).append("Data[x,y]:").append(IOUtils.LINE_SEPARATOR).append(this.getMetadataString()).append(IOUtils.LINE_SEPARATOR);
        return b.toString();
    }

    @Override
    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        for (Point2D point : this) {
            double x = point.getX();
            double y = point.getY();
            b.append((float)x + "\t  " + (float)y + "\n");
        }
        return b.toString();
    }

    @Override
    public int getIndex(Point2D point) {
        int index = this.getXIndex(point.getX());
        if (index < 0) {
            return -1;
        }
        double y = this.getY(index);
        if (y != point.getY()) {
            return -1;
        }
        return index;
    }

    public static class Adapter
    extends DiscretizedFunc.AbstractAdapter<EvenlyDiscretizedFunc> {
        @Override
        protected EvenlyDiscretizedFunc instance(Double minX, Double maxX, Integer size) {
            Preconditions.checkNotNull((Object)minX, (Object)"minX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)maxX, (Object)"maxX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)size, (Object)"size must be supplied before values to deserialize EvenlyDiscretizedFunc");
            return new EvenlyDiscretizedFunc((double)minX, maxX, size);
        }

        @Override
        protected Class<EvenlyDiscretizedFunc> getType() {
            return EvenlyDiscretizedFunc.class;
        }
    }
}

