/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;

public class SiteDataValueList<E>
implements XMLSaveable,
Serializable {
    public static final String XML_METADATA_NAME = "SiteDataValueList";
    private String dataType;
    private String dataMeasurementType;
    private ArrayList<E> values;
    private String sourceName = null;
    private LocationList locs = null;

    public SiteDataValueList(ArrayList<E> values, SiteData<E> source) {
        this(values, source, null);
    }

    public SiteDataValueList(ArrayList<E> values, SiteData<E> source, LocationList locs) {
        this(source.getDataType(), source.getDataMeasurementType(), values, source.getName(), locs);
    }

    public SiteDataValueList(String dataType, String dataMeasurementType, ArrayList<E> values, String sourceName) {
        this(dataType, dataMeasurementType, values, sourceName, null);
    }

    public SiteDataValueList(String dataType, String dataMeasurementType, ArrayList<E> values, String sourceName, LocationList locs) {
        this.dataType = dataType;
        this.dataMeasurementType = dataMeasurementType;
        this.values = values;
        this.sourceName = sourceName;
        this.locs = locs;
        if (values == null) {
            throw new RuntimeException("Values cannot be null!");
        }
        if (locs != null && locs.size() != values.size()) {
            throw new RuntimeException("Locations must be null, or contain the same amount of points as values!");
        }
    }

    public String getType() {
        return this.dataType;
    }

    public String getFlag() {
        return this.dataMeasurementType;
    }

    public SiteDataValue<E> getValue(int index) {
        return new SiteDataValue<E>(this.dataType, this.dataMeasurementType, this.values.get(index), this.sourceName);
    }

    public Location getLocationAt(int index) {
        if (this.locs == null) {
            return null;
        }
        return (Location)this.locs.get(index);
    }

    public ArrayList<E> getValues() {
        return this.values;
    }

    public E getValueForLocation(Location loc) {
        for (int i = 0; i < this.locs.size(); ++i) {
            Location valLoc = (Location)this.locs.get(i);
            if (!loc.equals(valLoc)) continue;
            return this.values.get(i);
        }
        return null;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int size() {
        return this.values.size();
    }

    public LocationList getLocationList() {
        return this.locs;
    }

    public boolean hasLocations() {
        return this.locs != null;
    }

    public String toString() {
        String str = "Type: " + this.dataType + ", Measurement Type: " + this.dataMeasurementType + ", Num: " + this.values.size();
        if (this.sourceName != null) {
            str = str + ", Source: " + this.sourceName;
        }
        return str;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("Type", this.getType());
        el.addAttribute("TypeFlag", this.getFlag());
        el.addAttribute("SourceName", this.getSourceName());
        el.addAttribute("Num", "" + this.size());
        Element valsEl = el.addElement("Values");
        boolean hasLocs = this.hasLocations();
        ArrayList<E> vals = this.getValues();
        if (hasLocs) {
            LocationList list = this.getLocationList();
            list.toXMLMetadata(root);
        }
        for (int i = 0; i < vals.size(); ++i) {
            E val = vals.get(i);
            if (val instanceof Double) {
                Double dVal = (Double)val;
                if (dVal.isNaN()) {
                    continue;
                }
            } else if (val instanceof String) {
                String sVal = (String)val;
                if (this.dataType.equals("Vs30") ? sVal.equals("NA") : sVal.length() == 0) continue;
            }
            Element valEl = valsEl.addElement("V");
            valEl.addAttribute("v", val.toString());
            valEl.addAttribute("i", "" + i);
        }
        return el;
    }

    public static final SiteDataValueList<?> fromXMLMetadata(Element dataElement) {
        String type = dataElement.attributeValue("Type");
        String flag = dataElement.attributeValue("TypeFlag");
        String name = dataElement.attributeValue("SourceName");
        int num = Integer.parseInt(dataElement.attributeValue("Num"));
        if (name != null && name.equals("null")) {
            name = null;
        }
        boolean isDouble = false;
        boolean isString = false;
        if (type.equals("Vs30")) {
            isDouble = true;
        } else if (type.equals("Wills Class")) {
            isString = true;
        } else if (type.equals("Depth to Vs = 2.5 km/sec")) {
            isDouble = true;
        } else if (type.equals("Depth to Vs = 1.0 km/sec")) {
            isDouble = true;
        } else {
            throw new RuntimeException("Type '" + type + "' unknown, cannot load from XML!");
        }
        Element locsEl = dataElement.element("LocationList");
        LocationList locs = null;
        if (locsEl != null) {
            locs = LocationList.fromXMLMetadata(locsEl);
        }
        Element valsEl = dataElement.element("Values");
        Iterator valsIt = valsEl.elementIterator();
        ArrayList<Object> vals = null;
        if (isDouble) {
            vals = new ArrayList<Object>();
            for (int i = 0; i < num; ++i) {
                vals.add(Double.NaN);
            }
        } else if (isString) {
            vals = new ArrayList();
            for (int i = 0; i < num; ++i) {
                if (type.equals("Wills Class")) {
                    vals.add("NA");
                    continue;
                }
                vals.add("");
            }
        }
        while (valsIt.hasNext()) {
            Element valEl = (Element)valsIt.next();
            String strVal = valEl.attributeValue("v");
            int i = Integer.parseInt(valEl.attributeValue("i"));
            if (isString) {
                vals.set(i, strVal);
                continue;
            }
            if (!isDouble) continue;
            vals.set(i, Double.parseDouble(strVal));
        }
        SiteDataValueList list = null;
        if (isDouble) {
            list = new SiteDataValueList(type, flag, vals, name, locs);
        } else if (isString) {
            list = new SiteDataValueList(type, flag, vals, name, locs);
        }
        return list;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<Double> vals = new ArrayList<Double>();
        LocationList locs = new LocationList();
        vals.add(0.5);
        locs.add(new Location(34.0, -120.6));
        vals.add(0.4);
        locs.add(new Location(34.0, -120.5));
        vals.add(0.3);
        locs.add(new Location(34.0, -120.4));
        vals.add(0.2);
        locs.add(new Location(34.0, -120.3));
        vals.add(0.1);
        locs.add(new Location(34.0, -120.2));
        vals.add(0.05);
        locs.add(new Location(34.0, -120.1));
        SiteDataValueList list = new SiteDataValueList("Vs30", "asdfas", vals, null, locs);
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        Element el = list.toXMLMetadata(root);
        XMLUtils.writeDocumentToFile(new File("/tmp/xml.xml"), doc);
        System.out.println(SiteDataValueList.fromXMLMetadata(el));
    }
}

