/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.AbstractBinarySiteDataLoader;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.CachedSiteDataWrapper;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.XMLUtils;

public class CVM4i26BasinDepth
extends AbstractBinarySiteDataLoader {
    public static final String NAME = "SCEC Community Velocity Model Version 4, Iteration 26, Basin Depth";
    public static final String SHORT_NAME = "CVM4i26";
    public static final double minLat = 31.0;
    public static final double minLon = -121.0;
    private static final int nx = 1701;
    private static final int ny = 1101;
    private static final long MAX_FILE_POS = 7491204L;
    public static final double gridSpacing = 0.005;
    public static final String DEPTH_2_5_FILE = "src/main/resources/data/site/CVM4i26/depth_2.5.bin";
    public static final String DEPTH_1_0_FILE = "src/main/resources/data/site/CVM4i26/depth_1.0.bin";
    public static final String SERVLET_2_5_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVM4i26_2_5";
    public static final String SERVLET_1_0_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVM4i26_1_0";

    public CVM4i26BasinDepth(String type) throws IOException {
        this(type, null, true);
    }

    public CVM4i26BasinDepth(String type, boolean useServlet) throws IOException {
        this(type, null, useServlet);
    }

    public CVM4i26BasinDepth(String type, File dataFile) throws IOException {
        this(type, dataFile, false);
    }

    public CVM4i26BasinDepth(String type, File dataFile, boolean useServlet) throws IOException {
        super(1701, 1101, 31.0, -121.0, 0.005, true, true, type, dataFile, useServlet);
    }

    @Override
    protected File getDefaultFile(String type) {
        if (type.equals("Depth to Vs = 1.0 km/sec")) {
            return new File(DEPTH_1_0_FILE);
        }
        return new File(DEPTH_2_5_FILE);
    }

    @Override
    protected String getServletURL(String type) {
        if (type.equals("Depth to Vs = 1.0 km/sec")) {
            return SERVLET_1_0_URL;
        }
        return SERVLET_2_5_URL;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return this.getDataType() + ", extracted from version 4 of the SCEC Community Velocity Model iteration 26-M01 (inversions by Po Chen and others). Extracted with UCVM on July 26 2017 by Scott Callaghan";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", "" + this.useServlet);
        if (this.dataFile != null) {
            paramsEl.addAttribute("fileName", this.dataFile.getPath());
        }
        paramsEl.addAttribute("type", this.getDataType());
        return super.addXMLParameters(paramsEl);
    }

    public static CVM4i26BasinDepth fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        Attribute fileAtt = paramsElem.attribute("fileName");
        File file = null;
        if (fileAtt != null) {
            file = new File(fileAtt.getStringValue());
        }
        String type = paramsElem.attributeValue("type");
        return new CVM4i26BasinDepth(type, file, useServlet);
    }

    public static void main(String[] args) throws IOException {
        double d;
        CVM4i26BasinDepth map = new CVM4i26BasinDepth("Depth to Vs = 1.0 km/sec");
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        map.getAdjustableParameterList().getParameter("Minimum Basin Depth").setValue(1.0);
        Element mapEl = map.toXMLMetadata(root).element("SiteDataAPI");
        XMLUtils.writeDocumentToFile(new File("/tmp/cvm4.xml"), doc);
        map = (CVM4i26BasinDepth)AbstractSiteData.fromXMLMetadata(mapEl);
        System.out.println("Min: " + String.valueOf(map.getAdjustableParameterList().getParameter("Minimum Basin Depth").getValue()));
        CachedSiteDataWrapper<Double> cache = new CachedSiteDataWrapper<Double>(map);
        LocationList locs = new LocationList();
        locs.add(new Location(34.0192, -118.288));
        locs.add(new Location(34.9192, -118.32));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        locs.add(new Location(34.6192, -118.186));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        locs.add(new Location(34.792, -118.8));
        locs.add(new Location(34.292, -118.386));
        map.getValues(locs);
        long time = System.currentTimeMillis();
        for (Location loc : locs) {
            double d2 = map.getValue(loc);
        }
        double secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Raw time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            d = cache.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Cache time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            d = map.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Raw time: " + secs + "s");
        time = System.currentTimeMillis();
        for (Location loc : locs) {
            d = cache.getValue(loc);
        }
        secs = (double)(System.currentTimeMillis() - time) / 1000.0;
        System.out.println("Cache time: " + secs + "s");
    }
}

