/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public enum TectonicRegime {
    ANSR_DEEPCON("ACR (deep)", "ANSR-DEEPCON", "ANSR_DEEPCON"),
    ANSR_HOTSPOT("ACR (hot spot)", "ANSR-HOTSPOT", "ANSR_HOTSPOT"),
    ANSR_OCEANBD("ACR (oceanic boundary)", "ANSR-OCEANBD", "ANSR_OCEANBD"),
    ANSR_SHALCON("ACR (shallow)", "ANSR-SHALCON", "ANSR_SHALCON"),
    ANSR_ABSLDEC("ACR deep (above slab)", "ANSR-ABSLDEC", "ANSR_ABSLDEC"),
    ANSR_ABSLOCB("ACR oceanic boundary (above slab)", "ANSR-ABSLOCB", "ANSR_ABSLOCB"),
    ANSR_ABSLSHC("ACR shallow (above slab)", "ANSR-ABSLSHC", "ANSR_ABSLSHC"),
    SCR_ABVSLAB("SCR (above slab)", "SCR-ABVSLAB", "SCR_ABVSLAB"),
    SCR_GENERIC("SCR (generic)", "SCR-GENERIC", "SCR_GENERIC"),
    SOR_ABVSLAB("SOR (above slab)", "SOR-ABVSLAB", "SOR_ABVSLAB"),
    SOR_GENERIC("SOR (generic)", "SOR-GENERIC", "SOR_GENERIC"),
    SZ_GENERIC("SZ (generic)", "SZ-GENERIC", "SZ_GENERIC"),
    SZ_INLBACK("SZ (inland/back-arc)", "SZ-INLBACK", "SZ_INLBACK"),
    SZ_ONSHORE("SZ (on-shore)", "SZ-ONSHORE", "SZ_ONSHORE"),
    SZ_OUTERTR("SZ (outer-trench)", "SZ-OUTERTR", "SZ_OUTERTR"),
    CALIFORNIA("California", "CALIFORNIA"),
    GLOBAL_AVERAGE("Global Average", "GLOBAL-AVERAGE");

    private static Map<String, TectonicRegime> mappings;
    private String[] names;

    private TectonicRegime(String ... names) {
        this.names = names;
    }

    public String getPreferredName() {
        return this.names[0];
    }

    public String[] getNames() {
        return this.names;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public static synchronized TectonicRegime forName(String name) {
        if (mappings == null) {
            mappings = Maps.newHashMap();
            for (TectonicRegime regime : TectonicRegime.values()) {
                for (String rName : regime.names) {
                    Preconditions.checkState((!mappings.containsKey(rName) ? 1 : 0) != 0);
                    mappings.put(rName, regime);
                }
            }
        }
        return mappings.get(name);
    }

    static {
        mappings = null;
    }
}

