/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.servlet;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.siteData.ServletEnabledSiteData;
import org.opensha.commons.data.siteData.servlet.AbstractSiteDataServlet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;

public class SiteDataServletAccessor<Element> {
    private String url;
    private ServletEnabledSiteData<Element> data;
    private int maxLocsPerRequest = 100000;

    public SiteDataServletAccessor(ServletEnabledSiteData<Element> data, String servletURL) {
        this.url = servletURL;
        this.data = data;
    }

    public int getMaxLocsPerRequest() {
        return this.maxLocsPerRequest;
    }

    public void setMaxLocsPerRequest(int maxLocsPerRequest) {
        this.maxLocsPerRequest = maxLocsPerRequest;
    }

    public Element getValue(Location loc) throws IOException {
        return (Element)this.getResult(SiteDataServletAccessor.locToArray(loc));
    }

    private static double[] locToArray(Location loc) {
        if (loc.getDepth() == 0.0) {
            return new double[]{loc.getLatitude(), loc.getLongitude()};
        }
        return new double[]{loc.getLatitude(), loc.getLongitude(), loc.getDepth()};
    }

    public Location getClosestLocation(Location loc) throws IOException {
        return (Location)this.getResult(loc, AbstractSiteDataServlet.OP_GET_CLOSEST);
    }

    public ArrayList<Element> getValues(LocationList locs) throws IOException {
        ArrayList result = null;
        if (this.maxLocsPerRequest > 0 && locs.size() > this.maxLocsPerRequest) {
            result = new ArrayList();
            int done = 0;
            int tot = locs.size();
            for (LocationList partialLocs : locs.split(this.maxLocsPerRequest)) {
                float frac = (float)done / (float)tot * 100.0f;
                result.addAll((ArrayList)this.getResult(SiteDataServletAccessor.locListToArrays(partialLocs)));
                done += partialLocs.size();
            }
        } else {
            result = (ArrayList)this.getResult(SiteDataServletAccessor.locListToArrays(locs));
        }
        return result;
    }

    private static List<double[]> locListToArrays(LocationList locs) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        for (Location loc : locs) {
            ret.add(SiteDataServletAccessor.locToArray(loc));
        }
        return ret;
    }

    private Object getResult(Object request) throws IOException {
        return this.getResult(request, null);
    }

    private Object getResult(Object request, String operation) throws IOException {
        URLConnection servletConnection = this.openServletConnection();
        ObjectOutputStream outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
        ParameterList serverParams = this.data.getServerSideParams();
        if (serverParams != null && serverParams.size() > 0) {
            ArrayList paramVals = Lists.newArrayList();
            for (Parameter<?> param : serverParams) {
                paramVals.add(param.getValue());
            }
            outputToServlet.writeObject(paramVals);
        }
        if (operation != null && operation.length() > 0) {
            outputToServlet.writeObject(operation);
        }
        outputToServlet.writeObject(request);
        ObjectInputStream inputFromServlet = new ObjectInputStream(servletConnection.getInputStream());
        try {
            Object result = inputFromServlet.readObject();
            this.checkForError(result, inputFromServlet);
            inputFromServlet.close();
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkForError(Object obj, ObjectInputStream inputFromServlet) throws IOException, ClassNotFoundException {
        if (obj instanceof Boolean) {
            String message = (String)inputFromServlet.readObject();
            throw new RuntimeException("Status Request Failed: " + message);
        }
    }

    protected URLConnection openServletConnection() throws IOException {
        URL servlet = new URL(this.url);
        URLConnection servletConnection = servlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(true);
        servletConnection.setUseCaches(false);
        servletConnection.setDefaultUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
        return servletConnection;
    }
}

