/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.uncertainty;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.JsonAdapter;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;

@JsonAdapter(value=Uncertainty.UncertaintyAdapter.class)
public class BoundedUncertainty
extends Uncertainty {
    public final UncertaintyBoundType type;
    public final double lowerBound;
    public final double upperBound;

    public static BoundedUncertainty fromMeanAndBounds(UncertaintyBoundType type, double bestEstimate, double lowerBound, double upperBound) {
        return new BoundedUncertainty(type, lowerBound, upperBound, type.estimateStdDev(lowerBound, upperBound));
    }

    public BoundedUncertainty(UncertaintyBoundType type, double lowerBound, double upperBound, double stdDev) {
        super(stdDev);
        this.type = type;
        Preconditions.checkState((boolean)Double.isFinite(lowerBound), (String)"Lower uncertainty bound is non-finite: %s", (Object)Float.valueOf((float)lowerBound));
        this.lowerBound = lowerBound;
        Preconditions.checkState((lowerBound <= upperBound ? 1 : 0) != 0, (String)"Upper uncertainty bound non-finite or less than lower bound (%s): %s", (Object)Float.valueOf((float)lowerBound), (Object)Float.valueOf((float)upperBound));
        this.upperBound = upperBound;
    }

    @Override
    public String toString() {
        return "type=" + this.type.name() + "\tbounds=[" + (float)this.lowerBound + ", " + (float)this.upperBound + "]\tstdDev=" + (float)this.stdDev;
    }

    public boolean contains(double value) {
        return value >= this.lowerBound && value <= this.upperBound;
    }

    @Override
    public BoundedUncertainty scaled(double bestEstimate, double scalar) {
        double newSD = this.stdDev * scalar;
        return this.type.estimate(bestEstimate, newSD);
    }

    public static BoundedUncertainty weightedCombination(WeightedList<BoundedUncertainty> uncertainties) {
        Preconditions.checkState((!uncertainties.isEmpty() ? 1 : 0) != 0);
        if (uncertainties.size() == 1) {
            return uncertainties.getValue(0);
        }
        double weightSum = 0.0;
        double muSum = 0.0;
        double ex2Sum = 0.0;
        UncertaintyBoundType type = null;
        for (int i = 0; i < uncertainties.size(); ++i) {
            double weight = uncertainties.getWeight(i);
            BoundedUncertainty uncert = uncertainties.getValue(i);
            if (i == 0) {
                type = uncert.type;
            } else {
                Preconditions.checkState((type == uncert.type ? 1 : 0) != 0, (String)"All uncertainties must be of the same type (first is %s, also have %s)", (Object)((Object)type), (Object)((Object)uncert.type));
            }
            double mu_i = 0.5 * (uncert.lowerBound + uncert.upperBound);
            double sigma_i = type.estimateStdDev(uncert.lowerBound, uncert.upperBound);
            muSum += weight * mu_i;
            ex2Sum += weight * (sigma_i * sigma_i + mu_i * mu_i);
            weightSum += weight;
        }
        double muMix = muSum / weightSum;
        double ex2Mix = ex2Sum / weightSum;
        double varMix = ex2Mix - muMix * muMix;
        double stdDev = Math.sqrt(varMix);
        double lowerBound = muMix - type.z * stdDev;
        double upperBound = muMix + type.z * stdDev;
        return new BoundedUncertainty(type, lowerBound, upperBound, stdDev);
    }
}

