/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.uncertainty;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;

@JsonAdapter(value=UncertaintyAdapter.class)
public class Uncertainty {
    public final double stdDev;

    public Uncertainty(double stdDev) {
        this.stdDev = stdDev;
    }

    public Uncertainty scaled(double bestEstimate, double scalar) {
        return new Uncertainty(this.stdDev * scalar);
    }

    public String toString() {
        return "stdDev=" + (float)this.stdDev;
    }

    static class UncertaintyAdapter
    extends TypeAdapter<Uncertainty> {
        UncertaintyAdapter() {
        }

        public void write(JsonWriter out, Uncertainty value) throws IOException {
            out.beginObject();
            out.name("stdDev").value(value.stdDev);
            if (value instanceof BoundedUncertainty) {
                BoundedUncertainty bounded = (BoundedUncertainty)value;
                if (bounded.type != null) {
                    out.name("type").value(bounded.type.name());
                }
                out.name("lowerBound").value(bounded.lowerBound);
                out.name("upperBound").value(bounded.upperBound);
            }
            out.endObject();
        }

        public Uncertainty read(JsonReader in) throws IOException {
            Double stdDev = null;
            Double lowerBound = null;
            Double upperBound = null;
            UncertaintyBoundType type = null;
            in.beginObject();
            block12: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "stdDev": {
                        stdDev = in.nextDouble();
                        continue block12;
                    }
                    case "lowerBound": {
                        lowerBound = in.nextDouble();
                        continue block12;
                    }
                    case "upperBound": {
                        upperBound = in.nextDouble();
                        continue block12;
                    }
                    case "type": {
                        type = UncertaintyBoundType.valueOf(in.nextString());
                        continue block12;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            Preconditions.checkNotNull(stdDev, (Object)"must supply standard deviation for uncertainty");
            if (lowerBound != null || upperBound != null || type != null) {
                Preconditions.checkState((lowerBound != null && upperBound != null ? 1 : 0) != 0, (Object)"Must supply both lower and upper bounds for bounded uncertainty");
                return new BoundedUncertainty(type, lowerBound, upperBound, stdDev);
            }
            return new Uncertainty(stdDev);
        }
    }
}

