/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.util.DataUtils;

public abstract class AbstractXYZ_DataSet
implements XYZ_DataSet {
    private static final long serialVersionUID = 1L;

    private DataUtils.MinMaxAveTracker getXTracker() {
        DataUtils.MinMaxAveTracker tracker = new DataUtils.MinMaxAveTracker();
        for (Point2D pt : this.getPointList()) {
            tracker.addValue(pt.getX());
        }
        return tracker;
    }

    private DataUtils.MinMaxAveTracker getYTracker() {
        DataUtils.MinMaxAveTracker tracker = new DataUtils.MinMaxAveTracker();
        for (Point2D pt : this.getPointList()) {
            tracker.addValue(pt.getY());
        }
        return tracker;
    }

    private DataUtils.MinMaxAveTracker getZTracker() {
        DataUtils.MinMaxAveTracker tracker = new DataUtils.MinMaxAveTracker();
        for (double val : this.getValueList()) {
            tracker.addValue(val);
        }
        return tracker;
    }

    @Override
    public double getMinX() {
        return this.getXTracker().getMin();
    }

    @Override
    public double getMaxX() {
        return this.getXTracker().getMax();
    }

    @Override
    public double getMinY() {
        return this.getYTracker().getMin();
    }

    @Override
    public double getMaxY() {
        return this.getYTracker().getMax();
    }

    @Override
    public double getMinZ() {
        return this.getZTracker().getMin();
    }

    @Override
    public double getMaxZ() {
        return this.getZTracker().getMax();
    }

    @Override
    public double getSumZ() {
        double sum = 0.0;
        for (int index = 0; index < this.size(); ++index) {
            sum += this.get(index);
        }
        return sum;
    }

    @Override
    public void setAll(XYZ_DataSet dataset) {
        for (int i = 0; i < dataset.size(); ++i) {
            this.set(dataset.getPoint(i), dataset.get(i));
        }
    }

    @Override
    public List<Point2D> getPointList() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int i = 0; i < this.size(); ++i) {
            points.add(this.getPoint(i));
        }
        return points;
    }

    @Override
    public List<Double> getValueList() {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i = 0; i < this.size(); ++i) {
            vals.add(this.get(i));
        }
        return vals;
    }

    public static void writeXYZFile(XYZ_DataSet xyz, String fileName) throws IOException {
        AbstractXYZ_DataSet.writeXYZFile(xyz, new File(fileName));
    }

    public static void writeXYZFile(XYZ_DataSet xyz, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (int i = 0; i < xyz.size(); ++i) {
            Point2D point = xyz.getPoint(i);
            double z = xyz.get(i);
            fw.write(point.getX() + "\t" + point.getY() + "\t" + z + "\n");
        }
        fw.close();
    }

    public static void writeXYZStream(XYZ_DataSet xyz, OutputStream out) throws IOException {
        AbstractXYZ_DataSet.writeXYZWriter(xyz, new OutputStreamWriter(out));
        out.flush();
    }

    public static void writeXYZWriter(XYZ_DataSet xyz, Writer write) throws IOException {
        if (!(write instanceof BufferedWriter)) {
            write = new BufferedWriter(write);
        }
        for (int i = 0; i < xyz.size(); ++i) {
            Point2D point = xyz.getPoint(i);
            double z = xyz.get(i);
            write.write(String.valueOf(point.getX()));
            write.write(9);
            write.write(String.valueOf(point.getY()));
            write.write(9);
            write.write(String.valueOf(z));
            write.write(10);
        }
        write.flush();
    }

    @Override
    public void abs() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, Math.abs(this.get(i)));
        }
    }

    @Override
    public void log() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, Math.log(this.get(i)));
        }
    }

    @Override
    public void log10() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, Math.log10(this.get(i)));
        }
    }

    @Override
    public void exp() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, Math.exp(this.get(i)));
        }
    }

    @Override
    public void exp(double base) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, Math.pow(10.0, this.get(i)));
        }
    }

    @Override
    public void pow(double pow) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, Math.pow(this.get(i), pow));
        }
    }

    @Override
    public void scale(double scalar) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.get(i) * scalar);
        }
    }

    @Override
    public void add(double value) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.get(i) + value);
        }
    }
}

