/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.opensha.commons.data.xyz.AbstractXYZ_DataSet;
import org.opensha.commons.util.FileUtils;

public class ArbDiscrXYZ_DataSet
extends AbstractXYZ_DataSet {
    private static final long serialVersionUID = 1L;
    private ArrayList<Point2D> points = new ArrayList();
    private HashMap<Point2D, Double> map = new HashMap();

    @Override
    public void set(Point2D point, double z) {
        if (point == null) {
            throw new NullPointerException("Point cannot be null");
        }
        if (!this.contains(point)) {
            this.points.add(point);
        }
        this.map.put(point, z);
    }

    @Override
    public void set(double x, double y, double z) {
        this.set(new Point2D.Double(x, y), z);
    }

    @Override
    public void set(int index, double z) {
        this.set(this.getPoint(index), z);
    }

    @Override
    public void add(Point2D point, double z) {
        if (point == null) {
            throw new NullPointerException("Point cannot be null");
        }
        if (!this.contains(point)) {
            this.points.add(point);
        }
        double prev = this.map.containsKey(point) ? this.map.get(point) : 0.0;
        this.map.put(point, z + prev);
    }

    @Override
    public void add(double x, double y, double z) {
        this.add(new Point2D.Double(x, y), z);
    }

    @Override
    public void add(int index, double z) {
        this.add(this.getPoint(index), z);
    }

    @Override
    public double get(Point2D point) {
        return this.map.get(point);
    }

    @Override
    public double get(double x, double y) {
        return this.get(new Point2D.Double(x, y));
    }

    @Override
    public double get(int index) {
        return this.get(this.getPoint(index));
    }

    @Override
    public Point2D getPoint(int index) {
        return this.points.get(index);
    }

    @Override
    public int indexOf(Point2D point) {
        return this.points.indexOf(point);
    }

    @Override
    public boolean contains(Point2D point) {
        return this.map.containsKey(point);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public int size() {
        return this.points.size();
    }

    public Object clone() {
        return this.copy();
    }

    @Override
    public ArbDiscrXYZ_DataSet copy() {
        ArbDiscrXYZ_DataSet xyz = new ArbDiscrXYZ_DataSet();
        for (int i = 0; i < this.size(); ++i) {
            xyz.set(this.getPoint(i), this.get(i));
        }
        return xyz;
    }

    @Override
    public int indexOf(double x, double y) {
        return this.indexOf(new Point2D.Double(x, y));
    }

    @Override
    public List<Point2D> getPointList() {
        return this.points;
    }

    public static ArbDiscrXYZ_DataSet loadXYZFile(String fileName) throws FileNotFoundException, IOException {
        ArrayList<String> lines = FileUtils.loadFile(fileName);
        ArbDiscrXYZ_DataSet xyz = new ArbDiscrXYZ_DataSet();
        for (String line : lines) {
            StringTokenizer tok;
            if (line.startsWith("#") || line.length() < 2 || (tok = new StringTokenizer(line)).countTokens() < 3) continue;
            double x = Double.parseDouble(tok.nextToken());
            double y = Double.parseDouble(tok.nextToken());
            double z = Double.parseDouble(tok.nextToken());
            xyz.set(x, y, z);
        }
        return xyz;
    }
}

