/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.opensha.commons.data.xyz.AbstractGeoDataSet;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.ArbDiscrXYZ_DataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;

public class FixedLocationArbDiscrGeoDataSet
extends AbstractGeoDataSet {
    private static final long serialVersionUID = 1L;
    private ImmutableList<Location> points;
    private ImmutableMap<Location, Integer> locIndexMap;
    private double[] values;

    public FixedLocationArbDiscrGeoDataSet(FixedLocationArbDiscrGeoDataSet other) {
        this(other.points, other.locIndexMap, Arrays.copyOf(other.values, other.values.length));
    }

    public FixedLocationArbDiscrGeoDataSet(GeoDataSet other) {
        this((ImmutableList<Location>)ImmutableList.copyOf((Collection)other.getLocationList()), null, Doubles.toArray(other.getValueList()));
    }

    public FixedLocationArbDiscrGeoDataSet(ImmutableList<Location> locs) {
        this(locs, null);
    }

    public FixedLocationArbDiscrGeoDataSet(ImmutableList<Location> locs, ImmutableMap<Location, Integer> locIndexMap) {
        this(locs, locIndexMap, null);
    }

    public FixedLocationArbDiscrGeoDataSet(ImmutableList<Location> locs, ImmutableMap<Location, Integer> locIndexMap, double[] values) {
        this(locs, locIndexMap, values, false);
    }

    public FixedLocationArbDiscrGeoDataSet(ImmutableList<Location> locs, ImmutableMap<Location, Integer> locIndexMap, double[] values, boolean latitudeX) {
        super(latitudeX);
        this.points = locs;
        if (locIndexMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < this.points.size(); ++i) {
                builder.put((Object)((Location)this.points.get(i)), (Object)i);
            }
            locIndexMap = builder.build();
        } else {
            Preconditions.checkState((locIndexMap.size() == this.points.size() ? 1 : 0) != 0, (Object)"supplied locIndexMap is of wrong size");
            for (int i = 0; i < this.points.size(); ++i) {
                Location loc = (Location)this.points.get(i);
                Integer index = (Integer)locIndexMap.get((Object)loc);
                Preconditions.checkNotNull((Object)index, (String)"supplied locIndexMap is missing location %s: %s", (int)i, (Object)loc);
                Preconditions.checkState((index == i ? 1 : 0) != 0, (String)"supplied locIndexMap is wrong, says location %s is %s but should be %s", (Object)loc, (Object)index, (Object)i);
            }
        }
        this.locIndexMap = locIndexMap;
        if (values == null) {
            this.values = new double[locs.size()];
        } else {
            Preconditions.checkState((values.length == locs.size() ? 1 : 0) != 0);
            this.values = values;
        }
    }

    @Override
    public void set(Location loc, double value) {
        if (loc == null) {
            throw new NullPointerException("Location cannot be null");
        }
        Integer index = (Integer)this.locIndexMap.get((Object)loc);
        Preconditions.checkState((index != null ? 1 : 0) != 0, (String)"Location doesn't exist in map and cannot add to fixed map: %s", (Object)loc);
        this.values[index.intValue()] = value;
    }

    @Override
    public void set(int index, double value) {
        this.values[index] = value;
    }

    @Override
    public double get(Location loc) {
        Integer index = (Integer)this.locIndexMap.get((Object)loc);
        Preconditions.checkState((index != null ? 1 : 0) != 0, (String)"Location doesn't exist in map: %s", (Object)loc);
        return this.values[index];
    }

    @Override
    public int indexOf(Location loc) {
        return (Integer)this.locIndexMap.get((Object)loc);
    }

    @Override
    public Location getLocation(int index) {
        return (Location)this.points.get(index);
    }

    @Override
    public boolean contains(Location loc) {
        return this.locIndexMap.containsKey((Object)loc);
    }

    public static FixedLocationArbDiscrGeoDataSet loadXYZFile(String fileName, boolean latitudeX) throws FileNotFoundException, IOException {
        ArbDiscrGeoDataSet xyz = ArbDiscrGeoDataSet.loadXYZFile(fileName, latitudeX);
        return new FixedLocationArbDiscrGeoDataSet(xyz);
    }

    public static void writeXYZFile(XYZ_DataSet xyz, String fileName) throws IOException {
        ArbDiscrXYZ_DataSet.writeXYZFile(xyz, fileName);
    }

    public Object clone() {
        return this.copy();
    }

    @Override
    public FixedLocationArbDiscrGeoDataSet copy() {
        double[] valCopy = Arrays.copyOf(this.values, this.values.length);
        return new FixedLocationArbDiscrGeoDataSet(this.points, this.locIndexMap, valCopy, this.isLatitudeX());
    }

    @Override
    public LocationList getLocationList() {
        LocationList locList = new LocationList();
        locList.addAll(this.points);
        return locList;
    }

    @Override
    public int size() {
        return this.points.size();
    }
}

