/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.xyz.AbstractGeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.util.DataUtils;

public class GriddedGeoDataSet
extends AbstractGeoDataSet {
    private static final long serialVersionUID = 1L;
    protected GriddedRegion region;
    private double[] values;

    public GriddedGeoDataSet(GriddedRegion region) {
        this(region, false);
    }

    public GriddedGeoDataSet(GriddedRegion region, boolean latitudeX) {
        this(region, latitudeX, new double[region.getNodeCount()]);
    }

    public GriddedGeoDataSet(GriddedRegion region, boolean latitudeX, double[] values) {
        super(latitudeX);
        this.region = region;
        Preconditions.checkState((values.length == region.getNodeCount() ? 1 : 0) != 0);
        this.values = values;
    }

    private GriddedGeoDataSet(boolean latitudeX) {
        super(latitudeX);
    }

    public double[] getValues() {
        return this.values;
    }

    @Override
    public int size() {
        return this.region.getNodeCount();
    }

    @Override
    public void set(Location loc, double value) {
        int index = this.indexOf(loc);
        if (index < 0) {
            throw new InvalidRangeException("point must exist in the gridded region!");
        }
        this.values[index] = value;
    }

    @Override
    public void set(int index, double z) {
        if (index < 0) {
            throw new InvalidRangeException("point must exist in the gridded region!");
        }
        this.values[index] = z;
    }

    @Override
    public double get(int index) {
        return this.values[index];
    }

    @Override
    public double get(Location loc) {
        return this.values[this.indexOf(loc)];
    }

    @Override
    public int indexOf(Location loc) {
        return this.region.indexForLocation(loc);
    }

    @Override
    public Location getLocation(int index) {
        return this.region.getLocation(index);
    }

    @Override
    public boolean contains(Location loc) {
        return this.indexOf(loc) >= 0;
    }

    public Object clone() {
        return this.copy();
    }

    @Override
    public GriddedGeoDataSet copy() {
        GriddedGeoDataSet data = new GriddedGeoDataSet(this.region, this.isLatitudeX());
        for (int i = 0; i < this.size(); ++i) {
            data.set(this.getLocation(i), this.get(i));
        }
        return data;
    }

    @Override
    public LocationList getLocationList() {
        return this.region.getNodeList();
    }

    public GriddedRegion getRegion() {
        return this.region;
    }

    public double bilinearInterpolation(Location loc) {
        int y0;
        int y1;
        if (!this.region.contains(loc)) {
            return Double.NaN;
        }
        int xInd = this.region.getLonIndex(loc);
        int yInd = this.region.getLatIndex(loc);
        Location closestPoint = this.region.getLocation(this.region.getNodeIndex(yInd, xInd));
        int x0 = closestPoint.getLongitude() <= loc.getLongitude() ? xInd : xInd - 1;
        int x1 = x0 + 1;
        if (x1 >= this.region.getNumLonNodes()) {
            x1 = x0;
        }
        if ((y1 = (y0 = closestPoint.getLatitude() <= loc.getLatitude() ? yInd : yInd - 1) + 1) >= this.region.getNumLatNodes()) {
            y1 = y0;
        }
        int ind00 = this.region.getNodeIndex(y0, x0);
        int ind01 = this.region.getNodeIndex(y0, x1);
        int ind10 = this.region.getNodeIndex(y1, x0);
        int ind11 = this.region.getNodeIndex(y1, x1);
        if (ind00 < 0 || ind01 < 0 || ind10 < 0 || ind11 < 0) {
            return Double.NaN;
        }
        double s00 = this.get(ind00);
        double s01 = this.get(ind01);
        double s10 = this.get(ind10);
        double s11 = this.get(ind11);
        double xfrac = (loc.getLongitude() - this.region.getLocation(this.region.getNodeIndex(yInd, x0)).getLongitude()) / this.region.getLonSpacing();
        double yfrac = (loc.getLatitude() - this.region.getLocation(this.region.getNodeIndex(y0, xInd)).getLatitude()) / this.region.getLatSpacing();
        return (1.0 - yfrac) * ((1.0 - xfrac) * s00 + xfrac * s01) + yfrac * ((1.0 - xfrac) * s10 + xfrac * s11);
    }

    public static GriddedGeoDataSet loadXYZFile(File file, boolean latitudeX) throws FileNotFoundException, IOException {
        int lonCol;
        int latCol;
        if (latitudeX) {
            latCol = 0;
            lonCol = 1;
        } else {
            latCol = 1;
            lonCol = 0;
        }
        return GriddedGeoDataSet.loadXYZFile(file, latCol, lonCol, -1, 2);
    }

    public static GriddedGeoDataSet loadXYZFile(File file, int latCol, int lonCol, int depthCol, int dataCol) throws FileNotFoundException, IOException {
        double lonSpacing;
        double latSpacing;
        Location upperRight;
        Location lowerLeft;
        GriddedRegion reg;
        int i;
        int numLat;
        Location loc3;
        Location prevLoc;
        int numLon;
        ArrayList<Location> locs = new ArrayList<Location>();
        ArrayList<Double> vals = new ArrayList<Double>();
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (String line : Files.readLines((File)file, (Charset)Charset.defaultCharset())) {
            if (line.startsWith("#")) continue;
            double lat = Double.NaN;
            double lon = Double.NaN;
            double depth = 0.0;
            double data = Double.NaN;
            StringTokenizer tok = new StringTokenizer(line);
            for (int index = 0; index <= latCol || index <= lonCol || index <= depthCol || index <= dataCol; ++index) {
                String valStr = tok.nextToken();
                if (index == latCol) {
                    lat = Double.parseDouble(valStr);
                    continue;
                }
                if (index == lonCol) {
                    lon = Double.parseDouble(valStr);
                    continue;
                }
                if (index == depthCol) {
                    depth = Double.parseDouble(valStr);
                    continue;
                }
                if (index != dataCol) continue;
                data = Double.parseDouble(valStr);
            }
            Location loc2 = new Location(lat, lon, depth);
            minLat = Math.min(minLat, lat);
            maxLat = Math.max(maxLat, lat);
            minLon = Math.min(minLon, lon);
            maxLon = Math.max(maxLon, lon);
            locs.add(loc2);
            vals.add(data);
        }
        Preconditions.checkState((locs.size() > 4 ? 1 : 0) != 0);
        Location loc1 = (Location)locs.get(0);
        Location loc2 = (Location)locs.get(1);
        boolean fastLongitude = (float)loc1.getLatitude() == (float)loc2.getLatitude();
        DataUtils.MinMaxAveTracker latSpacingTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonSpacingTrack = new DataUtils.MinMaxAveTracker();
        if (fastLongitude) {
            numLon = 0;
            float prevLat = Float.NaN;
            prevLoc = null;
            for (Location loc3 : locs) {
                float lat = (float)loc3.getLatitude();
                if (Float.isNaN(prevLat)) {
                    prevLat = lat;
                } else if (prevLat != lat) break;
                if (prevLoc != null) {
                    lonSpacingTrack.addValue(Math.abs(loc3.getLongitude() - prevLoc.getLongitude()));
                }
                prevLoc = loc3;
                ++numLon;
            }
            Preconditions.checkState((locs.size() % numLon == 0 ? 1 : 0) != 0, (String)"Couldn't figure out gridding. Fast longitude, numLon=%s, count=%s", (int)numLon, (int)locs.size());
            numLat = locs.size() / numLon;
            prevLoc = (Location)locs.get(0);
            for (i = numLon; i < locs.size(); i += numLon) {
                loc3 = (Location)locs.get(i);
                latSpacingTrack.addValue(Math.abs(loc3.getLatitude() - prevLoc.getLatitude()));
                prevLoc = loc3;
            }
        } else {
            numLat = 0;
            float prevLon = Float.NaN;
            prevLoc = null;
            for (Location loc3 : locs) {
                float lon = (float)loc3.getLongitude();
                if (Float.isNaN(prevLon)) {
                    prevLon = lon;
                } else if (prevLon != lon) break;
                if (prevLoc != null) {
                    latSpacingTrack.addValue(Math.abs(loc3.getLatitude() - prevLoc.getLatitude()));
                }
                prevLoc = loc3;
                ++numLat;
            }
            Preconditions.checkState((locs.size() % numLat == 0 ? 1 : 0) != 0, (String)"Couldn't figure out gridding. Fast latitude, numLat=%s, count=%s", (int)numLat, (int)locs.size());
            numLon = locs.size() / numLat;
            prevLoc = (Location)locs.get(0);
            for (i = numLat; i < locs.size(); i += numLat) {
                loc3 = (Location)locs.get(i);
                lonSpacingTrack.addValue(Math.abs(loc3.getLongitude() - prevLoc.getLongitude()));
                prevLoc = loc3;
            }
        }
        Preconditions.checkState(((reg = new GriddedRegion(lowerLeft = new Location(minLat, minLon), upperRight = new Location(maxLat + 0.1 * (latSpacing = latSpacingTrack.getAverage()), maxLon + 0.1 * (lonSpacing = lonSpacingTrack.getAverage())), latSpacing, lonSpacing, lowerLeft)).getNumLocations() == locs.size() ? 1 : 0) != 0, (String)"Region size doesn't match! Input has %s (%s x %s), reconstruction has %s", (Object)locs.size(), (Object)numLat, (Object)numLon, (Object)reg.getNumLocations());
        GriddedGeoDataSet dataset = new GriddedGeoDataSet(reg, latCol == 0);
        for (int i2 = 0; i2 < locs.size(); ++i2) {
            dataset.set((Location)locs.get(i2), (double)((Double)vals.get(i2)));
        }
        return dataset;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, GMT_MapException {
    }

    public static class FloatData
    extends GriddedGeoDataSet {
        private float[] values;

        public FloatData(GriddedRegion region, boolean latitudeX) {
            super(latitudeX);
            this.region = region;
            this.values = new float[region.getNodeCount()];
        }

        @Override
        public double[] getValues() {
            double[] ret = new double[this.values.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.values[i];
            }
            return ret;
        }

        @Override
        public void set(Location loc, double value) {
            int index = this.indexOf(loc);
            if (index < 0) {
                throw new InvalidRangeException("point must exist in the gridded region!");
            }
            this.values[index] = (float)value;
        }

        @Override
        public void set(int index, double z) {
            if (index < 0) {
                throw new InvalidRangeException("point must exist in the gridded region!");
            }
            this.values[index] = (float)z;
        }

        public void set(Location loc, float value) {
            int index = this.indexOf(loc);
            if (index < 0) {
                throw new InvalidRangeException("point must exist in the gridded region!");
            }
            this.values[index] = value;
        }

        public void set(int index, float z) {
            if (index < 0) {
                throw new InvalidRangeException("point must exist in the gridded region!");
            }
            this.values[index] = z;
        }

        @Override
        public double get(int index) {
            return this.values[index];
        }

        @Override
        public double get(Location loc) {
            return this.values[this.indexOf(loc)];
        }
    }
}

