/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.db;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.eq.cat.MutableCatalog;
import org.opensha.commons.eq.cat.db.STP_Reader;
import org.opensha.commons.eq.cat.db.STP_Request;
import org.opensha.commons.eq.cat.db.STP_Server;

public class STP_Client {
    private STP_Server server;
    private Socket socket;
    private PrintWriter send;
    private BufferedReader receive;
    private boolean debug;

    public STP_Client(STP_Server server, boolean debug) {
        this.server = server;
        this.debug = debug;
    }

    public MutableCatalog getCatalog(STP_Request request) throws IOException, UnknownHostException {
        return this.getCatalog(request.toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutableCatalog getCatalog(String request) throws IOException, UnknownHostException {
        MutableCatalog mutableCatalog;
        DataOutputStream dout;
        block11: {
            dout = null;
            try {
                STP_Reader reader = new STP_Reader(this.server.getMaxEvents());
                this.socket = new Socket(this.server.getAddress(), this.server.getPort());
                this.verboseOut("Socket: " + String.valueOf(this.socket));
                this.socket.setSoTimeout(this.server.getTimeout());
                this.verboseOut("Timeout: " + this.server.getTimeout());
                this.send = new PrintWriter(this.socket.getOutputStream(), true);
                this.verboseOut("Output stream: " + String.valueOf(this.send));
                this.receive = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                this.verboseOut("Input stream: " + String.valueOf(this.receive));
                String pwd = this.server.getPassword();
                this.send.println(this.server.getPassword());
                this.verboseOut("Password >> : " + pwd);
                String response = this.receive.readLine();
                this.verboseOut("  <<" + response);
                if (response == null || !response.equals("CONNECTED")) {
                    throw new IOException("STP connection rejected: " + response);
                }
                dout = new DataOutputStream(this.socket.getOutputStream());
                dout.writeInt(2);
                dout.flush();
                this.verboseOut("Byte order >> : 2");
                do {
                    response = this.receive.readLine();
                    this.verboseOut("  <<" + response);
                } while (response != null && !response.equals("OVER"));
                String maxMessage = "SET NEVNTMAX " + this.server.getMaxEvents();
                this.send.println(maxMessage);
                this.verboseOut("Max events >> : " + maxMessage);
                do {
                    response = this.receive.readLine();
                    this.verboseOut("  <<" + response);
                } while (response != null && !response.equals("OVER"));
                Object requestMod = request;
                requestMod = (String)requestMod + (request.endsWith("\n") ? "" : "\n");
                this.send.flush();
                this.send.println((String)requestMod);
                this.verboseOut("Request >> : " + (String)requestMod);
                response = this.receive.readLine();
                this.verboseOut("  <<" + response);
                response = this.receive.readLine();
                while (!response.startsWith("#")) {
                    this.verboseOut("  <<" + response);
                    if (response.startsWith(" ")) {
                        reader.parseLine(response);
                    }
                    response = this.receive.readLine();
                }
                this.verboseOut("  <<" + response);
                this.verboseOut("====== Done ======");
                mutableCatalog = reader.getCatalog();
                if (this.socket == null) break block11;
            }
            catch (UnknownHostException uhe) {
                try {
                    this.verboseOut("STP error (UH): " + uhe.getMessage());
                    throw uhe;
                    catch (IOException ioe) {
                        this.verboseOut("STP error (IO): " + ioe.getMessage());
                        throw ioe;
                    }
                }
                catch (Throwable throwable) {
                    if (this.socket != null) {
                        this.socket.close();
                        this.socket = null;
                    }
                    IOUtils.closeQuietly((Writer)this.send);
                    IOUtils.closeQuietly((Reader)this.receive);
                    IOUtils.closeQuietly(dout);
                    this.send = null;
                    this.receive = null;
                    throw throwable;
                }
            }
            this.socket.close();
            this.socket = null;
        }
        IOUtils.closeQuietly((Writer)this.send);
        IOUtils.closeQuietly((Reader)this.receive);
        IOUtils.closeQuietly((OutputStream)dout);
        this.send = null;
        this.receive = null;
        return mutableCatalog;
    }

    public void cancelRequest() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void verboseOut(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }
}

