/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.db;

import java.util.Calendar;
import java.util.TimeZone;
import org.opensha.commons.eq.cat.CatTools;
import org.opensha.commons.eq.cat.util.EventType;
import org.opensha.commons.geo.GeoTools;

public class STP_Request {
    public static final String RECENT_EQ_WEEK = "event -t0 -7d +7d -type le";
    private Long dateMax;
    private Long dateMin;
    private Double latitudeMin;
    private Double latitudeMax;
    private Double longitudeMin;
    private Double longitudeMax;
    private Double depthMin;
    private Double depthMax;
    private Double magnitudeMin;
    private Double magnitudeMax;
    private EventType eventType;
    private static String exampleReq = "event -t0 2002/09/01 2002/09/30 -mag 3.5 7.0 -type le";

    public static void main(String[] args) {
        STP_Request req = new STP_Request();
        req.setDateMin(1237880234L);
        req.setMagnitudeMax(6.0);
        req.setLatitudeMin(23.0);
        req.setLatitudeMax(30.0);
        req.setEventType(EventType.NUCLEAR);
        req.setDepthMax(10.0);
        req.setLongitudeMin(-120.0);
        System.out.println(req.toString());
    }

    public String toString() {
        return "event " + this.getDateParams() + this.getLongitudeParams() + this.getLatitudeParams() + this.getDepthParams() + this.getMagnitudeParams() + this.getTypeParam() + "\n";
    }

    private String getDateParams() {
        if (this.dateMax == null && this.dateMin == null) {
            return "";
        }
        String min = this.dateMin != null ? String.valueOf(this.dateMin / 1000L) : "0";
        String max = this.dateMax != null ? String.valueOf(this.dateMax / 1000L) : String.valueOf(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis());
        return "-t0 " + min + "u " + max + "u ";
    }

    private String getLongitudeParams() {
        if (this.longitudeMax == null && this.longitudeMin == null) {
            return "";
        }
        String min = this.longitudeMin != null ? this.longitudeMin.toString() : String.valueOf(-180.0);
        String max = this.longitudeMax != null ? this.longitudeMax.toString() : String.valueOf(360.0);
        return "-lon " + min + " " + max + " ";
    }

    private String getLatitudeParams() {
        if (this.latitudeMax == null && this.latitudeMin == null) {
            return "";
        }
        String min = this.latitudeMin != null ? this.latitudeMin.toString() : String.valueOf(-90.0);
        String max = this.latitudeMax != null ? this.latitudeMax.toString() : String.valueOf(90.0);
        return "-lat " + min + " " + max + " ";
    }

    private String getDepthParams() {
        if (this.depthMax == null && this.depthMin == null) {
            return "";
        }
        String min = this.depthMin != null ? this.depthMin.toString() : String.valueOf(-5.0);
        String max = this.depthMax != null ? this.depthMax.toString() : String.valueOf(700.0);
        return "-depth " + min + " " + max + " ";
    }

    private String getMagnitudeParams() {
        if (this.magnitudeMax == null && this.magnitudeMin == null) {
            return "";
        }
        String min = this.magnitudeMin != null ? this.magnitudeMin.toString() : String.valueOf(-2.0);
        String max = this.magnitudeMax != null ? this.magnitudeMax.toString() : String.valueOf(10.0);
        return "-mag " + min + " " + max + " ";
    }

    private String getTypeParam() {
        if (this.eventType == null) {
            return "";
        }
        return "-type " + this.eventType.id() + " ";
    }

    public long getDateMax() {
        return this.dateMax;
    }

    public void setDateMax(Long dateMax) {
        if (dateMax != null && this.dateMin != null && dateMax < this.dateMin) {
            throw new IllegalArgumentException("STP request: Max < Min");
        }
        this.dateMax = dateMax;
    }

    public long getDateMin() {
        return this.dateMin;
    }

    public void setDateMin(Long dateMin) {
        if (dateMin != null && this.dateMax != null && dateMin > this.dateMax) {
            throw new IllegalArgumentException("STP request: Min > Max");
        }
        this.dateMin = dateMin;
    }

    public double getDepthMax() {
        return this.depthMax;
    }

    public void setDepthMax(Double depthMax) {
        if (depthMax != null) {
            GeoTools.validateDepth(depthMax);
            if (this.depthMin != null && depthMax < this.depthMin) {
                throw new IllegalArgumentException("STP request: Max < Min");
            }
        }
        this.depthMax = depthMax;
    }

    public double getDepthMin() {
        return this.depthMin;
    }

    public void setDepthMin(Double depthMin) {
        if (depthMin != null) {
            GeoTools.validateDepth(depthMin);
            if (this.depthMax != null && depthMin > this.depthMax) {
                throw new IllegalArgumentException("STP request: Min > Max");
            }
        }
        this.depthMin = depthMin;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public double getLatitudeMax() {
        return this.latitudeMax;
    }

    public void setLatitudeMax(Double latitudeMax) {
        if (latitudeMax != null) {
            GeoTools.validateLat(latitudeMax);
            if (this.latitudeMin != null && latitudeMax < this.latitudeMin) {
                throw new IllegalArgumentException("STP request: Max < Min");
            }
        }
        this.latitudeMax = latitudeMax;
    }

    public double getLatitudeMin() {
        return this.latitudeMin;
    }

    public void setLatitudeMin(Double latitudeMin) {
        if (latitudeMin != null) {
            GeoTools.validateLat(latitudeMin);
            if (this.latitudeMax != null && latitudeMin > this.latitudeMax) {
                throw new IllegalArgumentException("STP request: Min > Max");
            }
        }
        this.latitudeMin = latitudeMin;
    }

    public double getLongitudeMax() {
        return this.longitudeMax;
    }

    public void setLongitudeMax(Double longitudeMax) {
        if (longitudeMax != null) {
            GeoTools.validateLon(longitudeMax);
            if (this.longitudeMin != null && longitudeMax < this.longitudeMin) {
                throw new IllegalArgumentException("STP request: Max < Min");
            }
        }
        this.longitudeMax = longitudeMax;
    }

    public double getLongitudeMin() {
        return this.longitudeMin;
    }

    public void setLongitudeMin(Double longitudeMin) {
        if (longitudeMin != null) {
            GeoTools.validateLon(longitudeMin);
            if (this.longitudeMax != null && longitudeMin > this.longitudeMax) {
                throw new IllegalArgumentException("STP request: Min > Max");
            }
        }
        this.longitudeMin = longitudeMin;
    }

    public Double getMagnitudeMax() {
        return this.magnitudeMax;
    }

    public void setMagnitudeMax(Double magnitudeMax) {
        if (magnitudeMax != null) {
            CatTools.validateMag(magnitudeMax);
            if (this.magnitudeMin != null && magnitudeMax < this.magnitudeMin) {
                throw new IllegalArgumentException("STP request: Max < Min");
            }
        }
        this.magnitudeMax = magnitudeMax;
    }

    public Double getMagnitudeMin() {
        return this.magnitudeMin;
    }

    public void setMagnitudeMin(Double magnitudeMin) {
        if (magnitudeMin != null) {
            CatTools.validateMag(magnitudeMin);
            if (this.magnitudeMax != null && magnitudeMin > this.magnitudeMax) {
                throw new IllegalArgumentException("STP request: Min > Max");
            }
        }
        this.magnitudeMin = magnitudeMin;
    }
}

