/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.filters;

import org.opensha.commons.eq.cat.MutableCatalog;
import org.opensha.commons.eq.cat.filters.CatalogFilter;
import org.opensha.commons.eq.cat.util.DataType;

public class ExtentsFilter
implements CatalogFilter {
    private Double min_lat = null;
    private Double max_lat = null;
    private Double min_lon = null;
    private Double max_lon = null;
    private Double min_dep = null;
    private Double max_dep = null;
    private Double min_mag = null;
    private Double max_mag = null;
    private Long min_dat = null;
    private Long max_dat = null;
    private int[] indexArray;

    public ExtentsFilter setLatitudes(double min, double max) {
        this.min_lat = min;
        this.max_lat = max;
        return this;
    }

    public ExtentsFilter setLongitudes(double min, double max) {
        this.min_lon = min;
        this.max_lon = max;
        return this;
    }

    public ExtentsFilter setDepths(double min, double max) {
        this.min_dep = min;
        this.max_dep = max;
        return this;
    }

    public ExtentsFilter setMagnitudes(double min, double max) {
        this.min_mag = min;
        this.max_mag = max;
        return this;
    }

    public ExtentsFilter setDates(long min, long max) {
        this.min_dat = min;
        this.max_dat = max;
        return this;
    }

    @Override
    public int[] process(MutableCatalog catalog) {
        int indexArraySize;
        int i;
        long[] eq_time = (long[])catalog.getData(DataType.TIME);
        int min_dat_idx = 0;
        if (this.min_dat != null) {
            min_dat_idx = catalog.size();
            long minimum_time = this.min_dat;
            for (i = 0; i < catalog.size(); ++i) {
                if (minimum_time > eq_time[i]) continue;
                min_dat_idx = i;
                break;
            }
        }
        int max_dat_idx = catalog.size();
        if (this.max_dat != null) {
            max_dat_idx = 0;
            long maximum_time = this.max_dat;
            for (int i2 = catalog.size() - 1; i2 >= 0; --i2) {
                if (maximum_time < eq_time[i2]) continue;
                max_dat_idx = i2 + 1;
                break;
            }
        }
        if ((indexArraySize = max_dat_idx - min_dat_idx) <= 0) {
            return null;
        }
        this.indexArray = new int[indexArraySize];
        for (i = 0; i < this.indexArray.length; ++i) {
            this.indexArray[i] = min_dat_idx + i;
        }
        double[] eq_latitude = (double[])catalog.getData(DataType.LATITUDE);
        if (!this.processParams(this.min_lat, this.max_lat, eq_latitude, this.indexArray)) {
            return null;
        }
        double[] eq_longitude = (double[])catalog.getData(DataType.LONGITUDE);
        if (!this.processParams(this.min_lon, this.max_lon, eq_longitude, this.indexArray)) {
            return null;
        }
        double[] eq_depth = (double[])catalog.getData(DataType.DEPTH);
        if (!this.processParams(this.min_dep, this.max_dep, eq_depth, this.indexArray)) {
            return null;
        }
        double[] eq_magnitude = (double[])catalog.getData(DataType.MAGNITUDE);
        if (!this.processParams(this.min_mag, this.max_mag, eq_magnitude, this.indexArray)) {
            return null;
        }
        return this.indexArray;
    }

    private boolean processParams(Double minParam, Double maxParam, double[] data, int[] eventIndices) {
        int count = 0;
        if (minParam != null) {
            double minVal = minParam;
            for (int i = 0; i < eventIndices.length; ++i) {
                int eventID = eventIndices[i];
                if (data[eventID] < minVal) continue;
                eventIndices[count] = eventID;
                ++count;
            }
            if (count == 0) {
                return false;
            }
        }
        if (maxParam != null) {
            double maxVal = maxParam;
            int numevents = count == 0 ? eventIndices.length : count;
            count = 0;
            for (int i = 0; i < numevents; ++i) {
                int eventID = eventIndices[i];
                if (data[eventID] > maxVal) continue;
                eventIndices[count] = eventID;
                ++count;
            }
            if (count == 0) {
                return false;
            }
        }
        if (minParam != null || maxParam != null) {
            int[] newEventIndices = new int[count];
            System.arraycopy(eventIndices, 0, newEventIndices, 0, count);
            this.indexArray = newEventIndices;
        }
        return true;
    }
}

