/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.util;

import java.util.HashMap;
import java.util.Map;

public enum EventType {
    UNKNOWN(0, "uk"),
    LOCAL(10, "le"),
    REGIONAL(20, "re"),
    TELESEISM(30, "ts"),
    QUARRY(40, "qb"),
    SONIC(50, "sn"),
    NUCLEAR(60, "nt");

    private static Map<Integer, EventType> idMap;
    private static Map<String, EventType> abbrMap;
    private int id;
    private String abbr;

    private EventType(int id, String abbr) {
        this.id = id;
        this.abbr = abbr;
    }

    public EventType typeForID(int id) {
        return idMap.get(id);
    }

    public int id() {
        return this.id;
    }

    public String abbr() {
        return this.abbr;
    }

    public static EventType parse(String s) {
        try {
            EventType type = abbrMap.get(s.trim().toLowerCase());
            return type == null ? UNKNOWN : type;
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    static {
        idMap = new HashMap<Integer, EventType>();
        abbrMap = new HashMap<String, EventType>();
        for (EventType et : EventType.values()) {
            idMap.put(et.id(), et);
            abbrMap.put(et.abbr(), et);
        }
    }
}

