/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.util;

import java.util.HashMap;
import java.util.Map;

public enum MagnitudeType {
    NONE(0),
    LOCAL(10),
    SURFACE(20),
    MOMENT(30),
    ENERGY(40),
    BODY(50),
    CODA_AMPLITUDE(60),
    CODA_DURATION(70),
    HELICORDER(80),
    MAX_AMPLITUDE(90),
    AVERAGE_MD_MX(100),
    LG_PHASE(110);

    private static Map<Integer, MagnitudeType> idMap;
    private int id;

    private MagnitudeType(int id) {
        this.id = id;
    }

    public MagnitudeType typeForID(int id) {
        return idMap.get(id);
    }

    public int id() {
        return this.id;
    }

    public static MagnitudeType parseNCEDC(String s) {
        if (s.equals("Md")) {
            return CODA_DURATION;
        }
        if (s.equals("Mx")) {
            return MAX_AMPLITUDE;
        }
        if (s.startsWith("ML")) {
            return LOCAL;
        }
        if (s.equals("Mw")) {
            return MOMENT;
        }
        if (s.equals("Mavg")) {
            return AVERAGE_MD_MX;
        }
        if (s.equals("Ms")) {
            return SURFACE;
        }
        if (s.equals("Mb")) {
            return BODY;
        }
        if (s.equals("Me")) {
            return ENERGY;
        }
        if (s.equals("Mc")) {
            return CODA_AMPLITUDE;
        }
        if (s.equals("Mlg")) {
            return LG_PHASE;
        }
        return NONE;
    }

    public static MagnitudeType parseSCEDC(String s) {
        if (s.equals("l")) {
            return LOCAL;
        }
        if (s.equals("h")) {
            return HELICORDER;
        }
        if (s.equals("s")) {
            return SURFACE;
        }
        if (s.equals("b")) {
            return BODY;
        }
        if (s.equals("w")) {
            return MOMENT;
        }
        if (s.equals("e")) {
            return ENERGY;
        }
        if (s.equals("c")) {
            return CODA_AMPLITUDE;
        }
        if (s.equals("d")) {
            return CODA_DURATION;
        }
        return NONE;
    }

    static {
        idMap = new HashMap<Integer, MagnitudeType>();
        for (MagnitudeType mt : MagnitudeType.values()) {
            idMap.put(mt.id(), mt);
        }
    }
}

