/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo;

import org.opensha.commons.geo.GeoTools;

public class LocationVector {
    private double azimuth;
    private double vertical;
    private double horizontal;

    public LocationVector() {
    }

    public LocationVector(double azimuth, double horizontal, double vertical) {
        this.set(azimuth, horizontal, vertical);
    }

    public void set(double azimuth, double horizontal, double vertical) {
        this.azimuth = azimuth;
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    public void reverse() {
        this.azimuth = (this.azimuth + 180.0) % 360.0;
        this.vertical = -this.vertical;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getAzimuthRad() {
        return this.azimuth * GeoTools.TO_RAD;
    }

    public void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public double getPlunge() {
        return Math.atan(this.vertical / this.horizontal) * GeoTools.TO_DEG;
    }

    public double getVertDistance() {
        return this.vertical;
    }

    public void setVertDistance(double vertical) {
        this.vertical = vertical;
    }

    public double getHorzDistance() {
        return this.horizontal;
    }

    public void setHorzDistance(double horizontal) {
        this.horizontal = horizontal;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getClass().getSimpleName());
        b.append(":  az = ");
        b.append(this.getAzimuth());
        b.append("  dH = ");
        b.append(this.horizontal);
        b.append("  dV = ");
        b.append(this.vertical);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocationVector) {
            LocationVector dir = (LocationVector)obj;
            if (this.horizontal != dir.horizontal) {
                return false;
            }
            if (this.vertical != dir.vertical) {
                return false;
            }
            return this.azimuth == dir.azimuth;
        }
        return false;
    }
}

