/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.geo.json.AbstractGeoJSON_TypeAdapter;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.GeoJSON_Type;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.util.ExceptionUtils;

@JsonAdapter(value=FeatureCollectionAdapter.class)
public class FeatureCollection
implements Iterable<Feature> {
    public final GeoJSON_Type type = GeoJSON_Type.FeatureCollection;
    public final ImmutableList<Feature> features;
    static final Gson gson_default = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    static final Gson gson_compact = new GsonBuilder().serializeNulls().create();

    public FeatureCollection(Feature ... features) {
        this(List.of(features));
    }

    public FeatureCollection(List<Feature> features) {
        this.features = features == null ? null : ImmutableList.copyOf(features);
    }

    public String toJSON() {
        StringWriter writer = new StringWriter();
        try {
            FeatureCollection.write(this, writer);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        return writer.toString();
    }

    public String toCompactJSON() {
        StringWriter writer = new StringWriter();
        try {
            FeatureCollection.writeCompact(this, writer);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        return writer.toString();
    }

    public static FeatureCollection fromJSON(String json) throws IOException {
        StringReader reader = new StringReader(json);
        return FeatureCollection.read(reader);
    }

    public static FeatureCollection read(File jsonFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return FeatureCollection.read(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatureCollection read(Reader reader) throws IOException {
        FeatureCollection ret;
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        Gson gson = gson_default;
        synchronized (gson) {
            ret = (FeatureCollection)gson_default.fromJson(reader, FeatureCollection.class);
            reader.close();
        }
        return ret;
    }

    public static void write(FeatureCollection features, File jsonFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));
        FeatureCollection.write(features, writer);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(FeatureCollection features, Writer writer) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        Gson gson = gson_default;
        synchronized (gson) {
            gson_default.toJson((Object)features, FeatureCollection.class, (Appendable)writer);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompact(FeatureCollection features, Writer writer) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        Gson gson = gson_compact;
        synchronized (gson) {
            gson_compact.toJson((Object)features, FeatureCollection.class, (Appendable)writer);
            writer.flush();
        }
    }

    public static Gson buildGson() {
        return FeatureCollection.buildGson(Geometry.DEPTH_SERIALIZATION_DEFAULT);
    }

    public static Gson buildGson(Geometry.DepthSerializationType depthType) {
        return FeatureCollection.buildGson(depthType, null);
    }

    public static Gson buildGson(Geometry.DepthSerializationType depthType, TypeAdapter<FeatureProperties> propsAdapter) {
        if (propsAdapter == null) {
            propsAdapter = new FeatureProperties.PropertiesAdapter();
        }
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        Geometry.GeometryAdapter geomAdapter = new Geometry.GeometryAdapter(depthType);
        Feature.FeatureAdapter featureAdapter = new Feature.FeatureAdapter(propsAdapter, geomAdapter);
        builder.registerTypeAdapter(FeatureCollection.class, (Object)new FeatureCollectionAdapter(featureAdapter));
        builder.registerTypeAdapter(Feature.class, (Object)featureAdapter);
        builder.registerTypeAdapter(FeatureProperties.class, (Object)propsAdapter);
        builder.registerTypeAdapter(Geometry.class, (Object)geomAdapter);
        return builder.create();
    }

    @Override
    public Iterator<Feature> iterator() {
        return this.features.iterator();
    }

    public static class FeatureCollectionAdapter
    extends AbstractGeoJSON_TypeAdapter<FeatureCollection> {
        private Feature.FeatureAdapter featureAdapter = new Feature.FeatureAdapter();

        public FeatureCollectionAdapter() {
            this.featureAdapter = new Feature.FeatureAdapter();
        }

        public FeatureCollectionAdapter(Feature.FeatureAdapter featureAdapter) {
            this.featureAdapter = featureAdapter;
        }

        public void write(JsonWriter out, FeatureCollection value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.type.name());
            out.name("features");
            if (value.features == null) {
                out.nullValue();
            } else {
                out.beginArray();
                for (Feature feature : value.features) {
                    this.featureAdapter.write(out, feature);
                }
                out.endArray();
            }
            out.endObject();
        }

        public FeatureCollection read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            FeatureCollection features = this.innerReadAsType(in, null);
            in.endObject();
            return features;
        }

        @Override
        public FeatureCollection innerReadAsType(JsonReader in, GeoJSON_Type type) throws IOException {
            ArrayList<Feature> features = null;
            block8: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "type": {
                        type = GeoJSON_Type.valueOf(in.nextString());
                        Preconditions.checkState((type == GeoJSON_Type.FeatureCollection ? 1 : 0) != 0, (String)"Expected FeatureCollection type, have %s", (Object)((Object)type));
                        continue block8;
                    }
                    case "features": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            continue block8;
                        }
                        features = new ArrayList<Feature>();
                        in.beginArray();
                        while (in.hasNext()) {
                            features.add(this.featureAdapter.read(in));
                        }
                        in.endArray();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            Preconditions.checkState((type == GeoJSON_Type.FeatureCollection ? 1 : 0) != 0, (String)"Expected FeatureCollection type, have %s", (Object)((Object)type));
            return new FeatureCollection(features);
        }
    }
}

