/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo.json;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.GeoJSON_Type;
import org.opensha.commons.geo.json.Geometry;

@JsonAdapter(value=PropertiesAdapter.class)
public class FeatureProperties
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final String STROKE_COLOR_PROP = "stroke";
    public static final String STROKE_WIDTH_PROP = "stroke-width";
    public static final String STROKE_OPACITY_PROP = "stroke-opacity";
    public static final String FILL_COLOR_PROP = "fill";
    public static final String FILL_OPACITY_PROP = "fill-opacity";
    public static final String MARKER_COLOR_PROP = "marker-color";
    public static final String MARKER_SIZE_PROP = "marker-size";
    public static final String MARKER_SIZE_SMALL = "small";
    public static final String MARKER_SIZE_MEDIUM = "medium";
    public static final String MARKER_SIZE_LARGE = "large";
    private static XY_DataSet.XYAdapter xyAdapter = new XY_DataSet.XYAdapter();
    private static PropertiesAdapter propAdapter = new PropertiesAdapter();
    private static Geometry.GeometryAdapter geomAdapter = new Geometry.GeometryAdapter();
    private static Feature.FeatureAdapter featureAdapter = new Feature.FeatureAdapter();
    private static FeatureCollection.FeatureCollectionAdapter featureCollectionAdapter = new FeatureCollection.FeatureCollectionAdapter();

    public FeatureProperties() {
    }

    public FeatureProperties(Map<String, Object> other) {
        super(other);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            String str = (String)val;
            return (str = str.trim().toLowerCase()).equals("true") || str.equals("yes");
        }
        System.err.println("Feature property with name '" + name + "' is of an unexpected type: " + val.getClass().getName());
        return defaultValue;
    }

    public double getDouble(String name, double defaultValue) {
        return this.getNumber(name, defaultValue).doubleValue();
    }

    public int getInt(String name, int defaultValue) {
        return this.getNumber(name, defaultValue).intValue();
    }

    public long getLong(String name, long defaultValue) {
        return this.getNumber(name, defaultValue).longValue();
    }

    public Number getNumber(String name) {
        return this.getNumber(name, null);
    }

    public Number getNumber(String name, Number defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        return FeatureProperties.asNumber(val, name, defaultValue);
    }

    private static Number asNumber(Object val, String name, Number defaultValue) {
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof String) {
            try {
                String str = (String)val;
                if (str.equalsIgnoreCase("NaN")) {
                    return Double.NaN;
                }
                if (str.equalsIgnoreCase("Infinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (str.equalsIgnoreCase("-Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (str.contains(".") || str.toLowerCase().contains("e")) {
                    return Double.parseDouble(str);
                }
                return Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                System.err.println("Feature property with name '" + name + "' is of a string that could not be parsed to a number: " + e.getMessage());
                return defaultValue;
            }
        }
        try {
            return (Number)val;
        }
        catch (ClassCastException e) {
            System.err.println("Feature property with name '" + name + "' is of an unexpected type: " + e.getMessage());
            return defaultValue;
        }
    }

    public double[] getDoubleArray(String name) {
        Number[] numbers = this.getNumberArray(name);
        if (numbers == null) {
            return null;
        }
        double[] ret = new double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            ret[i] = numbers[i].doubleValue();
        }
        return ret;
    }

    public int[] getIntArray(String name) {
        Number[] numbers = this.getNumberArray(name);
        if (numbers == null) {
            return null;
        }
        int[] ret = new int[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            ret[i] = numbers[i].intValue();
        }
        return ret;
    }

    public long[] getLongArray(String name) {
        Number[] numbers = this.getNumberArray(name);
        if (numbers == null) {
            return null;
        }
        long[] ret = new long[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            ret[i] = numbers[i].longValue();
        }
        return ret;
    }

    public Number[] getNumberArray(String name) {
        ArrayList<Number> numbers;
        block6: {
            Object val;
            block5: {
                val = this.get(name);
                if (val == null) {
                    return null;
                }
                numbers = new ArrayList<Number>();
                if (!(val instanceof List)) break block5;
                for (Object subVal : (List)val) {
                    Number number = FeatureProperties.asNumber(subVal, name, null);
                    if (number == null) {
                        return null;
                    }
                    numbers.add(number);
                }
                break block6;
            }
            if (!val.getClass().isArray()) break block6;
            for (Object subVal : (Object[])val) {
                Number number = FeatureProperties.asNumber(subVal, name, null);
                if (number == null) {
                    return null;
                }
                numbers.add(number);
            }
        }
        return numbers.toArray(new Number[0]);
    }

    public Location getLocation(String name) {
        return this.getLocation(name, null);
    }

    public Location getLocation(String name, Location defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Location) {
            return (Location)val;
        }
        double[] array = this.getDoubleArray(name);
        if (array == null || array.length < 2 || array.length > 3) {
            return null;
        }
        double lon = array[0];
        double lat = array[1];
        double depth = array.length == 3 ? Geometry.DEPTH_SERIALIZATION_DEFAULT.fromGeoJSON(array[2]) : 0.0;
        return new Location(lat, lon, depth);
    }

    public FeatureProperties getProperties(String name) {
        return this.getProperties(name, null);
    }

    public FeatureProperties getProperties(String name, FeatureProperties defaultValue) {
        Object val = this.get(name);
        FeatureProperties props = this.getAsFeatureProps(val);
        if (props == null) {
            return defaultValue;
        }
        return props;
    }

    private FeatureProperties getAsFeatureProps(Object val) {
        Map map;
        if (val == null) {
            return null;
        }
        if (val instanceof FeatureProperties) {
            return (FeatureProperties)val;
        }
        if (val instanceof Map && ((map = (Map)val).isEmpty() || map.keySet().iterator().next() instanceof String)) {
            try {
                return new FeatureProperties(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public List<FeatureProperties> getPropertiesList(String name) {
        return this.getPropertiesList(name, null);
    }

    public List<FeatureProperties> getPropertiesList(String name, List<FeatureProperties> defaultValue) {
        Object val = this.get(name);
        if (val == null || !(val instanceof Collection)) {
            return defaultValue;
        }
        Collection inputList = (Collection)val;
        ArrayList<FeatureProperties> ret = new ArrayList<FeatureProperties>();
        for (Object obj : inputList) {
            if (obj == null) {
                ret.add(null);
                continue;
            }
            FeatureProperties props = this.getAsFeatureProps(obj);
            if (props == null) {
                return defaultValue;
            }
            ret.add(props);
        }
        return ret;
    }

    public Color getColor(String name) {
        return this.getColor(name, null);
    }

    public Color getColor(String name, Color defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Color) {
            return (Color)val;
        }
        String str = val.toString();
        try {
            return Color.decode(str);
        }
        catch (NumberFormatException e) {
            System.err.println("Feature property with name '" + name + "' and value '" + str + "' could not be parsed as a color, returning default: " + e.getMessage());
            return defaultValue;
        }
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        Object val = this.get(name);
        if (val == null || !(val instanceof String)) {
            return defaultValue;
        }
        return (String)val;
    }

    public <E> E get(String name, E defaultValue) {
        Object val = this.get(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return (E)val;
        }
        catch (ClassCastException e) {
            System.err.println("Feature property with name '" + name + "' is of an unexpected type: " + e.getMessage());
            return defaultValue;
        }
    }

    public <E> E getAsType(String name, TypeToken<E> type) {
        Object val = this.get(name);
        if (val == null) {
            return null;
        }
        try {
            return (E)val;
        }
        catch (ClassCastException e) {
            System.err.println("Feature property with name '" + name + "' is of an unexpected type: " + e.getMessage());
            return null;
        }
    }

    public <E> E getAsType(String name, Class<E> type) {
        Object val = this.get(name);
        if (val == null) {
            return null;
        }
        try {
            return (E)val;
        }
        catch (ClassCastException e) {
            System.err.println("Feature property with name '" + name + "' is of an unexpected type: " + e.getMessage());
            return null;
        }
    }

    public <E> E require(String name, Class<E> type) {
        Object val = this.get(name);
        Preconditions.checkNotNull(val, (String)"No value present named '%s'", (Object)name);
        return type.cast(val);
    }

    public void set(String name, Object value) {
        if (value == null) {
            this.remove(name);
        } else {
            super.put(name, value);
        }
    }

    public void setConditional(String name, Object value, boolean condition) {
        if (condition) {
            this.set(name, value);
        } else {
            this.remove(name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void propSerializeDefault(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        } else if (value instanceof Number) {
            out.value((Number)value);
            return;
        } else if (value instanceof Boolean) {
            out.value((Boolean)value);
            return;
        } else if (value instanceof Location) {
            Geometry.serializeLoc(out, (Location)value, Geometry.DEPTH_SERIALIZATION_DEFAULT, false);
            return;
        } else if (value instanceof Color) {
            out.value("#" + Integer.toHexString(((Color)value).getRGB()).substring(2));
            return;
        } else if (value instanceof XY_DataSet) {
            xyAdapter.write(out, (XY_DataSet)value);
            return;
        } else if (value instanceof Geometry) {
            geomAdapter.write(out, (Geometry)value);
            return;
        } else if (value instanceof Feature) {
            featureAdapter.write(out, (Feature)value);
            return;
        } else if (value instanceof FeatureCollection) {
            featureCollectionAdapter.write(out, (FeatureCollection)value);
            return;
        } else if (value.getClass().isArray()) {
            Object[] array;
            if (value.getClass().getComponentType().isPrimitive()) {
                if (value instanceof double[]) {
                    array = ArrayUtils.toObject((double[])((double[])value));
                } else if (value instanceof double[]) {
                    array = ArrayUtils.toObject((double[])((double[])value));
                } else if (value instanceof float[]) {
                    array = ArrayUtils.toObject((float[])((float[])value));
                } else if (value instanceof int[]) {
                    array = ArrayUtils.toObject((int[])((int[])value));
                } else if (value instanceof long[]) {
                    array = ArrayUtils.toObject((long[])((long[])value));
                } else if (value instanceof short[]) {
                    array = ArrayUtils.toObject((short[])((short[])value));
                } else if (value instanceof byte[]) {
                    array = ArrayUtils.toObject((byte[])((byte[])value));
                } else {
                    if (!(value instanceof boolean[])) throw new IllegalStateException();
                    array = ArrayUtils.toObject((boolean[])((boolean[])value));
                }
            } else {
                array = (Object[])value;
            }
            out.beginArray();
            for (Object subValue : array) {
                FeatureProperties.propSerializeDefault(out, subValue);
            }
            out.endArray();
            return;
        } else if (value instanceof Collection) {
            out.beginArray();
            for (Object subValue : (Collection)value) {
                FeatureProperties.propSerializeDefault(out, subValue);
            }
            out.endArray();
            return;
        } else if (value instanceof FeatureProperties) {
            propAdapter.write(out, (FeatureProperties)value);
            return;
        } else if (value instanceof Map) {
            out.beginObject();
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                out.name(key.toString());
                FeatureProperties.propSerializeDefault(out, map.get(key));
            }
            out.endObject();
            return;
        } else {
            out.value(value.toString());
        }
    }

    public static Object propDeserializeDefault(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (token == JsonToken.BOOLEAN) {
            return in.nextBoolean();
        }
        if (token == JsonToken.NUMBER) {
            return FeatureProperties.parseNumber(in.nextString());
        }
        if (token == JsonToken.STRING) {
            return in.nextString();
        }
        if (token == JsonToken.BEGIN_ARRAY) {
            ArrayList<Object> values = new ArrayList<Object>();
            in.beginArray();
            while (in.hasNext()) {
                values.add(FeatureProperties.propDeserializeDefault(in));
            }
            in.endArray();
            return values;
        }
        if (token == JsonToken.BEGIN_OBJECT) {
            String startPath;
            block27: {
                startPath = in.getPath();
                in.beginObject();
                if (in.hasNext()) {
                    String name0 = in.nextName();
                    if (name0.equals("type") && in.peek() == JsonToken.STRING) {
                        String type = null;
                        try {
                            type = in.nextString();
                            GeoJSON_Type geoType = null;
                            try {
                                geoType = GeoJSON_Type.valueOf(type);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (geoType != null) {
                                if (GeoJSON_Type.GEOM_TYPES.contains((Object)geoType)) {
                                    Geometry ret = geomAdapter.innerReadAsType(in, geoType);
                                    in.endObject();
                                    return ret;
                                }
                                if (geoType == GeoJSON_Type.Feature) {
                                    Feature ret = featureAdapter.innerReadAsType(in, geoType);
                                    in.endObject();
                                    return ret;
                                }
                                if (geoType == GeoJSON_Type.FeatureCollection) {
                                    FeatureCollection ret = featureCollectionAdapter.innerReadAsType(in, geoType);
                                    in.endObject();
                                    return ret;
                                }
                                System.err.println("WARNING: couldn't deserialize custom FeatureProperties object with type: " + type);
                                break block27;
                            }
                            try {
                                Class<?> typeClass = Class.forName(type);
                                if (XY_DataSet.class.isAssignableFrom(typeClass)) {
                                    Object ret = new XY_DataSet.XYAdapter().innerReadAsType(in, typeClass);
                                    in.endObject();
                                    return ret;
                                }
                            }
                            catch (Throwable typeClass) {
                                // empty catch block
                            }
                            try {
                                FeatureProperties props = propAdapter.readAfterFirstNameAndValue(in, name0, type);
                                if (props != null) {
                                    return props;
                                }
                            }
                            catch (Throwable t) {
                                System.err.println("WARNING: couldn't deserialize custom FeatureProperties object as a map: " + t.getMessage());
                            }
                        }
                        catch (Throwable t) {
                            System.err.println("WARNING: couldn't deserialize custom FeatureProperties object with type: " + type + ", exception: " + t.getMessage());
                        }
                    } else {
                        try {
                            FeatureProperties props = propAdapter.readAfterFirstName(in, name0);
                            if (props != null) {
                                return props;
                            }
                        }
                        catch (Throwable t) {
                            System.err.println("WARNING: couldn't deserialize custom FeatureProperties object as a map: " + t.getMessage());
                        }
                    }
                }
            }
            FeatureProperties.skipUntilPastObject(in, startPath);
            return null;
        }
        in.skipValue();
        return null;
    }

    private static void skipUntilPastObject(JsonReader in, String startPath) throws IOException {
        boolean D = false;
        while (true) {
            String path = in.getPath();
            JsonToken peek = in.peek();
            if (FeatureProperties.isSamePath(path, startPath)) {
                if (peek != JsonToken.BEGIN_OBJECT || !path.equals(startPath)) break;
                in.skipValue();
                break;
            }
            if (peek == JsonToken.END_DOCUMENT) {
                in.close();
                throw new IllegalStateException("Failed to skipUnilEndObject to " + startPath + ", encountered END_DOCUMENT");
            }
            if (peek == JsonToken.END_ARRAY) {
                in.endArray();
                continue;
            }
            if (peek == JsonToken.END_OBJECT) {
                in.endObject();
                continue;
            }
            in.skipValue();
        }
    }

    private static boolean isSamePath(String testPath, String destPath) {
        if (testPath.equals(destPath)) {
            return true;
        }
        if (testPath.endsWith("]") && destPath.endsWith("]")) {
            String testPrefix;
            String destPrefix;
            int destArrayBegin = destPath.lastIndexOf(91);
            Preconditions.checkState((destArrayBegin > 0 ? 1 : 0) != 0);
            int testArrayBegin = destPath.lastIndexOf(91);
            Preconditions.checkState((testArrayBegin > 0 ? 1 : 0) != 0);
            if (destArrayBegin == testArrayBegin && (destPrefix = destPath.substring(0, destArrayBegin)).equals(testPrefix = testPath.substring(0, testArrayBegin))) {
                return true;
            }
        }
        return false;
    }

    static Number parseNumber(String numStr) {
        if (numStr.contains(".") || numStr.toLowerCase().contains("e")) {
            return Double.parseDouble(numStr);
        }
        return Long.parseLong(numStr);
    }

    public static class PropertiesAdapter
    extends TypeAdapter<FeatureProperties> {
        protected void serialize(JsonWriter out, String name, Object value) throws IOException {
            FeatureProperties.propSerializeDefault(out, value);
        }

        public void write(JsonWriter out, FeatureProperties properties) throws IOException {
            if (properties == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            for (String name : properties.keySet()) {
                out.name(name);
                Object value = properties.get(name);
                FeatureProperties.propSerializeDefault(out, value);
            }
            out.endObject();
        }

        protected Object deserialize(JsonReader in, String name) throws IOException {
            return FeatureProperties.propDeserializeDefault(in);
        }

        public FeatureProperties read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            FeatureProperties properties = new FeatureProperties();
            while (in.hasNext()) {
                String name = in.nextName();
                Object value = this.deserialize(in, name);
                properties.put(name, value);
            }
            in.endObject();
            return properties;
        }

        public FeatureProperties readAfterFirstName(JsonReader in, String name0) throws IOException {
            FeatureProperties properties = new FeatureProperties();
            Object value0 = this.deserialize(in, name0);
            properties.put(name0, value0);
            while (in.hasNext()) {
                String name = in.nextName();
                Object value = this.deserialize(in, name);
                properties.put(name, value);
            }
            in.endObject();
            return properties;
        }

        public FeatureProperties readAfterFirstNameAndValue(JsonReader in, String name0, Object value0) throws IOException {
            FeatureProperties properties = new FeatureProperties();
            properties.put(name0, value0);
            while (in.hasNext()) {
                String name = in.nextName();
                Object value = this.deserialize(in, name);
                properties.put(name, value);
            }
            in.endObject();
            return properties;
        }
    }
}

