/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.geo.utm;

import java.util.Locale;
import org.opensha.commons.geo.utm.WGS84;

public class UTM {
    private double easting;
    private double northing;
    private int zone;
    private char letter;

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public int getZone() {
        return this.zone;
    }

    public char getLetter() {
        return this.letter;
    }

    public String toString() {
        return String.format("%s %c %s %s", this.zone, Character.valueOf(this.letter), this.easting, this.northing);
    }

    public boolean equals(Object o) {
        if (o instanceof UTM) {
            UTM other = (UTM)o;
            return this.zone == other.zone && this.letter == other.letter && this.easting == other.easting && this.northing == other.northing;
        }
        return false;
    }

    public int hashCode() {
        long least = Double.doubleToRawLongBits(this.easting);
        long lnort = Double.doubleToRawLongBits(this.northing);
        long x = least ^ lnort;
        return (int)(x ^ x >>> 32);
    }

    public UTM(int zone, char letter, double easting, double northing) {
        this.zone = zone;
        this.letter = Character.toUpperCase(letter);
        this.easting = easting;
        this.northing = northing;
    }

    public UTM(String utm) {
        String[] parts = utm.split(" ");
        this.zone = Integer.parseInt(parts[0]);
        this.letter = parts[1].toUpperCase(Locale.ENGLISH).charAt(0);
        this.easting = Double.parseDouble(parts[2]);
        this.northing = Double.parseDouble(parts[3]);
    }

    public UTM(WGS84 wgs) {
        this.fromWGS84(wgs.getLatitude(), wgs.getLongitude(), UTM.calcZone(wgs.getLongitude()), UTM.calcLetter(wgs.getLatitude()));
    }

    public UTM(WGS84 wgs, int zone, char letter) {
        this.fromWGS84(wgs.getLatitude(), wgs.getLongitude(), zone, letter);
    }

    public static int calcZone(double longitude) {
        return (int)Math.floor(longitude / 6.0 + 31.0);
    }

    public static char calcLetter(double latitude) {
        if (latitude < -72.0) {
            return 'C';
        }
        if (latitude < -64.0) {
            return 'D';
        }
        if (latitude < -56.0) {
            return 'E';
        }
        if (latitude < -48.0) {
            return 'F';
        }
        if (latitude < -40.0) {
            return 'G';
        }
        if (latitude < -32.0) {
            return 'H';
        }
        if (latitude < -24.0) {
            return 'J';
        }
        if (latitude < -16.0) {
            return 'K';
        }
        if (latitude < -8.0) {
            return 'L';
        }
        if (latitude < 0.0) {
            return 'M';
        }
        if (latitude < 8.0) {
            return 'N';
        }
        if (latitude < 16.0) {
            return 'P';
        }
        if (latitude < 24.0) {
            return 'Q';
        }
        if (latitude < 32.0) {
            return 'R';
        }
        if (latitude < 40.0) {
            return 'S';
        }
        if (latitude < 48.0) {
            return 'T';
        }
        if (latitude < 56.0) {
            return 'U';
        }
        if (latitude < 64.0) {
            return 'V';
        }
        if (latitude < 72.0) {
            return 'W';
        }
        return 'X';
    }

    private void fromWGS84(double latitude, double longitude, int zone, char letter) {
        this.zone = zone;
        this.letter = letter;
        this.easting = 0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))) * 0.9996 * 6399593.62 / Math.pow(1.0 + Math.pow(0.0820944379, 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0), 0.5) * (1.0 + Math.pow(0.0820944379, 2.0) / 2.0 * Math.pow(0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0) / 3.0) + 500000.0;
        this.easting = (double)Math.round(this.easting * 100.0) * 0.01;
        this.northing = (Math.atan(Math.tan(latitude * Math.PI / 180.0) / Math.cos(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) - latitude * Math.PI / 180.0) * 0.9996 * 6399593.625 / Math.sqrt(1.0 + 0.006739496742 * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) * (1.0 + 0.003369748371 * Math.pow(0.5 * Math.log((1.0 + Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0)) / (1.0 - Math.cos(latitude * Math.PI / 180.0) * Math.sin(longitude * Math.PI / 180.0 - (double)(6 * zone - 183) * Math.PI / 180.0))), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) + 6397033.7875500005 * (latitude * Math.PI / 180.0 - 0.005054622556 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + 4.258201531E-5 * (3.0 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 4.0 - 1.674057895E-7 * (5.0 * (3.0 * (latitude * Math.PI / 180.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) / 2.0) + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 4.0 + Math.sin(2.0 * latitude * Math.PI / 180.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0) * Math.pow(Math.cos(latitude * Math.PI / 180.0), 2.0)) / 3.0);
        if (letter < 'M') {
            this.northing += 1.0E7;
        }
        this.northing = (double)Math.round(this.northing * 100.0) * 0.01;
    }
}

