/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.IntegerDiscreteConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;

public class PlotColorAndLineTypeSelectorControlPanel
extends JFrame
implements ActionListener,
ParameterChangeListener {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel1 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JPanel colorAndLineTypeSelectorPanel;
    private StringParameter xAxisLabelParam;
    public static final String xAxisLabelParamName = "X-Axis Label";
    private StringParameter yAxisLabelParam;
    public static final String yAxisLabelParamName = "Y-Axis Label";
    private StringParameter plotLabelParam;
    public static final String plotLabelParamName = "Plot Label";
    private static final String colorChooserString = "Color";
    public static final String LINE_WIDTH_NAME = "Line Size";
    public static final String SYMBOL_WIDTH_NAME = "Symbol Size";
    private static final String NONE_OPTION = "(none)";
    public static final String LINE_TYPE_NAME = "Line Type";
    private static final PlotLineType LINE_TYPE_DEFAULT = PlotLineType.SOLID;
    private ArrayList<String> lineTypeStrings;
    public static final String SYMBOL_NAME = "Symbol";
    private static final PlotSymbol SYMBOL_DEFAULT = null;
    private ArrayList<String> symbolStrings;
    private IntegerParameter tickFontSizeParam;
    public static final String tickFontSizeParamName = "Set tick label size";
    private IntegerParameter axisLabelsFontSizeParam;
    public static final String axislabelsFontSizeParamName = "Set axis label ";
    private IntegerParameter plotLabelsFontSizeParam;
    public static final String plotlabelsFontSizeParamName = "Set Plot label ";
    private static final String PLOT_ORDER_PARAM_NAME = "Plotting Order";
    private static final String PLOT_ORDER_FORWARD = "Most Recent On Top";
    private static final String PLOT_ORDER_BACKWARD = "Most Recent On Bottom";
    private static final String PLOT_ORDER_DEFAULT = "Most Recent On Top";
    private StringParameter plotOrderParam;
    private ParameterList plotParamList;
    private ParameterListEditor plotParamEditor;
    private JLabel[] datasetSelector;
    private JButton[] colorChooserButton;
    private StringParameter[] lineTypeParam;
    private StringParameter[] symbolTypeParam;
    private DoubleParameter[] lineWidthParameter;
    private DoubleParameter[] symbolWidthParameter;
    private JButton applyButton = new JButton();
    private JButton cancelButton = new JButton();
    private BorderLayout borderLayout1 = new BorderLayout();
    private List<PlotCurveCharacterstics> plottingFeatures;
    private List<PlotCurveCharacterstics> defaultPlottingFeatures;
    private JButton RevertButton = new JButton();
    private JPanel curveFeaturePanel = new JPanel();
    private JButton doneButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GraphWidget gw;

    public PlotColorAndLineTypeSelectorControlPanel(GraphWidget gw, List<PlotCurveCharacterstics> curveCharacterstics) {
        System.out.println("PlotColorAndLineTypeSelectorControlPanel Init!");
        this.gw = gw;
        this.lineTypeStrings = new ArrayList();
        this.lineTypeStrings.add(NONE_OPTION);
        for (PlotLineType plotLineType : PlotLineType.values()) {
            this.lineTypeStrings.add(plotLineType.toString());
        }
        this.symbolStrings = new ArrayList();
        this.symbolStrings.add(NONE_OPTION);
        for (Enum enum_ : PlotSymbol.values()) {
            this.symbolStrings.add(((PlotSymbol)enum_).toString());
        }
        ArrayList<Integer> supportedFontSizes = new ArrayList<Integer>();
        supportedFontSizes.add(8);
        supportedFontSizes.add(10);
        supportedFontSizes.add(12);
        supportedFontSizes.add(14);
        supportedFontSizes.add(16);
        supportedFontSizes.add(18);
        supportedFontSizes.add(20);
        supportedFontSizes.add(22);
        supportedFontSizes.add(24);
        this.tickFontSizeParam = new IntegerParameter(tickFontSizeParamName, (ParameterConstraint<Integer>)new IntegerDiscreteConstraint(supportedFontSizes), supportedFontSizes.get(1));
        this.axisLabelsFontSizeParam = new IntegerParameter(axislabelsFontSizeParamName, (ParameterConstraint<Integer>)new IntegerDiscreteConstraint(supportedFontSizes), supportedFontSizes.get(2));
        this.plotLabelsFontSizeParam = new IntegerParameter(plotlabelsFontSizeParamName, (ParameterConstraint<Integer>)new IntegerDiscreteConstraint(supportedFontSizes), supportedFontSizes.get(2));
        ArrayList<String> plotOrderStrings = new ArrayList<String>();
        plotOrderStrings.add("Most Recent On Top");
        plotOrderStrings.add(PLOT_ORDER_BACKWARD);
        this.plotOrderParam = new StringParameter(PLOT_ORDER_PARAM_NAME, plotOrderStrings, "Most Recent On Top");
        this.tickFontSizeParam.addParameterChangeListener(this);
        this.axisLabelsFontSizeParam.addParameterChangeListener(this);
        this.plotLabelsFontSizeParam.addParameterChangeListener(this);
        this.plotOrderParam.addParameterChangeListener(this);
        this.xAxisLabelParam = new StringParameter(xAxisLabelParamName, gw.getXAxisLabel());
        this.yAxisLabelParam = new StringParameter(yAxisLabelParamName, gw.getYAxisLabel());
        this.plotLabelParam = new StringParameter(plotLabelParamName, gw.getPlotLabel());
        this.xAxisLabelParam.addParameterChangeListener(this);
        this.yAxisLabelParam.addParameterChangeListener(this);
        this.plotLabelParam.addParameterChangeListener(this);
        this.plotParamList = new ParameterList();
        this.plotParamList.addParameter(this.tickFontSizeParam);
        this.plotParamList.addParameter(this.axisLabelsFontSizeParam);
        this.plotParamList.addParameter(this.xAxisLabelParam);
        this.plotParamList.addParameter(this.yAxisLabelParam);
        this.plotParamList.addParameter(this.plotLabelParam);
        this.plotParamList.addParameter(this.plotLabelsFontSizeParam);
        this.plotParamList.addParameter(this.plotOrderParam);
        this.plotParamEditor = new ParameterListEditor(this.plotParamList);
        this.plotParamEditor.setTitle("Plot Label Prefs Setting");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLocation(gw.getX() + gw.getWidth() / 3, gw.getY() + gw.getHeight() / 2);
        this.setPlotColorAndLineType(curveCharacterstics);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(new Font("Arial", 0, 18));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setText("Plot Settings");
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.applyButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.cancelButton_actionPerformed(e);
            }
        });
        this.RevertButton.setText("Revert");
        this.RevertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.RevertButton_actionPerformed(e);
            }
        });
        this.curveFeaturePanel.setLayout(new GridLayout(0, 6));
        this.doneButton.setText("Done");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotColorAndLineTypeSelectorControlPanel.this.doneButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.colorAndLineTypeSelectorPanel = new JPanel();
        this.colorAndLineTypeSelectorPanel.setLayout(new BoxLayout(this.colorAndLineTypeSelectorPanel, 1));
        this.colorAndLineTypeSelectorPanel.add(this.curveFeaturePanel);
        this.colorAndLineTypeSelectorPanel.add(this.plotParamEditor);
        JScrollPane scroll = new JScrollPane(this.colorAndLineTypeSelectorPanel);
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 6, 0, 11), 0, 0));
        this.jPanel1.add((Component)scroll, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 6, 0, 11), 0, 0));
        this.jPanel1.add((Component)this.cancelButton, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 22, 2, 108), 0, 0));
        this.jPanel1.add((Component)this.RevertButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 21, 2, 0), 0, 0));
        this.jPanel1.add((Component)this.doneButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 22, 2, 0), 0, 0));
        this.jPanel1.add((Component)this.applyButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 99, 2, 0), 0, 0));
        this.jPanel1.setSize(930, 500);
        this.setSize(930, 500);
    }

    public void setPlotColorAndLineType(List<PlotCurveCharacterstics> curveCharacterstics) {
        int i;
        PlotPreferences plotPrefs = this.gw.getPlotPrefs();
        this.setOrAddParameterValue(this.axisLabelsFontSizeParam, plotPrefs.getAxisLabelFontSize());
        this.setOrAddParameterValue(this.tickFontSizeParam, plotPrefs.getTickLabelFontSize());
        this.setOrAddParameterValue(this.plotLabelsFontSizeParam, plotPrefs.getPlotLabelFontSize());
        this.axisLabelsFontSizeParam.getEditor().refreshParamEditor();
        this.tickFontSizeParam.getEditor().refreshParamEditor();
        this.plotLabelsFontSizeParam.getEditor().refreshParamEditor();
        DatasetRenderingOrder plotOrder = this.gw.getPlottingOrder();
        String plotOrderStr = plotOrder == DatasetRenderingOrder.FORWARD ? "Most Recent On Top" : PLOT_ORDER_BACKWARD;
        this.plotOrderParam.setValue(plotOrderStr);
        this.plotOrderParam.getEditor().refreshParamEditor();
        int numCurves = curveCharacterstics.size();
        this.plottingFeatures = curveCharacterstics;
        this.defaultPlottingFeatures = new ArrayList<PlotCurveCharacterstics>();
        for (int i2 = 0; i2 < numCurves; ++i2) {
            PlotCurveCharacterstics curvePlotPref = this.plottingFeatures.get(i2);
            this.defaultPlottingFeatures.add((PlotCurveCharacterstics)curvePlotPref.clone());
        }
        this.datasetSelector = new JLabel[numCurves];
        this.colorChooserButton = new JButton[numCurves];
        this.lineTypeParam = new StringParameter[numCurves];
        this.lineWidthParameter = new DoubleParameter[numCurves];
        this.symbolTypeParam = new StringParameter[numCurves];
        this.symbolWidthParameter = new DoubleParameter[numCurves];
        DoubleConstraint sizeConstraint = new DoubleConstraint(0.0, 1000.0);
        for (i = 0; i < numCurves; ++i) {
            PlotCurveCharacterstics curvePlotPref = this.plottingFeatures.get(i);
            this.datasetSelector[i] = new JLabel(curvePlotPref.getName());
            this.datasetSelector[i].setForeground(curvePlotPref.getColor());
            this.colorChooserButton[i] = new JButton(colorChooserString);
            this.colorChooserButton[i].addActionListener(this);
            PlotLineType plt = curvePlotPref.getLineType();
            this.lineTypeParam[i] = new StringParameter(LINE_TYPE_NAME, this.lineTypeStrings, this.plotLineTypeToString(plt));
            this.lineTypeParam[i].addParameterChangeListener(this);
            PlotSymbol sym = curvePlotPref.getSymbol();
            this.symbolTypeParam[i] = new StringParameter(SYMBOL_NAME, this.symbolStrings, this.plotSymbolToString(sym));
            this.symbolTypeParam[i].addParameterChangeListener(this);
            this.lineWidthParameter[i] = new DoubleParameter(LINE_WIDTH_NAME, sizeConstraint, Double.valueOf(curvePlotPref.getLineWidth()));
            this.symbolWidthParameter[i] = new DoubleParameter(SYMBOL_WIDTH_NAME, sizeConstraint, Double.valueOf(curvePlotPref.getSymbolWidth()));
        }
        this.curveFeaturePanel.removeAll();
        for (i = 0; i < numCurves; ++i) {
            this.curveFeaturePanel.add(this.datasetSelector[i]);
            this.curveFeaturePanel.add(this.colorChooserButton[i]);
            this.curveFeaturePanel.add(this.lineTypeParam[i].getEditor().getComponent());
            this.curveFeaturePanel.add(this.lineWidthParameter[i].getEditor().getComponent());
            this.curveFeaturePanel.add(this.symbolTypeParam[i].getEditor().getComponent());
            this.curveFeaturePanel.add(this.symbolWidthParameter[i].getEditor().getComponent());
        }
        this.curveFeaturePanel.doLayout();
        this.colorAndLineTypeSelectorPanel.doLayout();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equals(LINE_TYPE_NAME) || paramName.equals(SYMBOL_NAME)) {
            Parameter param = event.getParameter();
            for (int i = 0; i < this.lineTypeParam.length; ++i) {
                if (this.lineTypeParam[i] != param && this.symbolTypeParam[i] != param) continue;
                this.updateEditorEnables(i);
                break;
            }
        } else {
            this.plotParamEditor.refreshParamEditor();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int numCurves = this.plottingFeatures.size();
        if (e.getSource() instanceof JButton) {
            Object button = e.getSource();
            for (int i = 0; i < numCurves; ++i) {
                Color color;
                PlotCurveCharacterstics curvePlotPref = this.plottingFeatures.get(i);
                if (!button.equals(this.colorChooserButton[i]) || (color = JColorChooser.showDialog(this, "Select Color", curvePlotPref.getColor())) == null) continue;
                curvePlotPref.setColor(color);
                this.datasetSelector[i].setForeground(color);
            }
        }
    }

    private PlotLineType getPlotLineType(int index) {
        StringParameter pltParam = this.lineTypeParam[index];
        String str = (String)pltParam.getValue();
        if (str.equals(NONE_OPTION)) {
            return null;
        }
        return PlotLineType.forString(str);
    }

    private String plotLineTypeToString(PlotLineType plt) {
        if (plt == null) {
            return NONE_OPTION;
        }
        return plt.toString();
    }

    private PlotSymbol getPlotSymbol(int index) {
        StringParameter symParam = this.symbolTypeParam[index];
        String str = (String)symParam.getValue();
        if (str.equals(NONE_OPTION)) {
            return null;
        }
        return PlotSymbol.forString(str);
    }

    private String plotSymbolToString(PlotSymbol sym) {
        if (sym == null) {
            return NONE_OPTION;
        }
        return sym.toString();
    }

    private void updateEditorEnables(int index) {
        this.updateEditorEnables(index, this.getPlotLineType(index), this.getPlotSymbol(index));
    }

    private void updateEditorEnables(int index, PlotLineType plt, PlotSymbol sym) {
        boolean lineSelected = plt != null;
        boolean symbolEnabled = !lineSelected || lineSelected && plt.isSymbolCompatible();
        boolean symbolWidthEnabled = symbolEnabled && sym != null;
        this.lineWidthParameter[index].getEditor().setEnabled(lineSelected);
        this.symbolTypeParam[index].getEditor().setEnabled(symbolEnabled);
        if (!symbolEnabled) {
            this.symbolTypeParam[index].removeParameterChangeListener(this);
            this.symbolTypeParam[index].setValue(NONE_OPTION);
            this.symbolTypeParam[index].addParameterChangeListener(this);
            this.symbolTypeParam[index].getEditor().refreshParamEditor();
        }
        this.symbolWidthParameter[index].getEditor().setEnabled(symbolWidthEnabled);
    }

    void applyButton_actionPerformed(ActionEvent e) {
        this.applyChangesToPlot();
    }

    private int getInvalidSettingsIndex() {
        for (int i = 0; i < this.plottingFeatures.size(); ++i) {
            PlotLineType plt = this.getPlotLineType(i);
            PlotSymbol sym = this.getPlotSymbol(i);
            if (plt != null || sym != null) continue;
            return i;
        }
        return -1;
    }

    private void showInvalidSettingsDialog(int index) {
        String message = "You must select a line and/or symbol.\nThey cannot both be '(none)'.\n\nInvalid Curve: #" + (index + 1);
        String title = "Invalid settigns for curve " + (index + 1);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private boolean applyChangesToPlot() {
        int numCurves = this.plottingFeatures.size();
        for (int i = 0; i < numCurves; ++i) {
            PlotCurveCharacterstics chars = this.plottingFeatures.get(i);
            PlotLineType lineType = this.getPlotLineType(i);
            float lineWidth = ((Double)this.lineWidthParameter[i].getValue()).floatValue();
            PlotSymbol symbol = this.getPlotSymbol(i);
            float symbolWidth = ((Double)this.symbolWidthParameter[i].getValue()).floatValue();
            chars.set(lineType, lineWidth, symbol, symbolWidth, chars.getColor());
        }
        this.gw.setXAxisLabel((String)this.xAxisLabelParam.getValue());
        this.gw.setYAxisLabel((String)this.yAxisLabelParam.getValue());
        this.gw.setPlotLabel((String)this.plotLabelParam.getValue());
        String plotOrder = (String)this.plotOrderParam.getValue();
        if (plotOrder.equals("Most Recent On Top")) {
            this.gw.setPlottingOrder(DatasetRenderingOrder.FORWARD);
        } else {
            this.gw.setPlottingOrder(DatasetRenderingOrder.REVERSE);
        }
        PlotPreferences plotPrefs = this.gw.getPlotPrefs();
        plotPrefs.setAxisLabelFontSize((Integer)this.axisLabelsFontSizeParam.getValue());
        plotPrefs.setTickLabelFontSize((Integer)this.tickFontSizeParam.getValue());
        plotPrefs.setPlotLabelFontSize((Integer)this.plotLabelsFontSizeParam.getValue());
        this.gw.drawGraph();
        return true;
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.revertPlotToOriginal();
        this.dispose();
    }

    void RevertButton_actionPerformed(ActionEvent e) {
        int flag = JOptionPane.showConfirmDialog(this, "Restore Original Values", "Reverting changes", 2);
        if (flag == 0) {
            this.revertPlotToOriginal();
        }
    }

    private void revertPlotToOriginal() {
        int numCurves = this.defaultPlottingFeatures.size();
        for (int i = 0; i < numCurves; ++i) {
            PlotCurveCharacterstics defaultChars = this.defaultPlottingFeatures.get(i);
            PlotCurveCharacterstics chars = this.plottingFeatures.get(i);
            this.datasetSelector[i].setForeground(defaultChars.getColor());
            chars.setColor(defaultChars.getColor());
            PlotLineType lineType = defaultChars.getLineType();
            this.lineTypeParam[i].setValue(this.plotLineTypeToString(lineType));
            this.lineTypeParam[i].getEditor().refreshParamEditor();
            chars.setLineType(lineType);
            PlotSymbol symbol = defaultChars.getSymbol();
            this.symbolTypeParam[i].setValue(this.plotSymbolToString(symbol));
            this.symbolTypeParam[i].getEditor().refreshParamEditor();
            chars.setSymbol(symbol);
            float lineWidth = defaultChars.getLineWidth();
            this.lineWidthParameter[i].setValue(lineWidth);
            this.lineWidthParameter[i].getEditor().refreshParamEditor();
            chars.setLineWidth(lineWidth);
            float symbolWidth = defaultChars.getSymbolWidth();
            this.symbolWidthParameter[i].setValue(symbolWidth);
            this.symbolWidthParameter[i].getEditor().refreshParamEditor();
            chars.setSymbolWidth(symbolWidth);
            this.curveFeaturePanel.repaint();
            this.curveFeaturePanel.validate();
            this.gw.drawGraph();
        }
    }

    private void setOrAddParameterValue(IntegerParameter intParam, Integer value) {
        if (intParam.isAllowed(value)) {
            intParam.setValue(value);
        } else {
            IntegerDiscreteConstraint iconst = (IntegerDiscreteConstraint)intParam.getConstraint();
            iconst.addAllowed(value);
            intParam.setValue(value);
        }
    }

    void doneButton_actionPerformed(ActionEvent e) {
        if (this.applyChangesToPlot()) {
            this.dispose();
        }
    }
}

