/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import java.awt.Color;
import java.io.Serializable;
import org.opensha.commons.data.Named;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;

public class PlotCurveCharacterstics
implements Named,
Cloneable,
Serializable {
    private PlotLineType lineType;
    private float lineWidth;
    private PlotSymbol symbol;
    private float symbolWidth;
    private Color color;
    private String name = "Data";

    public PlotCurveCharacterstics(PlotLineType lineType, float lineWidth, Color color) {
        this(lineType, lineWidth, null, 4.0f, color);
    }

    public PlotCurveCharacterstics(PlotSymbol symbol, float symbolWidth, Color color) {
        this(null, 1.0f, symbol, symbolWidth, color);
    }

    public PlotCurveCharacterstics(PlotLineType lineType, float lineWidth, PlotSymbol symbol, float symbolWidth, Color color) {
        this("Data", lineType, lineWidth, symbol, symbolWidth, color);
    }

    public PlotCurveCharacterstics(String name, PlotLineType lineType, float lineWidth, PlotSymbol symbol, float symbolWidth, Color color) {
        this.set(name, lineType, lineWidth, symbol, symbolWidth, color);
    }

    public void setLineType(PlotLineType lineType) {
        this.lineType = lineType;
    }

    public PlotLineType getLineType() {
        return this.lineType;
    }

    public void setSymbol(PlotSymbol symbol) {
        this.symbol = symbol;
    }

    public PlotSymbol getSymbol() {
        return this.symbol;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setSymbolWidth(float symbolWidth) {
        this.symbolWidth = symbolWidth;
    }

    public float getSymbolWidth() {
        return this.symbolWidth;
    }

    public void set(PlotLineType lineType, float lineWidth, PlotSymbol symbol, float symbolWidth, Color color) {
        this.set(this.name, lineType, lineWidth, symbol, symbolWidth, color);
    }

    public void set(String name, PlotLineType lineType, float lineWidth, PlotSymbol symbol, float symbolWidth, Color color) {
        this.name = name;
        this.lineType = lineType;
        this.lineWidth = lineWidth;
        this.symbol = symbol;
        this.symbolWidth = symbolWidth;
        this.color = color;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object clone() {
        return new PlotCurveCharacterstics(this.name, this.lineType, this.lineWidth, this.symbol, this.symbolWidth, this.color);
    }

    public String toString() {
        Object str = "";
        if (this.lineType != null && this.lineWidth > 0.0f) {
            str = (String)str + "line: " + String.valueOf((Object)this.lineType) + ", width=" + this.lineWidth;
        }
        if (!((String)str).isEmpty()) {
            str = (String)str + "; ";
        }
        if (this.symbol != null && this.symbolWidth > 0.0f) {
            str = (String)str + "symbol: " + String.valueOf((Object)this.symbol) + ", width=" + this.symbolWidth;
        }
        if (!((String)str).isEmpty() && !((String)str).endsWith("; ")) {
            str = (String)str + "; ";
        }
        str = (String)str + "color: " + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue();
        return str;
    }
}

