/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.XYShadedUncertainLineRenderer;
import org.opensha.commons.gui.plot.XYSolidBarRenderer;

public enum PlotLineType {
    SOLID("Solid"),
    DOTTED("Dotted"),
    DASHED("Dashed"),
    SHORT_DASHED("Short Dashed"),
    DOTTED_AND_DASHED("Dotted & Dashed"),
    HISTOGRAM("Histogram"),
    STACKED_BAR("Stacked Bar"),
    SOLID_BAR("Solid Bar"),
    SHADED_UNCERTAIN("Shaded Uncertain Dataset"),
    SHADED_UNCERTAIN_TRANS("Shaded Transparent Uncertain Dataset"),
    POLYGON_SOLID("Polygon with solid fill");

    private String desc;

    private PlotLineType(String desc) {
        this.desc = desc;
    }

    public String toString() {
        return this.desc;
    }

    public Stroke buildStroke(float lineWidth) {
        Preconditions.checkArgument((lineWidth > 0.0f ? 1 : 0) != 0, (Object)"Line width must be >0");
        if (this == SOLID) {
            return new BasicStroke(lineWidth);
        }
        if (this == DOTTED) {
            return new BasicStroke(lineWidth, 0, 2, 0.0f, new float[]{Float.min(6.0f, Float.max(lineWidth * 0.7f, 1.0f))}, 0.0f);
        }
        if (this == DASHED) {
            return new BasicStroke(lineWidth, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
        }
        if (this == SHORT_DASHED) {
            return new BasicStroke(lineWidth, 0, 2, 0.0f, new float[]{4.0f}, 0.0f);
        }
        if (this == DOTTED_AND_DASHED) {
            return new BasicStroke(lineWidth, 0, 2, 0.0f, new float[]{5.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
        }
        throw new IllegalStateException("Stroke not applicable for lineType: " + String.valueOf((Object)this));
    }

    public static PlotLineType forString(String desc) {
        for (PlotLineType plt : PlotLineType.values()) {
            if (!plt.desc.equalsIgnoreCase(desc)) continue;
            return plt;
        }
        throw new NoSuchElementException("No line type exists for '" + desc + "'");
    }

    public static XYItemRenderer buildRenderer(PlotLineType plt, PlotSymbol sym, float width) throws IllegalStateException {
        if (plt == null) {
            return PlotLineType.buildRenderer(plt, sym, width, width);
        }
        return PlotLineType.buildRenderer(plt, sym, width, width * 4.0f);
    }

    public boolean isSymbolCompatible() {
        return this != HISTOGRAM && this != STACKED_BAR && this != SOLID_BAR && this != SHADED_UNCERTAIN_TRANS && this != SHADED_UNCERTAIN && this != POLYGON_SOLID;
    }

    public static void checkValidConfiguration(PlotLineType plt, PlotSymbol sym) {
        Preconditions.checkState((sym != null || plt != null ? 1 : 0) != 0, (Object)"Must supply either a plot line type, or a symbol.");
        Preconditions.checkState((plt == null || sym == null || plt.isSymbolCompatible() ? 1 : 0) != 0, (Object)"A symbol cannot be suplied with a line type that doesn't support symbols.");
    }

    public static XYItemRenderer buildRenderer(PlotLineType plt, PlotSymbol sym, float lineWidth, float symWidth) throws IllegalStateException {
        PlotLineType.checkValidConfiguration(plt, sym);
        Object renderer = null;
        XYLineAndShapeRenderer lineShpRend = new XYLineAndShapeRenderer(plt != null, sym != null);
        lineShpRend.setDrawSeriesLineAsPath(true);
        if (plt != null) {
            Preconditions.checkArgument((plt == SHADED_UNCERTAIN || lineWidth > 0.0f ? 1 : 0) != 0, (Object)"line widht must be > 0");
            if (plt == HISTOGRAM) {
                XYBarRenderer xyRend = new XYBarRenderer();
                xyRend.setShadowVisible(false);
                xyRend.setMargin(0.1);
                xyRend.setBarPainter((XYBarPainter)new StandardXYBarPainter());
                renderer = xyRend;
            } else if (plt == STACKED_BAR) {
                StackedXYBarRenderer sbRend = new StackedXYBarRenderer();
                sbRend.setShadowVisible(false);
                renderer = sbRend;
            } else if (plt == SOLID_BAR) {
                renderer = new XYSolidBarRenderer(lineWidth);
            } else if (plt == SHADED_UNCERTAIN) {
                renderer = new XYShadedUncertainLineRenderer();
            } else if (plt == SHADED_UNCERTAIN_TRANS) {
                renderer = new XYShadedUncertainLineRenderer(0.5);
            } else if (plt == POLYGON_SOLID) {
                renderer = new CustomXYAreaRenderer();
            } else {
                renderer = lineShpRend;
                Stroke stroke = plt.buildStroke(lineWidth);
                renderer.setSeriesStroke(0, stroke);
            }
        }
        if (sym != null) {
            if (renderer == null) {
                renderer = lineShpRend;
            } else {
                Preconditions.checkState((boolean)(renderer instanceof XYLineAndShapeRenderer), (Object)("Renderer already exists but isn't correct type for plt=" + String.valueOf((Object)plt) + " and sym=" + String.valueOf((Object)sym)));
            }
            Preconditions.checkArgument((symWidth > 0.0f ? 1 : 0) != 0, (Object)"symbol widht must be >0");
            Shape shape = sym.buildShape(symWidth);
            Preconditions.checkNotNull((Object)shape, (Object)("Couldn't build shape for symbol: " + String.valueOf((Object)sym)));
            renderer.setSeriesShape(0, shape);
            lineShpRend.setSeriesShapesFilled(0, sym.isFilled());
        }
        return renderer;
    }

    public static class CustomXYAreaRenderer
    extends XYLineAndShapeRenderer {
        public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
            if (item != 0) {
                return;
            }
            if (pass != 0) {
                return;
            }
            Path2D.Double polygon = new Path2D.Double();
            boolean firstPoint = true;
            int pointCount = dataset.getItemCount(series);
            double firstX = Double.NaN;
            double firstY = Double.NaN;
            for (int i = 0; i < pointCount; ++i) {
                double xValue = dataset.getXValue(series, i);
                double yValue = dataset.getYValue(series, i);
                double xScreen = domainAxis.valueToJava2D(xValue, dataArea, plot.getDomainAxisEdge());
                double yScreen = rangeAxis.valueToJava2D(yValue, dataArea, plot.getRangeAxisEdge());
                if (firstPoint) {
                    ((Path2D)polygon).moveTo(xScreen, yScreen);
                    firstX = xScreen;
                    firstY = yScreen;
                    firstPoint = false;
                    continue;
                }
                ((Path2D)polygon).lineTo(xScreen, yScreen);
            }
            if (pointCount > 2) {
                polygon.closePath();
            }
            Paint seriesPaint = this.getItemPaint(series, 0);
            g2.setPaint(seriesPaint);
            g2.fill(polygon);
        }
    }
}

