/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.block.ColumnArrangement;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotPreferences;

public class PlotSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<? extends PlotElement> elems;
    protected List<PlotCurveCharacterstics> chars;
    private String title;
    private String xAxisLabel;
    private String yAxisLabel;
    private List<XYAnnotation> annotations;
    private List<Title> subtitles;
    private boolean legend = false;
    private boolean legendSkipBlank = true;
    private RectangleEdge legendLocation = RectangleEdge.BOTTOM;
    private LegendItemCollection customLegendCollection = null;
    private boolean insetLegend = false;
    private RectangleAnchor insetLegendLocation = RectangleAnchor.TOP_RIGHT;
    private double insetLegendRelX = 0.975;
    private double insetLegendRelY = 0.975;
    private double insetLegendMaxWidth = 0.35;
    private boolean insetLegendSingleColumn = true;
    private boolean xAxisInverted = false;
    private boolean yAxisInverted = false;

    public PlotSpec(List<? extends PlotElement> elems, List<PlotCurveCharacterstics> chars, String title, String xAxisLabel, String yAxisLabel) {
        this.elems = elems;
        this.chars = chars;
        this.title = title;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
    }

    public List<? extends PlotElement> getPlotElems() {
        return Collections.unmodifiableList(this.elems);
    }

    public List<DiscretizedFunc> getPlotFunctionsOnly() {
        ArrayList funcs = Lists.newArrayList();
        for (PlotElement plotElement : this.elems) {
            if (!(plotElement instanceof DiscretizedFunc)) continue;
            funcs.add((DiscretizedFunc)plotElement);
        }
        return funcs;
    }

    public void setPlotElems(List<? extends PlotElement> elems) {
        this.elems = elems;
    }

    public void setPlotAnnotations(List<? extends XYAnnotation> annotations) {
        this.annotations = annotations == null ? null : new ArrayList<XYAnnotation>(annotations);
    }

    public void addPlotAnnotation(XYAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<XYAnnotation>();
        }
        this.annotations.add(annotation);
    }

    public void addPlotAnnotation(int index, XYAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<XYAnnotation>();
        }
        this.annotations.add(index, annotation);
    }

    public List<XYAnnotation> getPlotAnnotations() {
        return this.annotations;
    }

    public void setSubtitles(List<? extends Title> subtitles) {
        this.subtitles = subtitles == null ? null : new ArrayList<Title>(subtitles);
    }

    public void addSubtitle(Title subtitle) {
        if (this.subtitles == null) {
            this.subtitles = new ArrayList<Title>();
        }
        this.subtitles.add(subtitle);
    }

    public List<Title> getSubtitles() {
        return this.subtitles;
    }

    public List<PlotCurveCharacterstics> getChars() {
        return this.chars;
    }

    public void setChars(List<PlotCurveCharacterstics> chars) {
        this.chars = chars;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public String getYAxisLabel() {
        return this.yAxisLabel;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public boolean isLegendVisible() {
        return this.legend;
    }

    public void setLegendVisible(boolean legend) {
        this.legend = legend;
    }

    public boolean isLegendSkipBlank() {
        return this.legendSkipBlank;
    }

    public void setLegendSkipBlank(boolean legendSkipBlank) {
        this.legendSkipBlank = legendSkipBlank;
    }

    public RectangleEdge getLegendLocation() {
        return this.legendLocation;
    }

    public void setLegendLocation(RectangleEdge legendLocation) {
        this.legendLocation = legendLocation;
    }

    public LegendItemCollection getLegendItems(XYPlot plot) {
        if (this.customLegendCollection != null) {
            return this.customLegendCollection;
        }
        LegendItemCollection items = plot.getLegendItems();
        for (int i = 0; i < items.getItemCount(); ++i) {
            LegendItem legend = items.get(i);
            Shape lineShape = legend.getLine();
            Stroke stroke = legend.getLineStroke();
            if (!(lineShape instanceof Line2D) || !(stroke instanceof BasicStroke) || ((BasicStroke)stroke).getEndCap() != 0) continue;
            Line2D line = (Line2D)lineShape;
            line.setLine(line.getX1() * 2.0, line.getY1(), line.getX2() * 2.0, line.getY2());
        }
        if (this.isLegendSkipBlank()) {
            LegendItemCollection newItems = new LegendItemCollection();
            for (int i = 0; i < items.getItemCount(); ++i) {
                LegendItem item = items.get(i);
                String label = item.getLabel();
                if (label == null || label.isEmpty()) continue;
                newItems.add(item);
            }
            items = newItems;
        }
        return items;
    }

    public void setCustomLegendItems(LegendItemCollection customLegendCollection) {
        this.customLegendCollection = customLegendCollection;
    }

    public void setLegendInset(boolean insetLegend) {
        if (insetLegend) {
            this.legend = true;
        }
        this.insetLegend = insetLegend;
    }

    public void setLegendInset(RectangleAnchor anchor) {
        Preconditions.checkNotNull((Object)anchor);
        this.legend = true;
        this.insetLegend = true;
        this.insetLegendLocation = anchor;
        this.insetLegendRelY = anchor == RectangleAnchor.TOP || anchor == RectangleAnchor.TOP_LEFT || anchor == RectangleAnchor.TOP_RIGHT ? 0.975 : (anchor == RectangleAnchor.BOTTOM || anchor == RectangleAnchor.BOTTOM_LEFT || anchor == RectangleAnchor.BOTTOM_RIGHT ? 0.025 : 0.5);
        this.insetLegendRelX = anchor == RectangleAnchor.LEFT || anchor == RectangleAnchor.TOP_LEFT || anchor == RectangleAnchor.BOTTOM_LEFT ? 0.055 : (anchor == RectangleAnchor.RIGHT || anchor == RectangleAnchor.TOP_RIGHT || anchor == RectangleAnchor.BOTTOM_RIGHT ? 0.975 : 0.5);
    }

    public boolean isXAxisInverted() {
        return this.xAxisInverted;
    }

    public void setXAxisInverted(boolean xAxisInverted) {
        this.xAxisInverted = xAxisInverted;
    }

    public boolean isYAxisInverted() {
        return this.yAxisInverted;
    }

    public void setYAxisInverted(boolean yAxisInverted) {
        this.yAxisInverted = yAxisInverted;
    }

    public void setLegendInset(RectangleAnchor anchor, double relX, double relY, double maxWidth, boolean singleColumn) {
        this.legend = true;
        this.insetLegend = true;
        this.insetLegendLocation = anchor;
        this.insetLegendRelX = relX;
        this.insetLegendRelY = relY;
        this.insetLegendMaxWidth = maxWidth;
        this.insetLegendSingleColumn = singleColumn;
    }

    public boolean isLegendInset() {
        return this.insetLegend;
    }

    public XYTitleAnnotation buildInsetLegend(final LegendItemCollection items, PlotPreferences plotPrefs, boolean xLog, boolean yLog, Range xRange, Range yRange) {
        LegendItemSource source = new LegendItemSource(){
            final /* synthetic */ PlotSpec this$0;
            {
                this.this$0 = this$0;
            }

            public LegendItemCollection getLegendItems() {
                return items;
            }
        };
        LegendTitle lt = this.insetLegendSingleColumn ? new LegendTitle(source, (Arrangement)new ColumnArrangement(), (Arrangement)new ColumnArrangement()) : new LegendTitle(source);
        Font legendFont = lt.getItemFont();
        lt.setItemFont(new Font(legendFont.getName(), legendFont.getStyle(), plotPrefs.getLegendFontSize()));
        lt.setBackgroundPaint((Paint)plotPrefs.getInsetLegendBackground());
        if (plotPrefs.getInsetLegendBorder() != null) {
            lt.setFrame((BlockFrame)new BlockBorder((Paint)plotPrefs.getInsetLegendBorder()));
        }
        RectangleEdge edge = this.insetLegendLocation == RectangleAnchor.BOTTOM || this.insetLegendLocation == RectangleAnchor.BOTTOM_LEFT || this.insetLegendLocation == RectangleAnchor.BOTTOM_RIGHT ? RectangleEdge.BOTTOM : RectangleEdge.TOP;
        lt.setPosition(edge);
        double relX = this.insetLegendRelX;
        if (this.xAxisInverted) {
            relX = 1.0 - relX;
        }
        if (xLog) {
            relX = PlotSpec.relLogPos(relX, xRange);
        }
        double relY = this.insetLegendRelY;
        if (this.yAxisInverted) {
            relY = 1.0 - relY;
        }
        if (yLog) {
            relY = PlotSpec.relLogPos(relY, yRange);
        }
        XYTitleAnnotation ann = new XYTitleAnnotation(relX, relY, (Title)lt, this.insetLegendLocation);
        ann.setMaxWidth(this.insetLegendMaxWidth);
        return ann;
    }

    private static double relLogPos(double relPos, Range range) {
        double anchor = Math.pow(10.0, relPos * (Math.log10(range.getUpperBound()) - Math.log10(range.getLowerBound())) + Math.log10(range.getLowerBound()));
        return (anchor - range.getLowerBound()) / range.getLength();
    }
}

