/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.XYSolidBarRenderer;
import org.opensha.commons.gui.plot.jfreechart.DiscretizedFunctionXYDataSet;
import org.opensha.commons.gui.plot.jfreechart.JFreeLogarithmicAxis;

public class XYShadedUncertainLineRenderer
extends AbstractXYItemRenderer {
    private double fillTrans;

    public XYShadedUncertainLineRenderer() {
        this(Double.NaN);
    }

    public XYShadedUncertainLineRenderer(double fillTrans) {
        this.fillTrans = fillTrans;
    }

    public synchronized void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        int i;
        if (!(dataset instanceof DiscretizedFunctionXYDataSet) || !(((DiscretizedFunctionXYDataSet)dataset).getXYDataset(series) instanceof UncertainBoundedDiscretizedFunc)) {
            System.err.println("Isn't an UncertainArbDiscrDataset, doing nothing!");
            return;
        }
        UncertainBoundedDiscretizedFunc uData = (UncertainBoundedDiscretizedFunc)((DiscretizedFunctionXYDataSet)dataset).getXYDataset(series);
        boolean logX = domainAxis instanceof JFreeLogarithmicAxis;
        boolean logY = rangeAxis instanceof JFreeLogarithmicAxis;
        Preconditions.checkState((uData.size() > 0 ? 1 : 0) != 0, (Object)"Can't draw empty polygon");
        int lastIndexBefore = -1;
        int firstIndexAfter = -1;
        double lowerX = domainAxis.getLowerBound();
        double upperX = domainAxis.getUpperBound();
        for (int i2 = 0; i2 < uData.size(); ++i2) {
            double x = uData.getX(i2);
            if (x < lowerX || lastIndexBefore < 0) {
                lastIndexBefore = i2;
            }
            if (!(x > upperX) && i2 != uData.size() - 1) continue;
            firstIndexAfter = i2;
            break;
        }
        if (item != lastIndexBefore) {
            return;
        }
        ArrayList outline = Lists.newArrayList();
        outline.add(XYShadedUncertainLineRenderer.getLogCompatible(logX, logY, uData.get(lastIndexBefore)));
        for (i = lastIndexBefore; i <= firstIndexAfter; ++i) {
            outline.add(XYShadedUncertainLineRenderer.getLogCompatible(logX, logY, new Point2D.Double(uData.getX(i), uData.getUpperY(i))));
        }
        outline.add(XYShadedUncertainLineRenderer.getLogCompatible(logX, logY, uData.get(firstIndexAfter)));
        i = firstIndexAfter + 1;
        while (--i >= lastIndexBefore) {
            outline.add(XYShadedUncertainLineRenderer.getLogCompatible(logX, logY, new Point2D.Double(uData.getX(i), uData.getLowerY(i))));
        }
        Polygon p = XYSolidBarRenderer.buildPolygon(dataArea, plot, domainAxis, rangeAxis, outline);
        Paint paint = this.getItemPaint(series, item);
        Preconditions.checkState((boolean)(paint instanceof Color));
        if (Double.isNaN(this.fillTrans)) {
            g2.setPaint(paint);
        } else {
            Color lineColor = (Color)paint;
            Color fillColor = new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), (int)(255.0 * this.fillTrans));
            g2.setPaint(fillColor);
        }
        g2.fillPolygon(p);
    }

    private static Point2D getLogCompatible(boolean logX, boolean logY, Point2D pt) {
        if (!logX && !logY) {
            return pt;
        }
        double x = pt.getX();
        double y = pt.getY();
        if (logY) {
            y = Math.max(y, 1.0E-16);
        }
        return new Point2D.Double(x, y);
    }

    public static void main(String[] args) {
        ArbitrarilyDiscretizedFunc meanFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc upperFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc lowerFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < 10; ++i) {
            double x = i;
            double y = 0.5 + Math.random();
            meanFunc.set(x, y);
            upperFunc.set(x, y + 0.2 * Math.random());
            lowerFunc.set(x, y - 0.2 * Math.random());
        }
        UncertainArbDiscFunc uncertainFunc = new UncertainArbDiscFunc(meanFunc, lowerFunc, upperFunc);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(uncertainFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN_TRANS, 2.0f, Color.BLUE));
        funcs.add(uncertainFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        GraphWindow gw = new GraphWindow(funcs, "Demo", chars);
        gw.setDefaultCloseOperation(3);
    }
}

