/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart.logTest;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.opensha.commons.gui.plot.jfreechart.logTest.XYDataWindow;

public class JFreeLogPlotTesterApp
extends JFrame {
    protected static final String C = "JFreeLogPlotTesterApp";
    protected static final boolean D = false;
    private boolean autoScale = true;
    private boolean isStandalone = true;
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JPanel innerPlotPanel = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JComboBox rangeCombo = new JComboBox();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel4 = new JLabel();
    private JLabel jLabel5 = new JLabel();
    private JTextField minXText = new JTextField();
    private JTextField maxXText = new JTextField();
    private JTextField minYText = new JTextField();
    private JTextField maxYText = new JTextField();
    private JButton addButton = new JButton();
    private JButton clearButton = new JButton();
    private ArrayList logRanges = new ArrayList();
    private static final String TEST_0 = new String("Auto Scale");
    private static final String TEST_1 = new String("Preset-1");
    private static final String TEST_2 = new String("Preset-2");
    private static final String TEST_3 = new String("Preset-3");
    private static final String TEST_4 = new String("Preset-4");
    private static final String TEST_5 = new String("Preset-5");
    private static final String TEST_6 = new String("Preset-6");
    private static final String TEST_7 = new String("Preset-7");
    private static final String TEST_8 = new String("Preset-8");
    private static final String TEST_9 = new String("Preset-9");
    private static final String TEST_10 = new String("Preset-10");
    private static final String TEST_11 = new String("Preset-11");
    private static final String TEST_12 = new String("Preset-12");
    private static final String TEST_13 = new String("Preset-13");
    private static final String TEST_14 = new String("Preset-14");
    private static final String TEST_15 = new String("Preset-15");
    private static final String CUSTOM_SCALE = new String("Custom Scale");
    private static final String LOG = "Log Scale";
    private static final String LINEAR = "Linear Scale";
    private static final String TITLE = "Log-Log Testing";
    private static final String USE_DEFAULT = "Use Default";
    private static final String NEW_DATASET = "Enter New Data";
    protected static final int W = 820;
    protected static final int H = 670;
    private double Y_MIN_VAL = 1.0E-8;
    protected double minXValue;
    protected double maxXValue;
    protected double minYValue;
    protected double maxYValue;
    NumberAxis xAxis = null;
    NumberAxis yAxis = null;
    XYSeriesCollection functions = new XYSeriesCollection();
    Color lightBlue = new Color(200, 200, 230);
    Insets defaultInsets = new Insets(0, 0, 0, 0);
    private JComboBox dataSetCombo = new JComboBox();
    private JLabel jLabel6 = new JLabel();
    private ChartPanel panel;
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JRadioButton log10CaretCheck = new JRadioButton();
    private JRadioButton log10AsECheck = new JRadioButton();
    private ButtonGroup group = new ButtonGroup();
    private XYDataWindow dataWindow;
    private JLabel jLabel7 = new JLabel();
    private JComboBox axisCombo = new JComboBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public String getParameter(String key, String def) {
        return System.getProperty(key, def);
    }

    public JFreeLogPlotTesterApp() {
        this.logRanges.add(TEST_0);
        this.logRanges.add(CUSTOM_SCALE);
        this.logRanges.add(TEST_1);
        this.logRanges.add(TEST_2);
        this.logRanges.add(TEST_3);
        this.logRanges.add(TEST_4);
        this.logRanges.add(TEST_5);
        this.logRanges.add(TEST_6);
        this.logRanges.add(TEST_7);
        this.logRanges.add(TEST_8);
        this.logRanges.add(TEST_9);
        this.logRanges.add(TEST_10);
        this.logRanges.add(TEST_11);
        this.logRanges.add(TEST_12);
        this.logRanges.add(TEST_13);
        this.logRanges.add(TEST_14);
        this.logRanges.add(TEST_15);
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initLogPlotGui();
    }

    protected void initLogPlotGui() {
        String S = "JFreeLogPlotTesterApp: initLogPlotGui(): ";
        this.axisCombo.addItem(LOG);
        this.axisCombo.addItem(LINEAR);
        this.axisCombo.setSelectedItem(LOG);
        this.dataSetCombo.addItem(USE_DEFAULT);
        this.dataSetCombo.addItem(NEW_DATASET);
        this.dataSetCombo.setSelectedItem(USE_DEFAULT);
        Iterator it = this.logRanges.iterator();
        while (it.hasNext()) {
            this.rangeCombo.addItem(it.next());
        }
        this.rangeCombo.setSelectedItem((String)this.rangeCombo.getItemAt(0));
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setForeground(new Color(80, 80, 133));
        this.jLabel1.setText("Test Case:");
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setForeground(new Color(80, 80, 133));
        this.jLabel2.setText("Min X:");
        this.jLabel3.setFont(new Font("Dialog", 1, 12));
        this.jLabel3.setForeground(new Color(80, 80, 133));
        this.jLabel3.setText("Max X:");
        this.jLabel4.setFont(new Font("Dialog", 1, 12));
        this.jLabel4.setForeground(new Color(80, 80, 133));
        this.jLabel4.setText("Min Y:");
        this.jLabel5.setFont(new Font("Dialog", 1, 12));
        this.jLabel5.setForeground(new Color(80, 80, 133));
        this.jLabel5.setText("Max Y:");
        this.addButton.setBackground(new Color(200, 200, 230));
        this.addButton.setFont(new Font("Dialog", 1, 10));
        this.addButton.setForeground(new Color(80, 80, 133));
        this.addButton.setText("Add Plot");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeLogPlotTesterApp.this.addButton_actionPerformed(e);
            }
        });
        this.clearButton.setBackground(new Color(200, 200, 230));
        this.clearButton.setFont(new Font("Dialog", 1, 10));
        this.clearButton.setForeground(new Color(80, 80, 133));
        this.clearButton.setText("Clear Plot");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeLogPlotTesterApp.this.clearButton_actionPerformed(e);
            }
        });
        this.innerPlotPanel.setLayout(this.gridBagLayout2);
        this.jSplitPane1.setDividerSize(5);
        this.jPanel2.setBackground(Color.white);
        this.rangeCombo.setBackground(new Color(200, 200, 230));
        this.rangeCombo.setForeground(new Color(80, 80, 133));
        this.rangeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeLogPlotTesterApp.this.rangeCombo_actionPerformed(e);
            }
        });
        this.innerPlotPanel.setBackground(Color.white);
        this.minXText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JFreeLogPlotTesterApp.this.minXText_keyTyped(e);
            }
        });
        this.maxXText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JFreeLogPlotTesterApp.this.maxXText_keyTyped(e);
            }
        });
        this.minYText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JFreeLogPlotTesterApp.this.minYText_keyTyped(e);
            }
        });
        this.maxYText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JFreeLogPlotTesterApp.this.maxYText_keyTyped(e);
            }
        });
        this.jLabel6.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel6.setForeground(new Color(80, 80, 133));
        this.jLabel6.setText("Set DataSet:");
        this.log10CaretCheck.setText("Set tick as(10^N)");
        this.log10CaretCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeLogPlotTesterApp.this.log10CaretCheck_actionPerformed(e);
            }
        });
        this.log10AsECheck.setText("Set tick as (1e#)");
        this.log10AsECheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeLogPlotTesterApp.this.log10AsECheck_actionPerformed(e);
            }
        });
        this.dataSetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeLogPlotTesterApp.this.dataSetCombo_actionPerformed(e);
            }
        });
        this.jLabel7.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel7.setForeground(new Color(80, 80, 133));
        this.jLabel7.setText("Axis:");
        this.axisCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeLogPlotTesterApp.this.axisCombo_actionPerformed(e);
            }
        });
        this.jSplitPane1.add((Component)this.innerPlotPanel, "left");
        this.jSplitPane1.add((Component)this.jPanel2, "right");
        this.jPanel2.add((Component)this.minXText, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 131, 4));
        this.jPanel2.add((Component)this.rangeCombo, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(120, 0, 0, 10), -4, -2));
        this.jPanel2.add((Component)this.maxXText, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 131, 4));
        this.jPanel2.add((Component)this.minYText, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 131, 4));
        this.jPanel2.add((Component)this.maxYText, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 131, 4));
        this.jPanel2.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 23, 9));
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(120, 1, 0, 0), 17, 9));
        this.jPanel2.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 7), 17, 9));
        this.jPanel2.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 12), 17, 9));
        this.jPanel2.add((Component)this.jLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 18), 7, 9));
        this.jPanel2.add((Component)this.clearButton, new GridBagConstraints(3, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(109, 0, 63, 10), 23, 6));
        this.jPanel2.add((Component)this.addButton, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 10, 0, new Insets(109, 8, 63, 0), 17, 6));
        this.jPanel2.add((Component)this.log10CaretCheck, new GridBagConstraints(0, 7, 4, 1, 0.0, 0.0, 10, 0, new Insets(24, 12, 0, 24), 65, 8));
        this.jPanel2.add((Component)this.log10AsECheck, new GridBagConstraints(0, 9, 4, 1, 0.0, 0.0, 10, 0, new Insets(21, 12, 0, 24), 72, 8));
        this.jPanel2.add((Component)this.dataSetCombo, new GridBagConstraints(2, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(12, 0, 0, 10), -13, 3));
        this.jPanel2.add((Component)this.jLabel6, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 7, 0, 0), 6, 8));
        this.jPanel2.add((Component)this.jLabel7, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(19, 8, 0, 0), 35, 12));
        this.jPanel2.add((Component)this.axisCombo, new GridBagConstraints(2, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(19, 0, 0, 10), -13, 3));
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.setDividerLocation(500);
        this.group.add(this.log10AsECheck);
        this.group.add(this.log10CaretCheck);
        this.group.setSelected(this.log10CaretCheck.getModel(), true);
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        JFreeLogPlotTesterApp applet = new JFreeLogPlotTesterApp();
        applet.isStandalone = true;
        applet.setDefaultCloseOperation(3);
        applet.setTitle("Log Plol Tester Applet");
        applet.init();
        applet.setSize(820, 670);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        applet.setLocation((d.width - applet.getSize().width) / 2, (d.height - applet.getSize().height) / 2);
        applet.setVisible(true);
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.addButton();
    }

    private void addButton() {
        String S = "JFreeLogPlotTesterApp: addButton(): ";
        this.clearPlot();
        if (((String)this.dataSetCombo.getSelectedItem()).equals(NEW_DATASET)) {
            this.functions.addSeries(this.dataWindow.getDataSet());
            this.autoScale = true;
        } else {
            this.fillValues(new XYSeries((Comparable)((Object)"Default Data")));
        }
        this.addGraphPanel();
    }

    void addGraphPanel() {
        String S = "JFreeLogPlotTesterApp: addGraphPanel(): ";
        if (!this.autoScale) {
            this.minYValue = Double.parseDouble(this.minYText.getText());
            this.maxYValue = Double.parseDouble(this.maxYText.getText());
            this.minXValue = Double.parseDouble(this.minXText.getText());
            this.maxXValue = Double.parseDouble(this.maxXText.getText());
        }
        this.setAxis();
        if (this.axisCombo.getSelectedItem().equals(LOG)) {
            if (this.log10AsECheck.isSelected()) {
                this.setLog10AsEFlag();
            } else if (this.log10CaretCheck.isSelected()) {
                this.setLog10AsCaretFlag();
            }
        }
        int type = 2;
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(type, (XYToolTipGenerator)new StandardXYToolTipGenerator());
        this.xAxis.setAutoRangeIncludesZero(false);
        this.xAxis.setTickMarksVisible(false);
        this.yAxis.setAutoRangeIncludesZero(false);
        this.yAxis.setTickMarksVisible(false);
        if (!this.autoScale) {
            this.xAxis.setRange(this.minXValue, this.maxXValue);
            this.yAxis.setRange(this.minYValue, this.maxYValue);
        }
        XYPlot plot = null;
        plot = new XYPlot((XYDataset)this.functions, (ValueAxis)this.xAxis, (ValueAxis)this.yAxis, (XYItemRenderer)renderer);
        plot.setBackgroundAlpha(0.8f);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setDomainCrosshairLockedOnData(false);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeCrosshairLockedOnData(false);
        plot.setRangeCrosshairVisible(false);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 15.0));
        JFreeChart chart = new JFreeChart(TITLE, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBackgroundPaint((Paint)this.lightBlue);
        this.panel = new ChartPanel(chart, true, true, true, true, true);
        this.panel.setBorder(BorderFactory.createEtchedBorder(1));
        this.panel.setMouseZoomable(true);
        this.panel.setDisplayToolTips(true);
        this.panel.setHorizontalAxisTrace(false);
        this.panel.setVerticalAxisTrace(false);
        this.innerPlotPanel.removeAll();
        this.innerPlotPanel.add((Component)this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        if (this.dataSetCombo.getItemCount() > 0) {
            if (((String)this.dataSetCombo.getSelectedItem()).equals(NEW_DATASET)) {
                this.setXRange(this.xAxis.getLowerBound(), this.xAxis.getUpperBound());
                this.setYRange(this.yAxis.getLowerBound(), this.yAxis.getUpperBound());
            }
        }
        this.innerPlotPanel.validate();
        this.innerPlotPanel.repaint();
    }

    public void setXRange(double xMin, double xMax) {
        this.minXText.setText("" + xMin);
        this.maxXText.setText("" + xMax);
    }

    public void setYRange(double yMin, double yMax) {
        this.minYText.setText("" + yMin);
        this.maxYText.setText("" + yMax);
    }

    void clearButton_actionPerformed(ActionEvent e) {
        this.clearPlot();
    }

    void clearPlot() {
        this.functions.removeAllSeries();
        this.innerPlotPanel.removeAll();
        this.panel = null;
        this.validate();
        this.repaint();
    }

    private void fillValues(XYSeries function) {
        function.add(-20.0, -20.0);
        function.add(20.0, 20.0);
        this.functions.addSeries(function);
    }

    void minXText_keyTyped(KeyEvent e) {
        this.autoScale = false;
    }

    void maxXText_keyTyped(KeyEvent e) {
        this.autoScale = false;
    }

    void minYText_keyTyped(KeyEvent e) {
        this.autoScale = false;
    }

    void maxYText_keyTyped(KeyEvent e) {
        this.autoScale = false;
    }

    void rangeCombo_actionPerformed(ActionEvent e) {
        if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_0)) {
            this.autoScale = true;
            this.addButton();
            Range rX = this.xAxis.getRange();
            Range rY = this.yAxis.getRange();
            this.setXRange(rX.getLowerBound(), rX.getUpperBound());
            this.setYRange(rY.getLowerBound(), rY.getUpperBound());
            this.showRangeFields(false);
        } else {
            this.autoScale = false;
            this.showRangeFields(true);
            if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_1)) {
                this.setXRange(5.0E-21, 1.0E-20);
                this.setYRange(5.0E-21, 1.0E-20);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_2)) {
                this.setXRange(1.0E-20, 1.0E-19);
                this.setYRange(1.0E-20, 1.0E-19);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_3)) {
                this.setXRange(1.0E-20, 1.0E-17);
                this.setYRange(1.0E-20, 1.0E-17);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_4)) {
                this.setXRange(1.0E-20, 1.0E-16);
                this.setYRange(1.0E-20, 1.0E-16);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_5)) {
                this.setXRange(1.0E-20, 1.0E-15);
                this.setYRange(1.0E-20, 1.0E-15);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_6)) {
                this.setXRange(1.0E-11, 1.0E-7);
                this.setYRange(1.0E-11, 1.0E-7);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_7)) {
                this.setXRange(0.01, 10.0);
                this.setYRange(0.01, 10.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_8)) {
                this.setXRange(0.01, 100.0);
                this.setYRange(0.01, 100.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_9)) {
                this.setXRange(0.01, 1000.0);
                this.setYRange(0.01, 1000.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_10)) {
                this.setXRange(10.0, 10000.0);
                this.setYRange(10.0, 10000.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_11)) {
                this.setXRange(10.0, 100000.0);
                this.setYRange(10.0, 100000.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_12)) {
                this.setXRange(2.0, 2.0);
                this.setYRange(2.0, 2.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_13)) {
                this.setXRange(1.0, 1.0);
                this.setYRange(1.0, 1.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_14)) {
                this.setXRange(100000.0, 1.0E7);
                this.setYRange(100000.0, 1.0E7);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(TEST_15)) {
                this.setXRange(2.0, 8.0);
                this.setYRange(2.0, 8.0);
            } else if (this.rangeCombo.getSelectedItem().toString().equalsIgnoreCase(CUSTOM_SCALE)) {
                this.minXText.setText("");
                this.maxXText.setText("");
                this.minYText.setText("");
                this.maxYText.setText("");
                return;
            }
        }
        this.addGraphPanel();
    }

    private void showRangeFields(boolean flag) {
        this.minXText.setEnabled(flag);
        this.maxXText.setEnabled(flag);
        this.minYText.setEnabled(flag);
        this.maxYText.setEnabled(flag);
    }

    void dataSetCombo_actionPerformed(ActionEvent e) {
        if (((String)this.dataSetCombo.getSelectedItem()).equals(NEW_DATASET)) {
            if (this.dataWindow == null) {
                this.dataWindow = new XYDataWindow((Component)this, this.functions);
            }
            this.dataWindow.setVisible(true);
            this.dataWindow.pack();
        }
    }

    void log10CaretCheck_actionPerformed(ActionEvent e) {
        this.setLog10AsCaretFlag();
        this.addGraphPanel();
    }

    private void setLog10AsCaretFlag() {
        if (this.log10CaretCheck.isSelected()) {
            ((LogarithmicAxis)this.xAxis).setAllowNegativesFlag(true);
            ((LogarithmicAxis)this.yAxis).setAllowNegativesFlag(true);
            ((LogarithmicAxis)this.xAxis).setLog10TickLabelsFlag(true);
            ((LogarithmicAxis)this.yAxis).setLog10TickLabelsFlag(true);
        }
    }

    void log10AsECheck_actionPerformed(ActionEvent e) {
        this.setLog10AsEFlag();
        this.addGraphPanel();
    }

    private void setLog10AsEFlag() {
        if (this.log10AsECheck.isSelected()) {
            ((LogarithmicAxis)this.xAxis).setAllowNegativesFlag(true);
            ((LogarithmicAxis)this.yAxis).setAllowNegativesFlag(true);
            ((LogarithmicAxis)this.xAxis).setLog10TickLabelsFlag(false);
            ((LogarithmicAxis)this.yAxis).setLog10TickLabelsFlag(false);
            ((LogarithmicAxis)this.xAxis).setExpTickLabelsFlag(true);
            ((LogarithmicAxis)this.yAxis).setExpTickLabelsFlag(true);
        }
    }

    private void setAxis() {
        String axisOption = (String)this.axisCombo.getSelectedItem();
        if (axisOption.equals(LOG)) {
            this.xAxis = new LogarithmicAxis("X-Axis");
            this.yAxis = new LogarithmicAxis("Y-Axis");
            this.log10AsECheck.setVisible(true);
            this.log10CaretCheck.setVisible(true);
        } else {
            this.xAxis = new NumberAxis("X-Axis");
            this.yAxis = new NumberAxis("Y-Axis");
            this.log10AsECheck.setVisible(false);
            this.log10CaretCheck.setVisible(false);
        }
    }

    void axisCombo_actionPerformed(ActionEvent e) {
        this.setAxis();
        this.addGraphPanel();
    }
}

