/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart.tornado;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.jfreechart.tornado.TornadoDiagram;
import org.opensha.commons.util.DataUtils;

public class TornadoDemo {
    public static void main(String[] args) throws IOException {
        TornadoDiagram t = new TornadoDiagram("Test Tornado", "X", "Category", 1.0);
        t.addTornadoValue("Category 1", "C1", 0.5 + Math.random());
        t.addTornadoValue("Category 1", "C2", 0.5 + Math.random());
        t.addTornadoValue("Category 1", "C3", 0.5 + Math.random());
        t.addTornadoValue("Category 2", "C1", 1.0 + 0.8 * (Math.random() - 0.5));
        t.addTornadoValue("Category 2", "C2", 1.0 + 0.8 * (Math.random() - 0.5));
        t.addTornadoValue("Category 2", "C3", 1.0 + 0.8 * (Math.random() - 0.5));
        t.addTornadoValue("Category 3", "C1", 1.0 + 0.3 * (Math.random() - 0.5));
        t.addTornadoValue("Category 3", "C2", 1.0 + 0.3 * (Math.random() - 0.5));
        t.addTornadoValue("Category 3", "C3", 1.0 + 0.3 * (Math.random() - 0.5));
        GraphWindow gw = t.displayPlot();
        gw.setDefaultCloseOperation(3);
        t.getHeadlessPlot(500, 400).saveAsPNG(new File("/tmp/tornado.png").getAbsolutePath());
        File csvDir = new File("/home/kevin/OpenSHA/UCERF3/TimeDependent_AVE_ALL/m6.7_30yr/BranchSensitivityMaps");
        double[] meanVals = null;
        double[] calcVals = null;
        int numFiles = 0;
        for (File file : csvDir.listFiles()) {
            if (!file.getName().endsWith(".csv")) continue;
            CSVFile<String> csv = CSVFile.readFile(file, true);
            if (meanVals == null) {
                meanVals = new double[csv.getNumRows() - 1];
                calcVals = new double[csv.getNumRows() - 1];
            }
            int i = 0;
            while (i < meanVals.length) {
                double m;
                List<String> line = csv.getLine(i + 1);
                double v = Double.parseDouble(line.get(1));
                meanVals[i] = m = Double.parseDouble(line.get(2));
                int n = i++;
                calcVals[n] = calcVals[n] + v;
            }
            ++numFiles;
        }
        int i = 0;
        while (i < meanVals.length) {
            int n = i++;
            calcVals[n] = calcVals[n] / (double)numFiles;
        }
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker pTrack = new DataUtils.MinMaxAveTracker();
        for (int i2 = 0; i2 < meanVals.length; ++i2) {
            void calc = calcVals[i2];
            double table = meanVals[i2];
            double pDiff = DataUtils.getPercentDiff((double)calc, table);
            track.addValue((double)(calc - table));
            pTrack.addValue(pDiff);
        }
        System.out.println("Actual diff: " + String.valueOf(track));
        System.out.println("P diff: " + String.valueOf(pTrack));
    }
}

