/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart.tornado;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;

public class TornadoDiagram {
    private String title;
    private String xAxisLabel;
    private String yAxisLabel;
    private double plotMean;
    private CPT cpt;
    private Table<String, String, Double> tornadoVals;
    private static final double startY = 1.0;
    private static final double deltaY = 1.0;
    private static final float thickness = 0.4f;
    private static final double ann_buff_x_mult = 1.3;
    private static final double ann_buff_x_mult_plot = 1.35;

    public static CPT getGrayTornadoCPT() {
        CPT cpt = new CPT();
        cpt.add(new CPTVal(0.0, Color.LIGHT_GRAY, 1.0, Color.BLACK));
        return cpt;
    }

    public TornadoDiagram(String title, String xAxisLabel, String yAxisLabel, double plotMean) {
        this(title, xAxisLabel, yAxisLabel, plotMean, TornadoDiagram.getGrayTornadoCPT());
    }

    public TornadoDiagram(String title, String xAxisLabel, String yAxisLabel, double plotMean, CPT cpt) {
        this.cpt = cpt;
        this.plotMean = plotMean;
        this.title = title;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
        this.tornadoVals = HashBasedTable.create();
    }

    public void addTornadoValue(String category, String choice, double val) {
        this.tornadoVals.put((Object)category, (Object)choice, (Object)val);
    }

    private double getMaxAbsRel(String category, double plotMean) {
        double catMax = 0.0;
        Iterator iterator = this.tornadoVals.row((Object)category).values().iterator();
        while (iterator.hasNext()) {
            double val = (Double)iterator.next();
            double absRel = Math.abs(val - plotMean);
            if (!(absRel > catMax)) continue;
            catMax = absRel;
        }
        return catMax;
    }

    private double getTotalSwing(String category, double plotMean) {
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        Iterator iterator = this.tornadoVals.row((Object)category).values().iterator();
        while (iterator.hasNext()) {
            double val = (Double)iterator.next();
            track.addValue(val);
        }
        track.addValue(plotMean);
        return track.getMax() - track.getMin();
    }

    public Range getXRange() {
        double maxRelAbsDiff = 0.0;
        for (Table.Cell cell : this.tornadoVals.cellSet()) {
            double relAbsDiff = Math.abs((Double)cell.getValue() - this.plotMean);
            if (!(relAbsDiff > maxRelAbsDiff)) continue;
            maxRelAbsDiff = relAbsDiff;
        }
        return new Range(this.plotMean - 1.35 * maxRelAbsDiff, this.plotMean + 1.35 * maxRelAbsDiff);
    }

    public Range getYRange() {
        return new Range(0.5, (double)this.tornadoVals.rowKeySet().size() + 0.5);
    }

    public PlotSpec getPlot() {
        return this.getPlot(null);
    }

    public PlotSpec getPlot(List<String> categoryOrder) {
        Preconditions.checkState((this.tornadoVals.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one value for tornado!");
        ArrayList levels = Lists.newArrayList();
        if (categoryOrder == null) {
            for (String category : this.tornadoVals.rowKeySet()) {
                levels.add(new PlotTornadoLevel(category, this.plotMean));
            }
            Collections.sort(levels);
        } else {
            for (String category : categoryOrder) {
                Preconditions.checkState((boolean)this.tornadoVals.rowKeySet().contains(category), (Object)("'" + category + "' not found in table"));
                levels.add(new PlotTornadoLevel(category, this.plotMean));
            }
        }
        Collections.reverse(levels);
        double maxRelDiff = 0.0;
        for (PlotTornadoLevel level : levels) {
            if (!(level.maxAbsRel > maxRelDiff)) continue;
            maxRelDiff = level.maxAbsRel;
        }
        ArrayList elems = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        ArrayList anns = Lists.newArrayList();
        double y = 1.0;
        for (PlotTornadoLevel level : levels) {
            double leftMostX = Double.POSITIVE_INFINITY;
            String leftMostName = null;
            double rightMostX = Double.NEGATIVE_INFINITY;
            String rightMostName = null;
            for (NameValPair pair : level.choiceVals) {
                System.out.println("Plotting " + level.name + ":" + pair.name + ". val=" + pair.val);
                double val = pair.val;
                String name = pair.name;
                if (val < leftMostX) {
                    leftMostX = val;
                    leftMostName = name;
                }
                if (val > rightMostX) {
                    rightMostX = val;
                    rightMostName = name;
                }
                float relMag = (float)(Math.abs(val) / maxRelDiff);
                Color c = this.cpt.getColor(relMag);
                System.out.println(relMag + ": " + String.valueOf(c));
                elems.add(TornadoDiagram.line(level.name + ": " + pair.name, this.plotMean, y, this.plotMean + val, y));
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID_BAR, 0.4f, c));
            }
            XYTextAnnotation leftAnn = new XYTextAnnotation(leftMostName, this.plotMean - 1.3 * maxRelDiff, y);
            leftAnn.setFont(new Font("SansSerif", 0, 16));
            leftAnn.setTextAnchor(TextAnchor.CENTER_LEFT);
            XYTextAnnotation rightAnn = new XYTextAnnotation(rightMostName, this.plotMean + 1.3 * maxRelDiff, y);
            rightAnn.setFont(new Font("SansSerif", 0, 16));
            rightAnn.setTextAnchor(TextAnchor.CENTER_RIGHT);
            anns.add(leftAnn);
            anns.add(rightAnn);
            y += 1.0;
        }
        elems.add(TornadoDiagram.line("Mean", this.plotMean, 0.0, this.plotMean, y - 0.5));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(elems, chars, this.title, this.xAxisLabel, this.yAxisLabel);
        spec.setPlotAnnotations(anns);
        return spec;
    }

    public GraphWindow displayPlot() {
        PlotSpec spec = this.getPlot(null);
        GraphWindow gw = new GraphWindow(spec);
        TornadoDiagram.setupGraphPanel(gw.getGraphWidget().getGraphPanel());
        gw.setAxisRange(this.getXRange(), this.getYRange());
        return gw;
    }

    public HeadlessGraphPanel getHeadlessPlot(int width, int height) {
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        gp.setBackgroundColor(Color.WHITE);
        gp.setUserBounds(this.getXRange(), this.getYRange());
        gp.drawGraphPanel(this.getPlot());
        TornadoDiagram.setupGraphPanel(gp);
        gp.getChartPanel().setSize(width, height);
        return gp;
    }

    private static void setupGraphPanel(GraphPanel gp) {
        gp.getYAxis().setTickLabelsVisible(false);
    }

    private static XY_DataSet line(String name, double x0, double y0, double x1, double y1) {
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.setName(name);
        line.set(x0, y0);
        line.set(x1, y1);
        return line;
    }

    private class PlotTornadoLevel
    extends NameValPair {
        List<NameValPair> choiceVals;
        double maxAbsRel;

        public PlotTornadoLevel(String category, double plotMean) {
            super(category, TornadoDiagram.this.getTotalSwing(category, plotMean));
            this.maxAbsRel = TornadoDiagram.this.getMaxAbsRel(category, plotMean);
            this.choiceVals = Lists.newArrayList();
            Map choiceMap = TornadoDiagram.this.tornadoVals.row((Object)category);
            for (String choice : choiceMap.keySet()) {
                double relVal = (Double)choiceMap.get(choice) - plotMean;
                this.choiceVals.add(new NameValPair(choice, relVal));
            }
            Collections.sort(this.choiceVals);
        }
    }

    private class NameValPair
    implements Comparable<NameValPair> {
        String name;
        double val;

        public NameValPair(String name, double val) {
            this.name = name;
            this.val = val;
        }

        @Override
        public int compareTo(NameValPair o) {
            return -Double.compare(Math.abs(this.val), Math.abs(o.val));
        }
    }
}

