/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.gui.plot.jfreechart.xyzPlot;

import com.google.common.base.Preconditions;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.PublicCloneable;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class XYIntervalBlockRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private PaintScale paintScale = new LookupPaintScale();

    public PaintScale getPaintScale() {
        return this.paintScale;
    }

    public void setPaintScale(PaintScale scale) {
        Args.nullNotPermitted((Object)scale, (String)"scale");
        this.paintScale = scale;
        this.fireChangeEvent();
    }

    public Range findDomainBounds(XYDataset dataset) {
        if (dataset == null) {
            return null;
        }
        return DatasetUtils.findDomainBounds((XYDataset)dataset, (boolean)false);
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset == null) {
            return null;
        }
        return DatasetUtils.findRangeBounds((XYDataset)dataset, (boolean)false);
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Preconditions.checkState((boolean)(dataset instanceof IntervalXYDataset), (Object)"Must be an IntervalXYDataset");
        IntervalXYDataset interval = (IntervalXYDataset)dataset;
        double x = dataset.getXValue(series, item);
        double y = dataset.getYValue(series, item);
        double z = 0.0;
        if (dataset instanceof XYZDataset) {
            z = ((XYZDataset)dataset).getZValue(series, item);
        }
        Paint p = this.paintScale.getPaint(z);
        double xx0 = domainAxis.valueToJava2D(interval.getStartXValue(series, item), dataArea, plot.getDomainAxisEdge());
        double yy0 = rangeAxis.valueToJava2D(interval.getStartYValue(series, item), dataArea, plot.getRangeAxisEdge());
        double xx1 = domainAxis.valueToJava2D(interval.getEndXValue(series, item), dataArea, plot.getDomainAxisEdge());
        double yy1 = rangeAxis.valueToJava2D(interval.getEndYValue(series, item), dataArea, plot.getRangeAxisEdge());
        PlotOrientation orientation = plot.getOrientation();
        Rectangle2D.Double block = orientation.equals((Object)PlotOrientation.HORIZONTAL) ? new Rectangle2D.Double(Math.min(yy0, yy1), Math.min(xx0, xx1), Math.abs(yy1 - yy0), Math.abs(xx0 - xx1)) : new Rectangle2D.Double(Math.min(xx0, xx1), Math.min(yy0, yy1), Math.abs(xx1 - xx0), Math.abs(yy1 - yy0));
        g2.setPaint(p);
        g2.fill(block);
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(block);
        if (this.isItemLabelVisible(series, item)) {
            this.drawItemLabel(g2, orientation, dataset, series, item, block.getCenterX(), block.getCenterY(), y < 0.0);
        }
        int datasetIndex = plot.indexOf(dataset);
        double transX = domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
        double transY = rangeAxis.valueToJava2D(y, dataArea, plot.getRangeAxisEdge());
        this.updateCrosshairValues(crosshairState, x, y, datasetIndex, transX, transY, orientation);
        EntityCollection entities = state.getEntityCollection();
        if (entities != null) {
            this.addEntity(entities, block, dataset, series, item, block.getCenterX(), block.getCenterY());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYIntervalBlockRenderer)) {
            return false;
        }
        XYIntervalBlockRenderer that = (XYIntervalBlockRenderer)obj;
        if (!this.paintScale.equals((Object)that.paintScale)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        XYIntervalBlockRenderer clone = (XYIntervalBlockRenderer)super.clone();
        if (this.paintScale instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)this.paintScale;
            clone.paintScale = (PaintScale)pc.clone();
        }
        return clone;
    }
}

