/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.condor;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.NoSuchElementException;
import org.opensha.commons.hpc.condor.ParentChildRelationship;
import org.opensha.commons.hpc.condor.SubmitScriptForDAG;

public class DAG {
    public static DateFormat df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
    private ArrayList<SubmitScriptForDAG> scripts = new ArrayList();
    private ArrayList<ParentChildRelationship> relationships = new ArrayList();
    private String globalComments = "";
    private String dotFileName = null;
    private boolean dotUpdate = true;

    public void addJob(SubmitScriptForDAG script) {
        this.validateJobName(script.getJobName());
        this.verifyDoesntExist(script.getJobName());
        this.scripts.add(script);
    }

    public void addJob(SubmitScriptForDAG script, String comment) {
        this.addJob(script);
        script.setComment(comment);
    }

    public ArrayList<SubmitScriptForDAG> getJobs() {
        return this.scripts;
    }

    public ArrayList<ParentChildRelationship> getRelationships() {
        return this.relationships;
    }

    public void addParentChildRelationship(ParentChildRelationship relationship) {
        boolean hasParent = false;
        boolean hasChild = false;
        for (SubmitScriptForDAG script : this.scripts) {
            if (script.getJobName().equals(relationship.getParent().getJobName())) {
                hasParent = true;
            }
            if (script.getJobName().equals(relationship.getChild().getJobName())) {
                hasChild = true;
            }
            if (!hasParent || !hasChild) continue;
            break;
        }
        if (!hasParent) {
            throw new IllegalArgumentException("Parent job '" + relationship.getParent().getJobName() + " is not yet part of this DAG!");
        }
        if (!hasChild) {
            throw new IllegalArgumentException("Child job '" + relationship.getChild().getJobName() + " is not yet part of this DAG!");
        }
        this.relationships.add(relationship);
    }

    public void addParentChildRelationship(SubmitScriptForDAG parent, SubmitScriptForDAG child) {
        this.addParentChildRelationship(new ParentChildRelationship(parent, child));
    }

    public void addParentChildRelationship(SubmitScriptForDAG parent, SubmitScriptForDAG child, String comment) {
        ParentChildRelationship relationship = new ParentChildRelationship(parent, child);
        relationship.setComment(comment);
        this.addParentChildRelationship(relationship);
    }

    public void addDAG(DAG dag, DAG_ADD_LOCATION location) {
        if (location == null) {
            throw new NullPointerException("You must specify an add location for the new DAG!");
        }
        for (SubmitScriptForDAG newScript : dag.scripts) {
            this.verifyDoesntExist(newScript.getJobName());
        }
        ArrayList<ParentChildRelationship> newRelationships = new ArrayList<ParentChildRelationship>();
        if (location == DAG_ADD_LOCATION.BEFORE_ALL) {
            for (SubmitScriptForDAG newScript : dag.scripts) {
                if (!dag.isBottomLevel(newScript.getJobName())) continue;
                for (SubmitScriptForDAG oldScript : this.scripts) {
                    if (!this.isTopLevel(oldScript.getJobName())) continue;
                    newRelationships.add(new ParentChildRelationship(newScript, oldScript));
                }
            }
        } else if (location == DAG_ADD_LOCATION.AFTER_ALL) {
            for (SubmitScriptForDAG newScript : dag.scripts) {
                if (!dag.isTopLevel(newScript.getJobName())) continue;
                for (SubmitScriptForDAG oldScript : this.scripts) {
                    if (!this.isBottomLevel(oldScript.getJobName())) continue;
                    newRelationships.add(new ParentChildRelationship(oldScript, newScript));
                }
            }
        }
        this.scripts.addAll(dag.scripts);
        this.relationships.addAll(dag.relationships);
        this.relationships.addAll(newRelationships);
    }

    public boolean containsJob(String jobName) {
        for (SubmitScriptForDAG oldScript : this.scripts) {
            if (!oldScript.getJobName().equals(jobName)) continue;
            return true;
        }
        return false;
    }

    private void validateJobName(String jobName) {
        String[] forbidden;
        if (jobName == null) {
            throw new NullPointerException("Script job name cannot be null!");
        }
        for (String badStr : forbidden = new String[]{" ", ",", "\n", "\t", "/", "\\", "<", ">"}) {
            if (!jobName.contains(badStr)) continue;
            throw new IllegalArgumentException("jobName '" + jobName + "' cannot contain '" + badStr + "'");
        }
    }

    private void verifyDoesntExist(String jobName) throws NoSuchElementException {
        if (this.containsJob(jobName)) {
            throw new IllegalArgumentException("A script already exists in this DAG with the name '" + jobName + "'");
        }
    }

    private void verifyExists(String jobName) throws NoSuchElementException {
        if (!this.containsJob(jobName)) {
            throw new NoSuchElementException("Job '" + jobName + "' doesn't exist in this DAG!");
        }
    }

    public boolean isTopLevel(String jobName) {
        this.verifyExists(jobName);
        for (ParentChildRelationship rel : this.relationships) {
            if (!rel.getChild().getJobName().equals(jobName)) continue;
            return false;
        }
        return true;
    }

    public boolean isBottomLevel(String jobName) {
        this.verifyExists(jobName);
        for (ParentChildRelationship rel : this.relationships) {
            if (!rel.getParent().getJobName().equals(jobName)) continue;
            return false;
        }
        return true;
    }

    public String getDAG() {
        Object dag = "";
        dag = (String)dag + "# Condor DAG automatically generated by " + this.getClass().getCanonicalName() + "\n";
        dag = (String)dag + "# date: " + df.format(new Date()) + "\n";
        dag = (String)dag + "\n";
        if (this.globalComments != null && this.globalComments.length() > 0) {
            dag = (String)dag + this.globalComments + "\n";
        }
        dag = (String)dag + "\t## Condor Submit Scripts ##\n\n";
        for (SubmitScriptForDAG script : this.scripts) {
            String fileName;
            if (script.hasComment()) {
                String comment = script.getComment();
                dag = (String)dag + DAG.checkAddNewline(comment);
            }
            if ((fileName = script.getFileName()) == null || fileName.length() <= 0) {
                throw new NullPointerException("Job '" + script.getJobName() + "' has no file name!");
            }
            dag = (String)dag + "JOB " + script.getJobName() + " " + fileName + "\n";
            if (script.hasPreScript()) {
                dag = (String)dag + "SCRIPT PRE " + script.getJobName() + " " + DAG.checkAddNewline(script.getPreScript());
            }
            if (script.hasPostScript()) {
                dag = (String)dag + "SCRIPT POST " + script.getJobName() + " " + DAG.checkAddNewline(script.getPostScript());
            }
            if (!script.hasRetries()) continue;
            dag = (String)dag + "RETRY " + script.getJobName() + " " + script.getRetries() + "\n";
        }
        dag = (String)dag + "\n\t## Parent Child Relationships ##\n\n";
        for (ParentChildRelationship relationship : this.relationships) {
            dag = (String)dag + relationship.toString() + "\n";
        }
        dag = (String)dag + "\n";
        if (this.dotFileName != null && this.dotFileName.length() > 0) {
            dag = (String)dag + "DOT " + this.dotFileName;
            if (this.dotUpdate) {
                dag = (String)dag + " UPDATE";
            }
            dag = (String)dag + "\n";
        }
        dag = (String)dag + "\n## END DAG ##\n";
        return dag;
    }

    public void writeDag(String fileName) throws IOException {
        FileWriter fw = new FileWriter(fileName);
        fw.write(this.getDAG());
        fw.close();
    }

    public static String checkAddNewline(String line) {
        if (!((String)line).endsWith("\n")) {
            line = (String)line + "\n";
        }
        return line;
    }

    public void setGlobalComments(String globalComments) {
        if (globalComments != null && ((String)globalComments).length() > 0 && !((String)globalComments).startsWith("#")) {
            globalComments = "#" + (String)globalComments;
        }
        this.globalComments = globalComments;
    }

    public void setDotFile(String dotFileName) {
        this.dotFileName = dotFileName;
    }

    public void setDotFile(String dotFileName, boolean dotUpdate) {
        this.setDotFile(dotFileName);
        this.dotUpdate = dotUpdate;
    }

    public int getNumJobs() {
        return this.scripts.size();
    }

    public static enum DAG_ADD_LOCATION {
        BEFORE_ALL("before"),
        AFTER_ALL("after"),
        PARALLEL("parallel");

        private String loc;

        private DAG_ADD_LOCATION(String loc) {
            this.loc = loc;
        }
    }
}

