/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.mpj;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.hpc.JavaShellScriptWriter;

public class FastMPJShellScriptWriter
extends JavaShellScriptWriter {
    public static final String XML_METADATA_NAME = "MPJShellScriptWriter";
    private static Device DEVICE_DEFAULT = Device.NIODEV;
    private File mpjHome;
    private Device device;
    private boolean useLaunchWrapper = false;

    private FastMPJShellScriptWriter(JavaShellScriptWriter javaWriter, File mpjHome) {
        this(javaWriter, mpjHome, DEVICE_DEFAULT);
    }

    private FastMPJShellScriptWriter(JavaShellScriptWriter javaWriter, File mpjHome, Device device) {
        this(javaWriter.getJavaBin(), javaWriter.getMaxHeapSizeMB(), javaWriter.getClasspath(), mpjHome, device);
    }

    public FastMPJShellScriptWriter(File javaBin, int heapSizeMB, Collection<File> classpath, File mpjHome) {
        this(javaBin, heapSizeMB, classpath, mpjHome, DEVICE_DEFAULT);
    }

    public FastMPJShellScriptWriter(File javaBin, int heapSizeMB, Collection<File> classpath, File mpjHome, Device device) {
        super(javaBin, heapSizeMB, classpath);
        this.setMpjHome(mpjHome);
        this.device = device;
    }

    public void setMpjHome(File mpjHome) {
        Preconditions.checkNotNull((Object)mpjHome, (Object)"MPJ_HOME cannot be null!");
        this.mpjHome = mpjHome;
    }

    public File getMpjHome() {
        return this.mpjHome;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Device getDevice() {
        return this.device;
    }

    public boolean isUseLaunchWrapper() {
        return this.useLaunchWrapper;
    }

    public void setUseLaunchWrapper(boolean useLaunchWrapper) {
        this.useLaunchWrapper = useLaunchWrapper;
    }

    @Override
    public void setAutoMemDetect(boolean autoMemDetect) {
        Preconditions.checkState((!autoMemDetect ? 1 : 0) != 0, (Object)"Not supported for FastMPJ as will only affect node 0");
        super.setAutoMemDetect(autoMemDetect);
    }

    @Override
    public List<String> buildScript(List<String> classNames, List<String> argss) {
        ArrayList<String> script = new ArrayList<String>();
        script.add("#!/bin/bash");
        script.add("");
        script.add("export FMPJ_HOME=" + this.mpjHome.getAbsolutePath());
        script.add("export PATH=$PATH:$FMPJ_HOME/bin");
        script.add("");
        script.add("if [[ -e $PBS_NODEFILE ]]; then");
        script.add("  #count the number of processors assigned by PBS");
        script.add("  NP=`wc -l < $PBS_NODEFILE`");
        script.add("  echo \"Running on $NP processors: \"`cat $PBS_NODEFILE`");
        script.add("else");
        script.add("  echo \"This script must be submitted to PBS with 'qsub -l nodes=X'\"");
        script.add("  exit 1");
        script.add("fi");
        script.add("");
        script.add("if [[ $NP -le 0 ]]; then");
        script.add("  echo \"invalid NP: $NP\"");
        script.add("  exit 1");
        script.add("fi");
        script.add("");
        script.addAll(this.getAllSetupLines());
        String launchCommand = this.isUseLaunchWrapper() ? "fmpjrun_errdetect_wrapper.sh" : "fmpjrun";
        String dev = this.getDevice().getDeviceName();
        for (int i = 0; i < classNames.size(); ++i) {
            script.add("");
            script.add("date");
            script.add("echo \"RUNNING FMPJ\"");
            String command = launchCommand + " -machinefile $PBS_NODEFILE -np $NP -dev " + dev + " -Djava.library.path=$FMPJ_HOME/lib";
            command = command + this.getJVMArgs(" ");
            if (!command.endsWith(" ")) {
                command = command + " ";
            }
            command = command + "-class " + classNames.get(i);
            command = command + FastMPJShellScriptWriter.getFormattedArgs(argss.get(i));
            script.add(command);
            script.add("ret=$?");
            script.add("");
            script.add("date");
            script.add("echo \"DONE with process " + i + ". EXIT CODE: $ret\"");
        }
        script.add("");
        script.add("exit $ret");
        return script;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element mpjEl = root.addElement(XML_METADATA_NAME);
        mpjEl.addElement("mpjHome", this.mpjHome.getAbsolutePath());
        mpjEl.addElement("device", this.device.name());
        super.toXMLMetadata(mpjEl);
        return root;
    }

    public static FastMPJShellScriptWriter fromXMLMetadata(Element mpjEl) {
        File mpjHome = new File(mpjEl.attributeValue("mpjHome"));
        Attribute deviceAtt = mpjEl.attribute("device");
        Device device = DEVICE_DEFAULT;
        if (deviceAtt != null) {
            device = Device.valueOf(deviceAtt.getValue());
        }
        JavaShellScriptWriter javaWriter = JavaShellScriptWriter.fromXMLMetadata(mpjEl.element("JavaShellScriptWriter"));
        return new FastMPJShellScriptWriter(javaWriter, mpjHome, device);
    }

    public static enum Device {
        NIODEV("niodev"),
        MXDEV("mxdev");

        private String name;

        private Device(String name) {
            this.name = name;
        }

        public String getDeviceName() {
            return this.name;
        }
    }
}

