/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.hpc.mpj;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.hpc.JavaShellScriptWriter;

public class MPJExpressShellScriptWriter
extends JavaShellScriptWriter {
    public static final String XML_METADATA_NAME = "MPJShellScriptWriter";
    private static Device DEVICE_DEFAULT = Device.HYBDEV;
    private File mpjHome;
    private Device device;
    private boolean useLaunchWrapper = true;

    private MPJExpressShellScriptWriter(JavaShellScriptWriter javaWriter, File mpjHome, Device device) {
        this(javaWriter.getJavaBin(), javaWriter.getMaxHeapSizeMB(), javaWriter.getClasspath(), mpjHome, device);
    }

    public MPJExpressShellScriptWriter(File javaBin, int heapSizeMB, Collection<File> classpath, File mpjHome) {
        this(javaBin, heapSizeMB, classpath, mpjHome, DEVICE_DEFAULT);
    }

    public MPJExpressShellScriptWriter(File javaBin, int heapSizeMB, Collection<File> classpath, File mpjHome, Device device) {
        super(javaBin, heapSizeMB, classpath);
        this.setMpjHome(mpjHome);
        this.device = device;
    }

    public void setMpjHome(File mpjHome) {
        Preconditions.checkNotNull((Object)mpjHome, (Object)"MPJ_HOME cannot be null!");
        this.mpjHome = mpjHome;
    }

    public File getMpjHome() {
        return this.mpjHome;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Device getDevice() {
        return this.device;
    }

    public boolean isUseLaunchWrapper() {
        return this.useLaunchWrapper;
    }

    public void setUseLaunchWrapper(boolean useLaunchWrapper) {
        this.useLaunchWrapper = useLaunchWrapper;
    }

    @Override
    public List<String> buildScript(List<String> classNames, List<String> argss) {
        ArrayList<String> script = new ArrayList<String>();
        script.add("#!/bin/bash");
        script.add("");
        script.add("export MPJ_HOME=" + this.mpjHome.getAbsolutePath());
        script.add("export PATH=$PATH:$MPJ_HOME/bin");
        String dev = this.getDevice().getDeviceName();
        if (this.useLaunchWrapper) {
            script.add("");
            script.addAll(this.getAllSetupLines());
            for (int i = 0; i < classNames.size(); ++i) {
                script.add("");
                script.add("date");
                script.add("echo \"RUNNING MPJ\"");
                String command = "mpjrun_errdetect_wrapper.sh $PBS_NODEFILE -dev " + dev + " -Djava.library.path=$MPJ_HOME/lib";
                command = command + this.getJVMArgs(classNames.get(i));
                String myArgs = argss.get(i);
                Preconditions.checkState((!myArgs.contains("\n") ? 1 : 0) != 0, (Object)"MPJExpress commands don't support newlines (sadly)");
                command = command + MPJExpressShellScriptWriter.getFormattedArgs(myArgs);
                script.add(command);
                script.add("ret=$?");
                script.add("date");
                script.add("");
                script.add("exit $ret");
            }
        } else {
            script.add("");
            script.add("if [[ -e $PBS_NODEFILE ]]; then");
            script.add("  #count the number of processors assigned by PBS");
            script.add("  NP=`wc -l < $PBS_NODEFILE`");
            script.add("  echo \"Running on $NP processors: \"`cat $PBS_NODEFILE`");
            script.add("else");
            script.add("  echo \"This script must be submitted to PBS with 'qsub -l nodes=X'\"");
            script.add("  exit 1");
            script.add("fi");
            script.add("");
            script.add("if [[ $NP -le 0 ]]; then");
            script.add("  echo \"invalid NP: $NP\"");
            script.add("  exit 1");
            script.add("fi");
            script.add("");
            script.add("date");
            script.add("echo \"STARTING MPJ\"");
            script.add("mpjboot $PBS_NODEFILE");
            script.add("");
            script.addAll(this.getJVMSetupLines());
            for (int i = 0; i < classNames.size(); ++i) {
                script.add("");
                script.add("date");
                script.add("echo \"RUNNING MPJ\"");
                String command = "mpjrun.sh -machinesfile $PBS_NODEFILE -np $NP -dev " + dev + " -Djava.library.path=$MPJ_HOME/lib";
                command = command + this.getJVMArgs(classNames.get(i));
                String myArgs = argss.get(i);
                Preconditions.checkState((!myArgs.contains("\n") ? 1 : 0) != 0, (Object)"MPJExpress commands don't support newlines (sadly)");
                command = command + MPJExpressShellScriptWriter.getFormattedArgs(myArgs);
                script.add(command);
            }
            script.add("ret=$?");
            script.add("");
            script.add("date");
            script.add("echo \"HALTING MPJ\"");
            script.add("mpjhalt $PBS_NODEFILE");
            script.add("");
            script.add("exit $ret");
        }
        return script;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element mpjEl = root.addElement(XML_METADATA_NAME);
        mpjEl.addElement("mpjHome", this.mpjHome.getAbsolutePath());
        mpjEl.addElement("device", this.device.name());
        super.toXMLMetadata(mpjEl);
        return root;
    }

    public static MPJExpressShellScriptWriter fromXMLMetadata(Element mpjEl) {
        File mpjHome = new File(mpjEl.attributeValue("mpjHome"));
        Attribute deviceAtt = mpjEl.attribute("device");
        Device device = DEVICE_DEFAULT;
        if (deviceAtt != null) {
            device = Device.valueOf(deviceAtt.getValue());
        }
        JavaShellScriptWriter javaWriter = JavaShellScriptWriter.fromXMLMetadata(mpjEl.element("JavaShellScriptWriter"));
        return new MPJExpressShellScriptWriter(javaWriter, mpjHome, device);
    }

    public static enum Device {
        NIODEV("niodev"),
        HYBDEV("hybdev");

        private String name;

        private Device(String name) {
            this.name = name;
        }

        public String getDeviceName() {
            return this.name;
        }
    }
}

